      subroutine bioparm
c
c=======================================================================
c                                                                    ===
c  This routine reads in the control parameters for the biological   ===
c  module.  This particular version reads the parameters for the     ===
c  Fasham model (CPP option "bioFasham")                             ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <rhomean.h>
#include <cvmix.h>
#include <cbiopnh.h>
#include <iounits.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,icard,ios,lenstr
      integer lnblk
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Open input file for Fasham biological Model.
c-----------------------------------------------------------------------
c
      lenstr = lnblk (bparnam,len(bparnam))
      open (bioinp, file=bparnam(1:lenstr), form='formatted',
     *      status='old', iostat=ios)
      if (ios.ne.0) then
         write (stdout,900) bparnam(1:lenstr)
         call exitus ('BIOPARM')
      end if
c
      write(stdout,1060)
c
c-----------------------------------------------------------------------
c  Read in input parameters for Fasham biological Model.
c-----------------------------------------------------------------------
c
      read (bioinp,*,iostat=ios) icard
c
      do 20 while ((ios.eq.0) .and. (icard.gt.0) .and. (icard.lt.99))
c
         if (icard.eq.1) then
            read (bioinp,*,iostat=ios) attphy,parfrac
            if (ios.eq.0) then
               write (stdout,1070) attphy,parfrac
               attphy=attphy*cm2m
            end if
c
          elseif (icard.eq.2) then
            read(bioinp,*,iostat=ios) phygrth,phyexud,phylr1
            if (ios.eq.0) then
               write(stdout,1080) phygrth,phyexud,phylr1
               phygrth=phygrth*sec2day*rho0*cp/c1e6
               phylr1=phylr1*sec2day
            end if
c
          elseif (icard.eq.3) then
            read (bioinp,*,iostat=ios) grthpa,grthpb,grthpc
            if (ios.eq.0) then
               write (stdout,1090) grthpa,grthpb,grthpc
               grthpa=grthpa*sec2day
            end if
c
          elseif (icard.eq.4) then
            read (bioinp,*,iostat=ios) hsno3,hsnh4,no3inh
            if (ios.eq.0) write(stdout,1100) hsno3,hsnh4,no3inh
c
          elseif (icard.eq.5) then
            read (bioinp,*,iostat=ios) zgrazr,zgrazk,zasseff
            if (ios.eq.0) then
               write(stdout,1110) zgrazr,zgrazk,zasseff
               zgrazr=zgrazr*sec2day
            end if
c
          elseif (icard.eq.6) then
            read (bioinp,*,iostat=ios) prefphy,prefbac,prefpon
            if (ios.eq.0) write (stdout,1120) prefphy,prefbac,prefpon
c
          elseif (icard.eq.7) then
            read (bioinp,*,iostat=ios) zexcrr,zexcnh4
            if (ios.eq.0) then
               write (stdout,1130) zexcrr,zexcnh4
               zexcrr=zexcrr*sec2day
            end if
c
          elseif (icard.eq.8) then
            read (bioinp,*,iostat=ios) zmortr,zmortex
            if (ios.eq.0) then
               write (stdout,1140) zmortr,zmortex
               zmortr=zmortr*sec2day
            end if
c
          elseif (icard.eq.9) then
            read (bioinp,*,iostat=ios) bacgrr,bacgrk,bacfrac,bexcrr
            if (ios.eq.0) then
               write (stdout,1150) bacgrr,bacgrk,bacfrac,bexcrr
               bacgrr=bacgrr*sec2day
               bexcrr=bexcrr*sec2day
            end if
c
          elseif (icard.eq.10) then
            read (bioinp,*,iostat=ios) wsnkpon,brknpon
            if (ios.eq.0) then
               write (stdout,1160) wsnkpon,brknpon
               wsnkpon=wsnkpon*m2cm*sec2day
               brknpon=brknpon*sec2day
            end if
c
          elseif (icard.eq.11) then
            read (bioinp,*,iostat=ios) rmnbio,rmnpon1,rmnpon2,rmnnh4
            if (ios.eq.0) then
               write (stdout,1170) rmnbio,rmnpon1,rmnpon2,rmnnh4
               rmnbio=rmnbio*sec2day
               rmnpon1=rmnpon1*sec2day
               rmnpon2=rmnpon2*sec2day
               rmnnh4=rmnnh4*sec2day
            end if
c
          elseif (icard.eq.12) then
            read (bioinp,*,iostat=ios) sbldep
            if (ios.eq.0) then
               write (stdout,1180) sbldep
               sbldep=sbldep*m2cm
            end if
c
          elseif (icard.eq.13) then
            read (bioinp,*,iostat=ios) biopos
            if (ios.eq.0) write (stdout,1190) biopos
#if !defined codunlim & !defined codlim
c
          elseif (icard.eq.14) then
             read (bioinp,*,iostat=ios) (ibiout(i),i=1,10)
c
          elseif (icard.eq.15) then
             read (bioinp,*,iostat=ios) (ibiout(i),i=11,20)
         end if
# else
c
          elseif (icard.eq.14) then
             read (bioinp,*,iostat=ios) cdzmin,cdzmax,cdkz,cdkp,cdtmin,
     &                                  cdtmax,cdkt,cdspd,cdwmax
            if (ios.eq.0) then
#  ifdef codunlim
               write (stdout,1200) cdzmin,cdzmax,cdkz,cdkp,cdtmin,
     *                             cdtmax,cdkt,cdwmax
#   else
               write (stdout,1200) cdzmin,cdzmax,cdkz,cdkp,cdtmin,
     *                             cdtmax,cdkt,cdspd,cdwmax
#  endif
               cdzmin = cdzmin*m2cm
               cdzmax = cdzmax*m2cm
            end if
c
          elseif (icard.eq.15) then
             read (bioinp,*,iostat=ios) (ibiout(i),i=1,10)
c
          elseif (icard.eq.16) then
             read (bioinp,*,iostat=ios) (ibiout(i),i=11,20)
         end if
#endif
c
         if (ios.eq.0) read (bioinp,*,iostat=ios) icard
  20  continue
c
      if (ios.ne.0) then
        write (stdout,910) icard
        call exitus ('BIOPARM')
      endif
c
      return
c
 900  format (/' BIOPARM - could not find input file: ',a)
 910  format (/' BIOPARM - read error at or near biological input card:'
     &        ,1x,i4)
1060  format(/' Biological model input parameters:'/)
1070  format(
     *  f10.4,'  ATTPHY   phytoplankton light attenuation scale ',
     *                    '(liter umoles-1 cm-1)'/
     *  f10.4,'  PARFRAC  fraction of shortwave radiation that is ',
     *                    'PAR (nondim)')
1080  format(
     *  f10.4,'  PHYGRTH  initial slope of P-I curve (Watt-1 m^2 ',
     *                    'day-1)'/
     *  f10.4,'  PHYEXUD  fraction of primary production exuded as ',
     *                    'DON (nondimen)'/
     *  f10.4,'  PHYLR1   phytoplankton mortality rate (day-1)')
1090  format(
     *  f10.4,'  GRTHPA   temperature-dependent growth rate parameter',
     *                    ' "a" (day-1)'/
     *  f10.4,'  GRTHPB   temperature-dependent growth rate parameter',
     *                    ' "b" (nondimen)'/
     *  f10.4,'  GRTHPC   temperature-dependent growth rate parameter',
     *                    ' "c" (degC-1)')
1100  format(
     *  f10.4,'  HSNO3    half saturation constant for nitrate uptake ',
     *                    '(umoles/l)'/
     *  f10.4,'  HSNH4    half saturation constant for ammonium uptake '
     *                    ,'(umoles/l)'/
     *  f10.4,'  NO3INH   strength of NH4 inhibition of NO3 ',
     *                    'uptake (l/umoles)')
1110  format(
     *  f10.4,'  ZGRAZR   zooplankton maximum growth rate (day-1)'/
     *  f10.4,'  ZGRAZK   zooplankton growth half-saturation constant',
     *                    ' (umoles/l)'/
     *  f10.4,'  ZASSEFF  zooplankton assimilation efficiency fraction',
     *                    ' (nondimen)')
1120  format(
     *  f10.4,'  PREFPHY  zooplankton grazing preference for ',
     *                    'phytoplankton (nondim)'/
     *  f10.4,'  PREFBAC  zooplankton grazing preference for ',
     *                    'bacteria (nondim)'/
     *  f10.4,'  PREFPON  zooplankton grazing preference for ',
     *                    'PON (nondim)')
1130  format(
     *  f10.4,'  ZEXCRR   zooplankton excretion rate (day-1)'/
     *  f10.4,'  ZEXCNH4  fraction of zooplankton excretion to NH4',
     *                    ' (nondimensional)')
1140  format(
     *  f10.4,'  ZMORTR   zooplankton mortality rate (day-1)'/
     *  f10.4,'  ZMORTEX  fraction of zooplankton mortality to export',
     *                    ' (nondimen)')
1150  format(
     *  f10.4,'  BACGRR   bacteria maximum growth rate (day-1)'/
     *  f10.4,'  BACGRK   bacteria uptake half-saturation constant',
     *                    ' (umoles/l)'/
     *  f10.4,'  BACFRAC  bacterial ratio of NH4/DON uptake ',
     *                    '(nondimensional)'/
     *  f10.4,'  BEXCRR   bacteria excretion rate to NH4 (day-1)')
1160  format(
     *  f10.4,'  WSNKPON  PON sinking rate (m/day)'/
     *  f10.4,'  BRKNPON  PON breakdown rate to DON (day-1)')
1170  format(
     *  f10.4,'  RMNBIO   aphotic zone decay timescale for PHY, ',
     *                    'ZOO, BAC, DON (day-1)'/
     *  f10.4,'  RMNPON1  linear aphotic zone decay timescale for',
     *                    ' PON (day-1)'/
     *  f10.4,'  RMNPON2  quadratic decay timescale for PON (liter',
     *                    ' umole-1 day-1)'/
     *  f10.4,'  RMNNH4   aphotic zone decay timescale for NH4 (day-1)')
1180  format(
     *  f10.4,'  SBLDEP   euphotic zone depth (m)')
1190  format(
     *  4x,i6,'  BIOPOS   switch to enforce non-negative biological ',
     *                    'tracers')
#if defined codunlim
1200  format(
     *1pe10.3,'  CDZMIN   Cod minimum preferred depth (m)'/
     *1pe10.3,'  CDZMAX   Cod maximum preferred depth (m)'/
     *1pe10.3,'  CDKZ     Cod response to depth coefficient (cm/s)'/
     *1pe10.3,'  CDKP     Cod response to prey coefficient ',
     *                    '(cm^2 l)/(s umole N)'/
     *1pe10.3,'  CDTMIN   Cod minimum preferred temperature (deg C)'/
     *1pe10.3,'  CDTMAX   Cod maximum preferred temperature (deg C)'/
     *1pe10.3,'  CDKT     Cod response to temperature coefficient ',
     *                    'cm^2/[s (deg C)^2]'/
     *1pe10.3,'  CDWMAX   Cod maximum vertical swimming speed (cm/s)')
# elif defined codlim
1200  format(
     *1pe10.3,'  CDZMIN   Cod minimum preferred depth (m)'/
     *1pe10.3,'  CDZMAX   Cod maximum preferred depth (m)'/
     *1pe10.3,'  CDKZ     Cod response to depth coefficient (nondim)'/
     *1pe10.3,'  CDKP     Cod response to prey coefficient ',
     *                    '(cm l)/(umole N)'/
     *1pe10.3,'  CDTMIN   Cod minimum preferred temperature (deg C)'/
     *1pe10.3,'  CDTMAX   Cod maximum preferred temperature (deg C)'/
     *1pe10.3,'  CDKT     Cod response to temperature coefficient ',
     *                    'cm/(deg C)^2'/
     *1pe10.3,'  CDSPD    Cod maximum swimming speed (cm/s)'/
     *1pe10.3,'  CDWMAX   Cod maximum vertical swimming speed (cm/s)')
#endif
c
      end
