      subroutine bioparm
c
c=======================================================================
c                                                                    ===
c  This routine reads in the control parameters for the biological   ===
c  module.  This particular version reads the parameters for the     ===
c  McGillicuddy model (CPP option "bioMcGillic")                     ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <cbiopnh.h>
#include <iounits.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,icard,ios,lenstr
      integer lnblk
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Open input file for McGillicuddy et al. biological Model.
c-----------------------------------------------------------------------
c
      lenstr = lnblk (bparnam,len(bparnam))
      open (bioinp, file=bparnam(1:lenstr), form='formatted',
     *      status='old', iostat=ios)
      if (ios.ne.0) then
         write (stdout,900) bparnam(1:lenstr)
         call exitus ('BIOPARM')
      end if
c
      write(stdout,1060)
c
c-----------------------------------------------------------------------
c  Read in input parameters for McGillicuddy et al. biological Model.
c-----------------------------------------------------------------------
c
      read (bioinp,*,iostat=ios) icard
c
      do 20 while ((ios.eq.0) .and. (icard.gt.0) .and. (icard.lt.99))
c
         if (icard.eq.1) then
            read (bioinp,*,iostat=ios) atth2o1,attphy
            if (ios.eq.0) then
               write (stdout,1070) atth2o1,attphy
               atth2o1=atth2o1*cm2m
               attphy=attphy*cm2m
            end if
c
          elseif (icard.eq.2) then
            read(bioinp,*,iostat=ios) hsno3
            if (ios.eq.0) write(stdout,1080) hsno3
c
          elseif (icard.eq.3) then
            read (bioinp,*,iostat=ios) grazrm,civlev,zoolr1,zoolr2,
     &                                 zooexc1
            if (ios.eq.0) then
               write (stdout,1090) grazrm,civlev,zoolr1,zoolr2,zooexc1
            end if
c
          elseif (icard.eq.4) then
            read (bioinp,*,iostat=ios) photorm,photor0,photoinh
            if (ios.eq.0) write (stdout,1100) photorm,photor0,photoinh
c
          elseif (icard.eq.5) then
            read (bioinp,*,iostat=ios) no3inh,hsnh4
            if (ios.eq.0) write (stdout,1110) no3inh,hsnh4
c
          elseif (icard.eq.6) then
            read (bioinp,*,iostat=ios) sinkphy,sinkfac
            if (ios.eq.0) then
               write (stdout,1120) sinkphy,sinkfac
               sinkphy=sinkphy*m2cm
               sinkfac=sinkfac*m2cm
            end if
c
          elseif (icard.eq.7) then
            read (bioinp,*,iostat=ios) zooexp1,zooexp2
            if (ios.eq.0) write (stdout,1130) zooexp1,zooexp2
c
          elseif (icard.eq.8) then
            read (bioinp,*,iostat=ios) parfrac
            if (ios.eq.0) write (stdout,1140) parfrac
c
          elseif (icard.eq.9) then
            read (bioinp,*,iostat=ios) sbldep
            if (ios.eq.0) then
               write (stdout,1150) sbldep
               sbldep=sbldep*m2cm
            end if
c
          elseif (icard.eq.10) then
             read (bioinp,*,iostat=ios) biopos
            if (ios.eq.0) write (stdout,1160) biopos
#if !defined codunlim & !defined codlim
c
          elseif (icard.eq.11) then
             read (bioinp,*,iostat=ios) (ibiout(i),i=1,8)
         end if
# else
c
          elseif (icard.eq.11) then
             read (bioinp,*,iostat=ios) cdzmin,cdzmax,cdkz,cdkp,cdtmin,
     &                                  cdtmax,cdkt,cdspd,cdwmax
            if (ios.eq.0) then
#  ifdef codunlim
               write (stdout,1170) cdzmin,cdzmax,cdkz,cdkp,cdtmin,
     *                             cdtmax,cdkt,cdwmax
#   else
               write (stdout,1170) cdzmin,cdzmax,cdkz,cdkp,cdtmin,
     *                             cdtmax,cdkt,cdspd,cdwmax
#  endif
               cdzmin = cdzmin*m2cm
               cdzmax = cdzmax*m2cm
            end if
c
          elseif (icard.eq.12) then
             read (bioinp,*,iostat=ios) (ibiout(i),i=1,9)
         end if
#endif
c
         if (ios.eq.0) read (bioinp,*,iostat=ios) icard
  20  continue
c
      if (ios.ne.0) then
        write (stdout,910) icard
        call exitus ('BIOPARM')
      endif
c
      return
c
 900  format (/' BIOPARM - could not find input file: ',a)
 910  format (/' BIOPARM - read error at or near biological input card:'
     &        ,1x,i4)
1060  format(/' Biological model input parameters:'/)
1070  format(
     *1pe10.3,'  ATTH2O1  light attenuation scale of seawater ',
     *                    '(m-1)'/
     *1pe10.3,'  ATTPHY   phytoplankton light attenuation scale ',
     *                    '(liter umoles-1 m-1)')
1080  format(
     *  f10.4,'  HSNO3    half saturation constant for nitrate uptake ',
     *                    '(umoles/l)')
1090  format(
     *1pe10.3,'  GRAZRM   maximum zooplankton grazing rate (1/s)'/0p,
     *  f10.4,'  CIVLEV   Ivlev grazing constant (l/umoles)'/
     *1pe10.3,'  ZOOLR1   linear heterotrophic loss rate (1/s)'/
     *1pe10.3,'  ZOOLR2   quadratic heterotrophic loss rate ',
     *                    '(1/s l/umoles)'/0p,
     *  f10.4,'  ZOOEXC1  heterotroph ammonium excretion fraction ',
     *                    '(nondimensional)')
1100  format(
     *1pe10.3,'  PHOTORM  maximum photosynthetic rate (1/s)'/
     *1pe10.3,'  PHOTOR0  initial slope of photosynthesic light ',
     *                    'response (cm^2/cal)'/
     *1pe10.3,'  PHOTOINH photoinhibition response (cm^2/cal)')
1110  format(
     *  f10.4,'  NO3INH   strength of NH4 inhibition of NO3 ',
     *                    'uptake (l/umoles)'/
     *  f10.4,'  HSNH4    half saturation constant for ammonium uptake '
     *                    ,'(umoles/l)')
1120  format(
     *1pe10.3,'  SINKPHY  phytoplankton sinking rate (positive down; ',
     *                    'm/s)'/
     *1pe10.3,'  SINKFAC  f-ratio sinking rate factor (positive down; ',
     *                    'm/s)')
1130  format(
     *  f10.4,'  ZOOEXP1  fraction of linear heterotroph loss ',
     *                    'to export (nondim)'/
     *  f10.4,'  ZOOEXP2  fraction of quadratic heterotroph loss ',
     *                    'to export (nondim)')
1140  format(
     *  f10.4,'  PARFRAC  fraction of shortwave radiation that is ',
     *                    'PAR (nondim)')
1150  format(
     *  f10.4,'  SBLDEP   depth of SBL for computing the integrated ',
     *                    'f-ratio (m)')
1160  format(
     *  4x,i6,'  BIOPOS   switch to enforce non-negative biological ',
     *                    'tracers')
#if defined codunlim
1170  format(
     *1pe10.3,'  CDZMIN   Cod minimum preferred depth (m)'/
     *1pe10.3,'  CDZMAX   Cod maximum preferred depth (m)'/
     *1pe10.3,'  CDKZ     Cod response to depth coefficient (cm/s)'/
     *1pe10.3,'  CDKP     Cod response to prey coefficient ',
     *                    '(cm^2 l)/(s umole N)'/
     *1pe10.3,'  CDTMIN   Cod minimum preferred temperature (deg C)'/
     *1pe10.3,'  CDTMAX   Cod maximum preferred temperature (deg C)'/
     *1pe10.3,'  CDKT     Cod response to temperature coefficient ',
     *                    'cm^2/[s (deg C)^2]'/
     *1pe10.3,'  CDWMAX   Cod maximum vertical swimming speed (cm/s)')
# elif defined codlim
1170  format(
     *1pe10.3,'  CDZMIN   Cod minimum preferred depth (m)'/
     *1pe10.3,'  CDZMAX   Cod maximum preferred depth (m)'/
     *1pe10.3,'  CDKZ     Cod response to depth coefficient (nondim)'/
     *1pe10.3,'  CDKP     Cod response to prey coefficient ',
     *                    '(cm l)/(umole N)'/
     *1pe10.3,'  CDTMIN   Cod minimum preferred temperature (deg C)'/
     *1pe10.3,'  CDTMAX   Cod maximum preferred temperature (deg C)'/
     *1pe10.3,'  CDKT     Cod response to temperature coefficient ',
     *                    'cm/(deg C)^2'/
     *1pe10.3,'  CDSPD    Cod maximum swimming speed (cm/s)'/
     *1pe10.3,'  CDWMAX   Cod maximum vertical swimming speed (cm/s)')
#endif
c
      end
