c
c=======================================================================
c  Include file "bndyrlx.h"
c=======================================================================
c
#ifndef rmdocinc
c  DVBRLX    V-grid Spatial e-folding scale for boundary relaxation.
c  TVBRLX    V-grid Temporal e-folding scale for boundary relaxation.
c  DTBRLX    T-grid Spatial e-folding scale for boundary relaxation.
c  TTBRLX    T-grid Temporal e-folding scale for boundary relaxation.
c  DCSFRC    Spatial e-folding scale for coastal friction.
c  TCSFRC    Temporal e-folding scale for coastal friction.
c  DBTFRC    Spatial e-folding scale for bottom friction.
c  TBTFRC    Temporal e-folding scale for bottom friction.
#  ifdef bndy_rlx
c  VFACBRLX  Boundary relaxation cofficient at velocity points.
c  U_0       Zonal velocity towards which solution is relaxed.
c  V_0       Meridional velocity towards which solution is relaxed.
c  TFACBRLX  Boundary relaxation cofficient at tracer points.
c  T_0       Tracer value towards which solution is relaxed.
#  endif
#  ifdef cstfrc
c  FACCSFRC  Coastal friction cofficients.
#  endif
#  ifdef botfrc
c  FACBTFRC  Bottom friction cofficients.
#  endif
c
c=======================================================================
c
#endif
      common /bndyrlx/ dvbrlx,tvbrlx,dtbrlx,ttbrlx,dcsfrc,tcsfrc,dbtfrc,
     &                 tbtfrc

#ifdef bndy_rlx
     *                 ,vfacbrlx,u_0,v_0,tfacbrlx,t_0
#endif
#ifdef cstfrc
     *                 ,faccsfrc
#endif
#ifdef botfrc
     *                 ,facbtfrc
#endif
c
      FLOAT
     *      dbtfrc,dcsfrc,dtbrlx,dvbrlx,tbtfrc,tcsfrc,ttbrlx,tvbrlx
#ifdef bndy_rlx
      FLOAT
     *      tfacbrlx(imt,jmt),t_0(imt,jmt,km,nt),u_0(imt,jmt,km),
     *      v_0(imt,jmt,km),vfacbrlx(imt,jmt)
#endif
#ifdef cstfrc
     *      ,faccsfrc(imt,jmt)
#endif
#ifdef botfrc
     *      ,facbtfrc(km)
#endif
c
