      subroutine boundary(j,ibdy)
c
c=======================================================================
c                                                                    ===
c  This routine sets boundary conditions for the Jth slab according  ===
c  to the value of IBDY:                                             ===
c                                                                    ===
c     IBDY = 1   western and eastern boundaries                      ===
c            2   southern boundary                                   ===
c            4   northern boundary                                   ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <scalar.h>
#include <fields.h>
#include <workspa.h>
#include <bndata.h>
#include <options.h>
#include <iounits.h>
c
c-----------------------------------------------------------------------
c  Define local data
c-----------------------------------------------------------------------
c
      integer i,ibdy,j,k,n
      integer m
      FLOAT
     &     wg2,wg1
c
c=======================================================================
c  Set WESTERN and EASTERN boundaries conditions.
c=======================================================================
c
      if(ibdy.eq.1) then
c
c-----------------------------------------------------------------------
c  Boundary conditions on internal mode velocity.
c-----------------------------------------------------------------------
c
c
c  Set closed no slip boundary conditions.
c
        if((iopt(2).eq.0)) then
          do 100 k=1,km
            ua(1,k)=c0
            va(1,k)=c0
            ua(imtm1,k)=c0
            va(imtm1,k)=c0
 100      continue
c
c  Set open boundary conditions to the provided values.
c
        elseif(iopt(2).eq.1) then
          do 110 k=1,km
            ua(1,k)=uo(j,k,west)
            va(1,k)=vo(j,k,west)
            ua(imtm1,k)=uo(j,k,east)
            va(imtm1,k)=vo(j,k,east)
 110      continue
c
c  Set Spall and Robinson radiation conditions (CFvN type).
c
        elseif(iopt(2).eq.2) then
          call vrobc_sr (j,west)
          call vrobc_sr (j,east)
c
c  Orlanski radiation (implicit).
c
        elseif(iopt(2).eq.3) then
          call vrobc_ori (j,west)
          call vrobc_ori (j,east)
c
c  Modified Orlanski radiation (implicit).
c
        elseif(iopt(2).eq.4) then
          call vrobc_moi (j,west)
          call vrobc_moi (j,east)
c
c  One time level, spatial extrapolation.
c
        elseif(iopt(2).eq.5) then
          call vrobc_ext (j,west)
          call vrobc_ext (j,east)
        else
          write(stdout,901) iopt(2)
          call exitus('BOUNDARY')
        endif
c
c-----------------------------------------------------------------------
c  Boundary conditions on tracers.
c-----------------------------------------------------------------------
c
c  Set closed no flux boundary conditions.
c
        if((iopt(1).eq.0)) then
          do 120 n=1,nt
          do 120 k=1,km
            ta(1,k,n)=ta(2,k,n)
            ta(imt,k,n)=ta(imtm1,k,n)
 120      continue
c
c  Set open boundaries to the provided values or Spall and Robinson
c  boundary conditions.
c
        elseif((iopt(1).eq.1).or.(iopt(1).eq.2)) then
          do 130 n=1,nt
          do 130 k=1,km
            ta(1,k,n)=to(j,k,west,n)
            ta(imt,k,n)=to(j,k,east,n)
 130      continue
         if(iopt(1).eq.2) then
           wg1=p5
           wg2=p5
           do 132 m=1,nt
             do 131 k=1,km
               ta(1,k,m)=ta(1,k,m)*wg1+ta(2,k,m)*wg2
               ta(imt,k,m)=ta(imt,k,m)*wg1+ta(imtm1,k,m)*wg2
               to(j,k,west,m)=ta(1,k,m)
               to(j,k,east,m)=ta(imt,k,m)
 131         continue
 132      continue
         endif
c
c  Orlanski radiation (implicit).
c
        elseif(iopt(1).eq.3) then
          call trobc_ori (j,west)
          call trobc_ori (j,east)
c
c  Modified Orlanski radiation (implicit).
c
        elseif(iopt(1).eq.4) then
          call trobc_moi (j,west)
          call trobc_moi (j,east)
c
c  One time level, spatial extrapolation.
c
        elseif(iopt(1).eq.5) then
          call trobc_ext (j,west)
          call trobc_ext (j,east)
        else
          write(stdout,900) iopt(1)
        endif
c
c-----------------------------------------------------------------------
c  Boundary conditions on transport streamfunction.
c-----------------------------------------------------------------------
c
c  Set closed boundary conditions.
c
        if(iopt(3).eq.0) then
          po(j,1,west)=c0
          po(j,1,east)=c0
c
c  Set boundary conditions to the provided values or Spall and Robinson
c  boundary conditions.  Use P0 array in RELAX (nothing is required
c  here).
c
        elseif((iopt(3).eq.1).or.(iopt(3).eq.2)) then
c
c  Orlanski radiation (implicit).
c
        elseif(iopt(3).eq.3) then
          call probc_ori (j,west)
          call probc_ori (j,east)
c
c  Modified Orlanski radiation (implicit).
c
        elseif(iopt(3).eq.4) then
          call probc_moi (j,west)
          call probc_moi (j,east)
        else
          write(stdout,902) iopt(3)
          call exitus('BOUNDARY')
        endif
c
c-----------------------------------------------------------------------
c  Boundary conditions on rate of change of barotropic vorticity.
c-----------------------------------------------------------------------
c
c  Set open boundary conditions to the provided values.
c
        if(iopt(4).eq.1) then
          ztd(2,j)=c2dtsf*po(j,2,west)
          ztd(imtm1,j)=c2dtsf*po(j,2,east)
c
c  Set Spall and Robinson radiation conditions (CFvN type).
c
        elseif(iopt(4).eq.2) then
          call zrobc_sr (j,west)
          call zrobc_sr (j,east)
c
c  Orlanski radiation (implicit).
c
        elseif(iopt(4).eq.3) then
          call zrobc_ori (j,west)
          call zrobc_ori (j,east)
c
c  Extrapolated.
c
        elseif(iopt(4).eq.5) then
          call zrobc_ext (j,west)
          call zrobc_ext (j,east)
c
c  Reduced physics.
c
        elseif(iopt(4).eq.6) then
          call zrobc_rph (j,west)
          call zrobc_rph (j,east)
        else
          write(stdout,903) iopt(4)
          call exitus('BOUNDARY')
        endif
c
c=======================================================================
c  Set SOUTHERN boundary conditions.
c=======================================================================
c
      elseif(ibdy.eq.2) then
c
c-----------------------------------------------------------------------
c  Boundary conditions on internal mode velocity.
c-----------------------------------------------------------------------
c
c  Set closed boundary conditions.
c
        if((iopt(2).eq.0)) then
          do 140 k=1,km
          do 140 i=1,imt
            ua(i,k)=c0
            va(i,k)=c0
 140      continue
c
c  Set open boundary conditions to the provided values.
c
        elseif(iopt(2).eq.1) then
          do 150 k=1,km
          do 150 i=1,imt
            ua(i,k)=uo(i,k,south)
            va(i,k)=vo(i,k,south)
 150      continue
c
c  Set Spall and Robinson radiation conditions (CFvN type).
c
        elseif(iopt(2).eq.2) then
          call vrobc_sr (j,south)
c
c  Orlanski radiation (implicit).
c
        elseif(iopt(2).eq.3) then
          call vrobc_ori (j,south)
c
c  Modified Orlanski radiation (implicit).
c
        elseif(iopt(2).eq.4) then
          call vrobc_moi (j,south)
c
c  One time level, spatial extrapolation.
c
        elseif(iopt(2).eq.5) then
          call vrobc_ext (j,south)
        else
          write(stdout,901) iopt(2)
          call exitus('BOUNDARY')
        endif
c
c-----------------------------------------------------------------------
c  Boundary conditions on tracers.
c-----------------------------------------------------------------------
c
c  Set closed boundary conditions.
c
        if((iopt(1).eq.0)) then
          do 160 n=1,nt
          do 160 k=1,km
          do 160 i=1,imt
            ta(i,k,n)=ta(i,k,n)
 160      continue
c
c  Set open boundaries to the provided values or Spall and Robinson
c  boundary conditions.
c
        elseif((iopt(1).eq.1).or.(iopt(1).eq.2)) then

         if (iopt(1).eq.2) then
          wg1=p5
          wg2=p5
          do 169 m=1,nt
           do 168 k=1,km
            do 167 i=1,imt
              to(i,k,south,m)=to(i,k,south,m)*wg1+ta(i,k,m)*wg2
 167        continue
 168       continue
 169      continue
         endif

          do 170 n=1,nt
          do 170 k=1,km
          do 170 i=1,imt
            ta(i,k,n)=to(i,k,south,n)
 170      continue
c
c  Orlanski radiation (implicit).
c
        elseif(iopt(1).eq.3) then
          call trobc_ori (j,south)
c
c  Modified Orlanski radiation (implicit).
c
        elseif(iopt(1).eq.4) then
          call trobc_moi (j,south)
c
c  One time level, spatial extrapolation.
c
        elseif(iopt(1).eq.5) then
          call trobc_ext (j,south)
        else
          write(stdout,900) iopt(1)
        endif
c
c-----------------------------------------------------------------------
c  Boundary conditions on transport streamfunction.
c-----------------------------------------------------------------------
c
c  Set closed boundary conditions.
c
        if(iopt(3).eq.0) then
          do 180 i=1,imt
            po(i,1,south)=c0
 180      continue
c
c  Set boundary conditions to the provided values or Spall and Robinson
c  boundary conditions.  Use P0 array in RELAX (nothing is required
c  here).
c
        elseif((iopt(3).eq.1).or.(iopt(3).eq.2)) then
c
c  Orlanski radiation (implicit).
c
        elseif(iopt(3).eq.3) then
          call probc_ori (j,south)
c
c  Modified Orlanski radiation (implicit).
c
        elseif(iopt(3).eq.4) then
          call probc_moi (j,south)
        else
          write(stdout,902) iopt(3)
          call exitus('BOUNDARY')
        endif
c
c-----------------------------------------------------------------------
c  Boundary conditions on rate of change of barotropic vorticity.
c-----------------------------------------------------------------------
c
c  Set open boundary conditions to the provided values.
c
        if(iopt(4).eq.1) then
          do 190 i=1,imt
            ztd(i,2)=c2dtsf*po(i,2,south)
 190      continue
c
c  Set Spall and Robinson radiation conditions (CFvN type).
c
        elseif(iopt(4).eq.2) then
          call zrobc_sr (j,south)
c
c  Orlanski radiation (implicit).
c
        elseif(iopt(4).eq.3) then
          call zrobc_ori (j,south)
c
c  Extrapolated.
c
        elseif(iopt(4).eq.5) then
          call zrobc_ext (j,south)
c
c  Reduced physics.
c
        elseif(iopt(4).eq.6) then
          call zrobc_rph (j,south)
        else
          write(stdout,903) iopt(4)
          call exitus('BOUNDARY')
        endif
c
c=======================================================================
c  Set NORTHERN boundary conditions.
c=======================================================================
c
      elseif(ibdy.eq.4) then
c
c-----------------------------------------------------------------------
c  Boundary conditions on internal mode velocity.
c-----------------------------------------------------------------------
c
c  Set closed boundary conditions.
c
        if((iopt(2).eq.0)) then
          do 200 k=1,km
          do 200 i=1,imt
            ua(i,k)=c0
            va(i,k)=c0
 200      continue
c
c  Set open boundary conditions to the provided values.
c
        elseif(iopt(2).eq.1) then
          do 210 k=1,km
          do 210 i=1,imt
            ua(i,k)=uo(i,k,north)
            va(i,k)=vo(i,k,north)
 210      continue
c
c  Set Spall and Robinson radiation conditions (CFvN type).
c
        elseif(iopt(2).eq.2) then
          call vrobc_sr (j,north)
c
c  Orlanski radiation (implicit).
c
        elseif(iopt(2).eq.3) then
          call vrobc_ori (j,north)
c
c  Modified Orlanski radiation (implicit).
c
        elseif(iopt(2).eq.4) then
          call vrobc_moi (j,north)
c
c  One time level, spatial extrapolation.
c
        elseif(iopt(2).eq.5) then
          call vrobc_ext (j,north)
        else
          write(stdout,901) iopt(2)
          call exitus('BOUNDARY')
        endif
c
c-----------------------------------------------------------------------
c  Boundary conditions on tracers.
c-----------------------------------------------------------------------
c
c  Set closed boundary conditions.
c
        if((iopt(1).eq.0)) then
          do 220 n=1,nt
          do 220 k=1,km
          do 220 i=1,imt
            ta(i,k,n)=ta(i,k,n)
 220      continue
c
c  Set open boundaries to the provided values.
c
        elseif((iopt(1).eq.1).or.(iopt(1).eq.2)) then
c
         if(iopt(1).eq.2) then
           wg1=p5
           wg2=p5
           do 229 m=1,nt
             do 228 k=1,km
              do 227 i=1,imt
                 to(i,k,north,m)=to(i,k,north,m)*wg1+ta(i,k,m)*wg2
 227           continue
 228         continue
 229       continue
         endif

          do 230 n=1,nt
          do 230 k=1,km
          do 230 i=1,imt
            ta(i,k,n)=to(i,k,north,n)
 230      continue
c
c  Orlanski radiation (implicit).
c
        elseif(iopt(1).eq.3) then
          call trobc_ori (j,north)
c
c  Modified Orlanski radiation (implicit).
c
        elseif(iopt(1).eq.4) then
          call trobc_moi (j,north)
c
c  One time level, spatial extrapolation.
c
        elseif(iopt(1).eq.5) then
          call trobc_ext (j,north)
        else
          write(stdout,900) iopt(1)
        endif
c
c-----------------------------------------------------------------------
c  Boundary conditions on transport streamfunction.
c-----------------------------------------------------------------------
c
c  Set closed boundary conditions.
c
        if(iopt(3).eq.0) then
          do 240 i=1,imt
            po(i,1,north)=c0
 240      continue

c  Set boundary conditions to the provided values or Spall and Robinson
c  boundary conditions.  Use P0 array in RELAX (nothing is required
c  here).
c
        elseif((iopt(3).eq.1).or.(iopt(3).eq.2)) then
c
c  Orlanski radiation (implicit).
c
        elseif(iopt(3).eq.3) then
          call probc_ori (j,north)
c
c  Modified Orlanski radiation (implicit).
c
        elseif(iopt(3).eq.4) then
          call probc_moi (j,north)
        else
          write(stdout,902) iopt(3)
          call exitus('BOUNDARY')
        endif
c
c-----------------------------------------------------------------------
c  Boundary conditions on rate of change of barotropic vorticity.
c-----------------------------------------------------------------------
c
c  Set open boundary conditions to the provided values.
c
        if(iopt(4).eq.1) then
          do 250 i=1,imt
            ztd(i,jmtm1)=c2dtsf*po(i,2,north)
 250      continue
c
c  Set Spall and Robinson radiation conditions (CFvN type).
c
        elseif(iopt(4).eq.2) then
          call zrobc_sr (j,north)
c
c  Orlanski radiation (implicit).
c
        elseif(iopt(4).eq.3) then
          call zrobc_ori (j,north)
c
c  Extrapolated.
c
        elseif(iopt(4).eq.5) then
          call zrobc_ext (j,north)
c
c  Reduced physics.
c
        elseif(iopt(4).eq.6) then
          call zrobc_rph (j,north)
        else
          write(stdout,903) iopt(4)
          call exitus('BOUNDARY')
        endif
      else
        write(stdout,904) ibdy
      endif
 900  format(' BOUNDARY: invalid boundary on tracers, IOPT(1) = ',i4)
 901  format(' BOUNDARY: invalid boundary on velocity, IOPT(2) = ',i4)
 902  format(' BOUNDARY: invalid boundary on transport, IOPT(3) = ',i4)
 903  format(' BOUNDARY: invalid boundary on vorticity, IOPT(4) = ',i4)
 904  format(' BOUNDARY: invalid boundary number, IBDY = ',i4)
      return
      end
