       subroutine caldate (jday,dchar,tchar,iday,month,iyear,iyday)
c
c=======================================================================
c                                                                    ===
c  This routine takes the modified Julian date and converts it       ===
c  to a date and time string.                                        ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     JDAY     modified Julian day   (real)                          ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     DCHAR    date string           (character)                     ===
c     IDAY     day of the month      (integer)                       ===
c     IYDAY    year day              (integer)                       ===
c     IYEAR    year                  (integer)                       ===
c     MONTH    month of the year     (integer)                       ===
c     TCHAR    time string           (character)                     ===
c                                                                    ===
c  Calls:  GREGORIAN                                                 ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <pconst.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer iday,ihour,imin,isec,iyday,iyear,julian,month,offset
      FLOAT
     &      c60,fjulian,hour,jday,min
      character*(*) dchar,tchar
      character*3   mchar(12)
c
      parameter (c60=c6*c10)
c
      data mchar /'Jan','Feb','Mar','Apr','May','Jun',
     &            'Jul','Aug','Sep','Oct','Nov','Dec'/
      data offset /2440000/
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c  Add offset to get true Julian date.
c
       julian=offset+int(jday)
c
c      fjulian=jday-int(jday)+p5
       fjulian=abs(jday-int(jday))
c
       if (fjulian.ge.c1) then
         julian=julian+1
         fjulian=fjulian-c1
       endif
c
c-----------------------------------------------------------------------
c  Compute Gregorian date.
c-----------------------------------------------------------------------
c
       call gregorian (julian,iday,month,iyear,iyday)
c
c-----------------------------------------------------------------------
c  Form date and time strings.
c-----------------------------------------------------------------------
c
       hour=fjulian*c24
       ihour=int(hour)
       min=(hour-FLoaT(ihour))*c60
       imin=int(min)
       isec=(min-imin)*c60
c
       write(dchar,10) mchar(month),iday,iyear
 10    format(a3,i3,i5)
       write(tchar,20) ihour, imin, isec
 20    format(i2.2,':',i2.2,':',i2.2)
c
       return
       end
