c
c=======================================================================
c  Include file "cdiag.h".
c=======================================================================
c
#ifndef rmdocinc
c  Variables used for computing diagnostics:
c
c  ASST       average surface tracer per unit area.
c  ATWV       average tracer within volume.
c  AVWV       average velocity within volume.
c  BUOY       buoyancy.
c  BUOYINT    buoyancy per unit volume.
c  DTABS      rate of change of tracer per unit volume.
c  EKTOT      total kinetic energy per unit volume.
c  ENGEXT     external mode energy integral components per unit volume.
c  ENGINT     internal mode energy integral components per unit volume.
c  MTERMS     number of balance terms for momentum.
c  STFLX      surface tracer flux per unit volume.
c  SMFLX      surface momentum flux per unit volume.
c  TBRN       zonal sum of tracer (north row).
c  TBRS       zonal sum of tracer (south row).
c  TCONV      time rate of change due to convection per unit volume.
c  TERMBM     term balance components for time rate of change of
c             momentum per unit volume:
c             (1)  = total time rate of change for the momentum
c             (2)  = change due to the pressure gradient
c             (3)  = change due to zonal advection
c             (4)  = change due to meridional advection
c             (5)  = change due to vertical advection
c             (6)  = change due to zonal diffusion
c             (7)  = change due to meridional diffusion
c             (8)  = change due to vertical diffusion
c             (9)  = change due to wind stress
c             (10) = change due to bottom drag
c             (11) = change due to metric term diffusion
c             (12) = change due to coriolis terms
# if defined bndy_rlx | defined cstfrc | defined botfrc
c             (..) = change due to boundary relaxation terms
# endif
c  TERMBT     term balance components for time rate of change of tracers
c             per unit volume:
c             (1)  = total time rate of change for the tracer
c             (2)  = change due to zonal advection
c             (3)  = change due to meridional advection
c             (4)  = change due to vertical advection
c             (5)  = change due to zonal diffusion
c             (6)  = change due to meridional diffusion
c             (7)  = change due to vertical diffusion
c             (8)  = change due to source/sink terms
# ifdef bndy_rlx
c             (..) = change due to boundary relaxation terms
# endif
c  TRMBTV     unintegrated TERMBT (full volume data).
c  TTERMS     number of balance terms for tracers.
c  TVAR       rate of change of tracer variance per unit volume.
c  TTN        northward transport of tracer.
c  TMT        meridional mass transport.
c  VBR        zonal sum of meridional velocity.
c  ZUNENG     vertical average of zonal forcing on NORTH row.
c  ZUSENG     vertical average of zonal forcing on SOUTH row.
c  ZVNENG     vertical average of meridional forcing on NORTH row.
c  ZVSENG     vertical average of meridional forcing on SOUTH row.
c
c  NOTE:  The instantaneous breakdowns of all terms balances in the
c         momentum and tracer equations are averaged over ocean
c         volumes.  Intergrals are summed over K and stored into
c         the zeroth element (K=0).
c
c=======================================================================
c
#endif
#
#define MTERMS00 12
#define TTERMS00 8
#
#if defined bndy_rlx
#  define MTERMS01 MTERMS00+1
#  define TTERMS01 TTERMS00+1
# elif defined cstfrc | defined botfrc
#  define MTERMS01 MTERMS00+1
#  define TTERMS01 TTERMS00
# else
#  define MTERMS01 MTERMS00
#  define TTERMS01 TTERMS00
#endif
#
      integer mterms,tterms
      parameter (mterms=MTERMS01,tterms=TTERMS01)
c
      common /cdiag/ eke,ektot,dtabs,engint,engext,tconv,atwv,asst,avwv,
     *               termbt,termbm,trmbtv,tvar,smflx,stflx,buoy,buoyint,
     *       vbr,tbrn,tbrs,ttn,tmt,zuneng,zvneng,zuseng,zvseng
      FLOAT
     *      asst(nt),atwv(nt),avwv(3),buoy(imt,km),buoyint(0:km),
     *      dtabs(0:km,nt,jmt),engext(mterms),engint(0:km,mterms),
     *      eke(imt,km,mterms),ektot(0:km,jmt),smflx(2),stflx(nt),
     *      tbrn(km,nt),tbrs(km,nt),tconv(nt),termbm(0:km,mterms,2),
     *      termbt(0:km,tterms,nt),trmbtv(imt,km,tterms,nt),tmt(jmt,km),
     *      ttn(tterms,jmt,nt),tvar(0:km,nt),vbr(km),zuneng(imt,mterms),
     *      zuseng(imt,mterms),zvneng(imt,mterms),zvseng(imt,mterms)
