      function cdrspv (fm,fp,fmin,fmax,dsr,rspcff)
c
c=======================================================================
c                                                                    ===
c  This function calculated the cod response velocity through the    ===
c  wall of a computational box.                                      ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     DSR......Reciprocal of differential length.     (real)         ===
c     FM.......Function at lower end of difference.   (real)         ===
c     FMIN.....Minimum null response value.           (real)         ===
c     FMAX.....Maximum null response value.           (real)         ===
c     FP.......Function at upper end of difference.   (real)         ===
c     RSPCFF...Response coefficient.                  (real)         ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     CDRSPV...Response value.                        (real)         ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <pconst.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      FLOAT
     *      dsr,fm,fmax,fmin,fp,fsqm,fsqp,rspcff
      FLOAT
     *      cdrspv
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c  Compute response functional at lower end.
c
      if (fm.lt.fmin) then
         fsqm = - (fm-fmin)**2
       elseif (fm.gt.fmax) then
         fsqm = - (fm-fmax)**2
       else
         fsqm = c0
      end if
c
c  Compute response functional at upper end.
c
      if (fp.lt.fmin) then
         fsqp = - (fp-fmin)**2
       elseif (fm.gt.fmax) then
         fsqp = - (fp-fmax)**2
       else
         fsqp = c0
      end if
c
c  Compute response velocity.
c
#ifndef codlim
      cdrspv = (fsqm - fsqp) * dsr*rspcff
# else
      cdrspv = tanh( (fsqm - fsqp) * dsr*rspcff )
#endif
c
      return
      end
