      function cell_ok (ix,jy,im,jm,mask,act_val)
c
c=======================================================================
c                                                                    ===
c  This function examines the indicated central cell to ensure the   ===
c  necessary data points are un-masked.  A true value indicates the  ===
c  central 4 points are active.  A false value indicates that at     ===
c  least 1 central point is inactive.                                ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     IX........Left edge of central cell.     (integer)             ===
c     JY........Bottom edge of central cell.   (integer)             ===
c     IM........X-size of mask.                (integer)             ===
c     JM........Y-size of mask.                (integer)             ===
c     MASK......Land mask.                     (integer array)       ===
c     ACT_VAL...Active mask value.             (integer)             ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer act_val,im,ix,jm,jy
      integer mask(im,jm)
      logical cell_ok
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Ensure cell is properly contained in grid.
c-----------------------------------------------------------------------
c
      cell_ok = (ix.ge.1) .and.(ix.lt.im) .and.(jy.ge.1) .and.(jy.lt.jm)
c
c-----------------------------------------------------------------------
c  If properly contained, ensure all cell values are active.
c-----------------------------------------------------------------------
c
      if (cell_ok) then
         cell_ok = (mask(ix  ,jy  ).eq.act_val) .and.
     &             (mask(ix+1,jy  ).eq.act_val) .and.
     &             (mask(ix  ,jy+1).eq.act_val) .and.
     &             (mask(ix+1,jy+1).eq.act_val)
      end if
c
      return
      end
