      subroutine check_prf
c
c=======================================================================
c                                                                    ===
c  This routine checks if pe-profiles have to be written at the      ===
c  current time step. If profiles have to be written out, the entry  ===
c  slab_prf will call the wrt_prf routine to write the desired       ===
c  profiles in ACSII format.                                         ===
c                                                                    ===
c  Entries:                                                          ===
c                                                                    ===
c  TIME_PRF    Check if pe_prof. have to be written at current time  ===
c              step.                                                 ===
c  SLAB_PRF    Check if pe_prof. have to be written out at the       ===
c              current j and if so, writes the profiles in the file  ===
c              outprf.                                               ===
c                                                                    ===
c       Calls:  WRT_PRF
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <hydro.h>
#include <prf.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      logical wrtprf
      integer curr_ptr,itt,j,trail_ptr
c
c=======================================================================
c  Check if profiles have to be written at current time step. ==========
c=======================================================================
c
      entry time_prf (itt,wrtprf)
c
      wrtprf = .false.
      if ((xbt_bgn.ne.0).and.(ixbtpos(xbt_bgn,3).eq.itt)) wrtprf=.true.
      if ((ctd_bgn.ne.0).and.(ictdpos(ctd_bgn,3).eq.itt)) wrtprf=.true.
      if ((cm_bgn.ne.0).and.(icmpos(cm_bgn,3).eq.itt)) wrtprf=.true.
c
      return
c
c=======================================================================
c  Check if pe_prof. have to be written out at the current j    ========
c  and if so, call the routine wrt_prf for each i a profile     ========
c  is desired to write the profiles parameters and values in    ========
c  the file outprf.                                             ========
c=======================================================================
c
      entry slab_prf (itt,j)
c
      if (xbt_bgn.ne.0) then
         xbt       = .true.
         curr_ptr  = xbt_bgn
         trail_ptr = 0
         do while ((ixbtpos(curr_ptr,3).eq.itt).and.(curr_ptr.ne.0))
            if (ixbtpos(curr_ptr,2).eq.j) then
               call wrt_prf (ixbtpos(curr_ptr,1),j)
               call rem_llist (mnbprf,ixbtpos(1,4),xbt_bgn,xbt_emt,
     &                         curr_ptr,trail_ptr)
             else
               trail_ptr = curr_ptr
               curr_ptr  = ixbtpos(curr_ptr,4)
            end if
         end do
         xbt = .false.
      endif
      if (ctd_bgn.ne.0) then
         ctd       = .true.
         curr_ptr  = ctd_bgn
         trail_ptr = 0
         do while ((ictdpos(curr_ptr,3).eq.itt).and.(curr_ptr.ne.0))
            if (ictdpos(curr_ptr,2).eq.j) then
               call wrt_prf (ictdpos(curr_ptr,1),j)
               call rem_llist (mnbprf,ictdpos(1,4),ctd_bgn,ctd_emt,
     &                         curr_ptr,trail_ptr)
             else
               trail_ptr = curr_ptr
               curr_ptr  = ictdpos(curr_ptr,4)
            end if
         end do
         ctd = .false.
      endif
      if (cm_bgn.ne.0) then
         cm        = .true.
         curr_ptr  = cm_bgn
         trail_ptr = 0
         do while ((icmpos(curr_ptr,3).eq.itt).and.(curr_ptr.ne.0))
            if (icmpos(curr_ptr,2).eq.j) then
               call wrt_prf (icmpos(curr_ptr,1),j)
               call rem_llist (mnbprf,icmpos(1,4),cm_bgn,cm_emt,
     &                         curr_ptr,trail_ptr)
             else
               trail_ptr = curr_ptr
               curr_ptr  = icmpos(curr_ptr,4)
            end if
         end do
         cm = .false.
      endif
c
      return
      end
