      subroutine chkparm
c
c=======================================================================
c                                                                    ===
c  This routine checks the consistency of the C-Preprocessing        ===
c  options and the input parameters.                                 ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /IIOUNITS/                                                        ===
c                                                                    ===
c  STDOUT    standard output logical unit.                           ===
c                                                                    ===
c  /OPTIONS/                                                         ===
c                                                                    ===
c  IFLAG   initialization flags:                                     ===
c          IFLAG(9)   hybrid coordinates transformation:             ===
c                     [0] single, [1] double                         ===
c          IFLAG(10)  coastal setup switch:                          ===
c                     [0] no, [1] coast(s) only,                     ===
c                     [2] coast(s) and island(s)                     ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <param.h>
#include <iounits.h>
#include <options.h>
c
#if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer biomodel
c
#endif
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Check consistency of C-preprocessing options.
c-----------------------------------------------------------------------
c
#ifdef dblsigma
      if(iflag(9).ne.1) then
        write(stdout,10) iflag(9)
  10    format(/,' CHKPARM: inconsistent initialization, IFLAG(9) = ',i4
     *         /,'          IFLAG(9) should be one in double sigma')
        call exitus('CHKPARM')
      endif
# else
      if(iflag(9).ne.0) then
        write(stdout,10) iflag(9)
  10    format(/,' CHKPARM: inconsistent initialization, IFLAG(9) = ',i4
     *         /,'          IFLAG(9) should be zero in single sigma')
        call exitus('CHKPARM')
      endif
#endif
c
#ifdef coast
      if(iflag(10).eq.0) then
        write(stdout,20) iflag(10)
  20    format(/' CHKPARM: inconsistent initialization, IFLAG(10) = ',i4
     *         /'          IFLAG(10) should be one in coastal setup')
        call exitus('CHKPARM')
      endif
# else
      if(iflag(10).ne.0) then
        write(stdout,20) iflag(10)
  20    format(/' CHKPARM: inconsistent initialization, IFLAG(10) = ',i4
     *        /'          IFLAG(10) should be zero in noncoastal setup')
        call exitus('CHKPARM')
      endif
#endif
c
#if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
      biomodel=0
# ifdef bioMcGillic
      biomodel=biomodel+1
# endif
# ifdef bioFasham
      biomodel=biomodel+1
# endif
# ifdef bioAnder
      biomodel=biomodel+1
# endif
# ifdef bioDuse
      biomodel=biomodel+1
# endif
      if(biomodel.gt.1) then
        write(stdout,30)
  30    format(/' CHKPARM: Only one biologicial model formulation is',
     *          ' allowed.',10x,'Choose one and recompile.')
        call exitus('CHKPARM')
      endif
c
#endif
#ifdef barotropic
      if(km.ne.1) then
        write(stdout,40) km
  40    format(/' CHKPARM: illegal number of levels, KM = ',i4/
     *          10x,'barotropic model should only have 1 level.')
        call exitus('CHKPARM')
      endif
c
#endif
      return
      end
