c
c=======================================================================
c  Include file "cinpvbc.h".
c=======================================================================
c
#ifndef rmdocinc
c  Input vertical boundary conditions: Point or gridded fluxes time
c  series.   
c
c  LSHFGRD  switch for gridded surface heat flux data.
c  LSHFLUX  switch for availability of surface heat flux data.
c  LSMFGRD  switch for gridded surface momentum flux data.
c  LSMFLUX  switch for availability of surface momentum flux data.
c  LSNFGRD  switch for gridded surface nutrient flux data.
c  LSNFLUX  switch for availability of surface nutrient flux data.
c  LSWFGRD  switch for gridded surface water flux data.
c  LSWFLUX  switch for availability of surface water flux data.
c  LSWRAD   switch for availability of shortwave radiation data.
c  LSWRGRD  switch for gridded shortwave radiation data.
c  NTSNF    length of time-serie for surface biology flux.
c  NTSHF    length of time-serie for surface heat flux.
c  NTSMF    length of time-serie for surface momentum flux.
c  NTSWF    length of time-serie for surface water flux.
c  NTSWR    length of time-serie for shortwave radiation.
c  SHFLUX   gridded surface (net) heat flux (Watts/m^2).
c  SHFX     point surface (net) heat flux (Watts/m^2).
c  SMFLUX   gridded surface momentum flux (dynes/cm^2).
c  SMFX     point surface momentum flux (dynes/cm^2).
# if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
c  SNFLUX   gridded surface nutrient flux (umoles/m^2/day).
c  SNFX     point surface nutrient flux (umoles/m^2/day).
# endif
c  SWFLUX   gridded surface water flux: E-P (cm/day).
c  SWFX     point surface water flux: E-P (cm/day).
c  SWR      point shortwave radiation (Watts/m^2).
c  SWRAD    gridded shortwave radiation (Watts/m^2).
c  TLATSIZ  size of latitude at tracer points.
c  TLONSIZ  size of longitude at tracer points.
c  TSHF     surface (net) heat flux time (Julian day).
c  TSMF     surface momentum flux time (Julian day).
# if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
c  TSNF     surface nutrient flux time (Julian day).
# endif
c  TSWF     surface water flux (E-P) positions (Julian day).
c  TSWR     surface momentum flux positions (Julian day).
c  VLATSIZ  size of latitude at velocity points.
c  VLONSIZ  size of longitude at velocity points.
c
c=======================================================================
c
#endif
      integer vector
      parameter (vector=2)
c
      common /icinpvbc/ lshfgrd,lshflux,lsmfgrd,lsmflux,lsnfgrd,lsnflux,
     *       lswfgrd,lswflux,lswrad,lswrgrd,itshf,itsmf,itsnf,itswf,
     *       itswr,ntshf,ntsmf,ntsnf,ntswf,ntswr,tlatsiz,tlonsiz,
     *       vlatsiz,vlonsiz
      logical lshfgrd,lshflux,lsmfgrd,lsmflux,lswfgrd,lsnfgrd,lsnflux,
     *        lswflux,lswrad,lswrgrd
      integer itshf,itsmf,itsnf,itswf,itswr,ntshf,ntsmf,ntsnf,ntswf,
     *        ntswr,tlatsiz,tlonsiz,vlatsiz,vlonsiz
c
      common /fcinpvbc/ shflux,smflux,swflux,shfx,smfx,swfx,swr,swrad,
     *       tshf,tsmf,tswf,tswr
#if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
     *       ,snflux,snfx,tsnf
#endif
      FLOAT
     *      shflux(imt,jmt,0:1),smflux(vector,imt,jmt,0:1),
     *      swflux(imt,jmt,0:1),shfx(0:1),smfx(vector,0:1),swfx(0:1),
     *      swr(0:1),swrad(imt,jmt,0:1),tshf(0:1),tsmf(0:1),tswf(0:1),
     *      tswr(0:1)
#if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
      FLOAT
     *      snflux(imt,jmt,0:1),snfx(0:1),tsnf(0:1)
#endif
