      subroutine cnvmix(j)
c
c=======================================================================
c                                                                    ===
c  This routine sets up the coefficients for constant vertical       ===
c  diffusion of momentum (VVC) and tracers (VDC).                    ===
c  (Adapted from MOM)                                                ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#ifdef explicitvmix
# include <scalar.h>
# include <fullwd.h>
# include <iounits.h>
#else
# include <workspa.h>
#endif
#include <vertslabs.h>
#include <cvmix.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,k,j
#ifdef explicitvmix
      FLOAT
     *      dttmax,dtumax,fx,pdtt,pdtu,pvdc,pvvc,small,vdcmax,vdcri,
     *      vvcmax,vvcri
      parameter (small=c1em8)
#endif
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      do 10 k=1,km
      do 10 i=1,imt
        vdc(i,k)=fkph
        vvc(i,k)=fkpm
  10  continue
c
#ifdef explicitvmix
c
c-----------------------------------------------------------------------
c  Determine numerical stability based on vertical viscosity/diffusion
c  coefficients:
c                         Av dt/(dz^2) < 0.25
c-----------------------------------------------------------------------
c
      if(itt.eq.1) then
        do 60 k=1,km
        do 60 i=1,imt
          if(vdc(i,k).gt.small) then
            fx=dzqz(i,k,0)**2
            vdcri=c4*dtts*vdc(i,k)/fx
            if(vdcri.ge.c1) then
              write(stdout,20) i,j,k
  20          format(' Exceeded vertical diffusion stability criteria',
     *               ' at (i,j,k) = ',i3,',',i3,',',i3)
              vdcmax=fx/(c4*dtts)
              pvdc=abs(c100*vdc(i,k)/vdcmax)
              dttmax=fx/(c4*vdc(i,k))
              pdtt=abs(c100*dtts/dttmax)
              write(stdout,30) pvdc,vdcmax,pdtt,dttmax
  30          format('  Av   reached ',f8.2,'% of the stability limit ',
     *                      '(',g15.8,')',/
     *               '  DTTS reached ',f8.2,'% of the stability limit ',
     *                      '(',g15.8,')')
              call exitus('CNVMIX')
            endif
          endif
          if(vvc(i,k).gt.small) then
            fx=dzvqz(i,k,0)**2
            vvcri=c4*dtuv*vvc(i,k)/fx
            if(vvcri.ge.c1) then
              write(stdout,40) i,j,k
  40          format(' Exceeded vertical viscosity stability criteria',
     *               ' at (i,j,k) = ',i3,',',i3,',',i3)
              vvcmax=fx/(c4*dtuv)
              pvvc=abs(c100*vvc(i,k)/vvcmax)
              dtumax=fx/(c4*vvc(i,k))
              pdtu=abs(c100*dtuv/dtumax)
              write(stdout,50) pvvc,vvcmax,pdtu,dtumax
  50          format('  Av   reached ',f8.2,'% of the stability limit ',
     *                      '(',g15.8,')',/
     *               '  DTUV reached ',f8.2,'% of the stability limit ',
     *                      '(',g15.8,')')
              call exitus('CNVMIX')
            endif
          endif
  60    continue
      endif
#else
c
c-----------------------------------------------------------------------
c  Determine mixed-layer depth, and set vertical mixing coefficients to
c  WVMIX and WDMIX within the mixed layer.
c-----------------------------------------------------------------------
c
      call mixlayer(j)
c
c-----------------------------------------------------------------------
c  Compute vertical gradient in potential density and determine vertical
c  gravitational stability, and if unstable set the vertical mixing
c  coefficients to VVCLIM and VDCLIM.
c-----------------------------------------------------------------------
c
      if(j.eq.1) then
        call pdenvgrad (tb(1,1,1),tb(1,1,2),tdepth(1,1,jrs),
     &                  dzzqz(1,1,jrs),drho)
       else
        do 65 i=1,imt
        do 65 k=1,km
          drho(i,k)=drhop(i,k)
  65    continue
      endif
      call pdenvgrad (tbp(1,1,1),tbp(1,1,2),tdepth(1,1,jrn),
     &                dzzqz(1,1,jrn),drhop)
      call convect(j)
c
c-----------------------------------------------------------------------
c  Set viscosity and diffusivity to zero in land.
c-----------------------------------------------------------------------
c
#ifndef barotropic
      do 70 k=1,kmm1
      do 70 i=2,imtm1
        vvc(i,k)=gm(i,k+1)*vvc(i,k)
        vdc(i,k)=fm(i,k+1)*vdc(i,k)
  70  continue
#endif
c
c-----------------------------------------------------------------------
c  Set viscosity and diffusivity at level KM.
c-----------------------------------------------------------------------
c
      do 80 i=2,imtm1
        vvc(i,km)=c0
        vdc(i,km)=c0
  80  continue
#endif
      return
      end
