c
c=======================================================================
c  Include file "ctsrc.h"
c=======================================================================
c
#ifndef rmdocinc
c  ITSRC    I-coordinate for tracer source.
c  JTSRC    J-coordinate for tracer source.
c  MTSRC    tracer index, e.g. 1=temperature.
c  MXSRC    maximum number of tracer sources allowed.
c  NTSRC    current number of tracer sources.
c  TSRCD    maximum depth of inflow.
c  TSRCF    tracer [source/rate] value.
c           For source value use the units of MTSRC in the model, e.g. 
c           Celsius for Temperature.
c           For rate values use the units of MTSRC in the model
c           divided by seconds.
c  TSRCF_I  initial tracer source value.
c           For source value use the units of MTSRC in the model, e.g. 
c           Celsius for Temperature.
c  FACSRC   scaling factor for relaxation. Set to zero if TSRC is
c           a rate value; and set greater than 0.0 if TSRC is a river
c           value.
c  TAUSRC   relaxation time (s). Set to one if TSRC is a rate value.
c  TAUSRC_I initial relaxation time (s). 
c=======================================================================
c
#endif
      integer mxsrc
      parameter (mxsrc=50)
c
      integer ntsrc
      integer         itsrc(mxsrc),jtsrc(mxsrc),mtsrc(mxsrc)
      common /ictsrc/ ntsrc,itsrc,jtsrc,mtsrc
c
      FLOAT
     *      tsrcf(mxsrc),facsrc(mxsrc),tausrc(mxsrc),tsrcd(mxsrc),
     *                tsrcf_i(mxsrc),tausrc_i(mxsrc)
      common /fctsrc/ tsrcf,facsrc,tausrc,tsrcd,tsrcf_i,tausrc_i
