c
c=======================================================================
c  Include file "cvbc.h"
c=======================================================================
c
#ifndef rmdocinc
c  Vertical boundary condition variables:
c
c  BMF     bottom momentum flux (real array):
c            BMF(IMT,1) =>   zonal bottom drag (cm^2/s)
c            BMF(IMT,2) =>   meridional bottom drag (cm^2/s)
#ifdef bottom
c  CMF     bottom momentum coefficient (real array):
c            CMF(IMT)   =>   zonal bottom drag coefficient (cm/s)
#endif
c  BTF     bottom tracer flux (for consistency but normally zero!):
c            BTF(IMT,1) =>   bottom heat flux (degC cm/s)
c            BTF(IMT,2) =>   bottom water flux (ppt cm/s)
c  SBF     surface buoyancy flux at row J (cm^2/s^3; real array).
c            SBF(IMT,1) =>   due to latent, sensible, longwave, and
c                            E-P.
c            SBF(IMT,2) =>   due to solar (shortwave) radiation.
c  SBFP    surface buoyancy flux at row J+1 (cm^2/s^3; real array).
c            SBF(IMT,1) =>   due to latent, sensible, longwave, and
c                            E-P.
c            SBF(IMT,2) =>   due to solar (shortwave) radiation.
c  SMF     surface momentum flux (real array):
c            SMF(IMT,1) =>   zonal wind stress (dynes/cm^2)
c            SMF(IMT,2) =>   meridional wind stress (dynes/cm^2)
c  SRF     surface shortwave radiation flux at row J (degC cm/s).
c  SRFP    surface shortwave radiation flux at row J+1 (degC cm/s).
c  STF     surface tracer flux at row J (real array):
c            STF(IMT,1) =>   surface heat flux (degC cm/s)
c            STF(IMT,2) =>   surface water flux (ppt cm/s)
c  STFP    surface tracer flux at row J+1 (real array):
c            STFP(IMT,1) =>  surface heat flux (degC cm/s)
c            STFP(IMT,2) =>  surface water flux (ppt cm/s)
c
c=======================================================================
c
#endif
      common /cvbc/ smf,bmf,stf,stfp,btf,sbf,sbfp,srf,srfp
#ifdef bottom
     *             ,cmf
#endif
      FLOAT
     *      bmf(imt,2),btf(imt,nt),sbf(imt,2),sbfp(imt,2),smf(imt,2),
     *      srf(imt),srfp(imt),stf(imt,nt),stfp(imt,nt)
#ifdef bottom
     *             ,cmf(imt)
#endif
