c
c=======================================================================
c  Include file "cvmix.h"
c=======================================================================
c
#ifndef rmdocinc
c  Variables associated with vertical viscosity/diffussion:
c
c  AIDIF    coefficient for implicit time differencing for vertical
c           diffusion:
c           AIDIF=1.0  =>  fully implicit case
c           AIDIF=0.0  =>  fully explicit case
c           Note: not used if "explicitvmix" is enabled.
c  CDBOT    bottom drag coefficient.
c  FKPH     background vertical eddy diffusion coefficient (cm^2/s), for
c           tracers (salt, heat, and biological tracers).
c  FKPM     background vertical eddy viscosity coefficient (cm^2/s), for
c           momentum.
c  VDC      vertical eddy diffusion coefficient (cm^2/s).
c  VDCLIM   vertical eddy diffusion coefficient (cm^2/s) for tracers
c           used when the water column is gravitationally unstable.
c  VVC      vertical eddy viscosity coefficient (cm^2/s).
c  VVCLIM   vertical eddy viscosity coefficient (cm^2/s) for momentum
c           used when the water column is gravitationally unstable.
c  WDMIX    vertical eddy diffusion coefficient (cm^2/s) for tracers
c           used in the wind-mixed "surface layer" (see MLDOPT).
c  WVMIX    vertical eddy viscosity coefficient (cm^2/s) for momentum
c           used in the wind-mixed "surface layer" (see MLDOPT).
c  
c  Variables for calculating bulk mixed layer depth, used in determining
c  vertical mixing coefficient:
c
c  ATTH2O   light extinction coefficient due to water (1/cm).
c  CP       specific heat.
c  EKFAC    Factor in the Ekman depth Equation (Large et al., 1994;
c           Equation 29):
c               Ekman depth = EKFAC * USTAR / F
c  LATMF0   minimum latitude considered to compute Coriolis parameter
c           across the Equator (degrees).
c  MCOEF    Niiler and Kraus wind stress "m" coefficient for estimating
c           mixed-layer depth.
c  MLDMIN   minimum allowable mixed-layer depth estimate (centimeters).
c  MLDMAX   maximum allowable mixed-layer depth estimate (centimeters).
c  MLDOPT   surface layer mixing option (integer):
c           if MLDOPT=0, WVMIX and WDMIX are applied to a precribed
c                        "mixed-layer depth", MLD.
c           if MLDOPT=1, WVMIX and WDMIX are applied to an Ekman depth
c                        as determined by the wind stress forcing.
c           if MLDOPT=2, WVMIX and WDMIX are applied to a mixed-layer
c                        depth determined by the wind stress and
c                        buoyancy forcing.
c  MLDU     mixed-layer depth at row J on U,V grid.
c  MLDUM    mixed-layer depth at row J-1 on U,V grid.
c  MLDVAL   prescribed constant mixed-layer depth (centimeters).
c  NCOEF    Niiler and Kraus wind stress "n" coefficient for estimating
c           mixed-layer depth.
c  TAUMIN   minimum wind stress (dynes/cm^2).
c  WSDFAC   parameter fix to Niiler and Kraus (1977) Equation 10.30;
c           wind stress denominator-term weight factor.
c
c  Variables associated with vertical gravitational stability:
c
c  DRHO     vertical density difference on row J   at tracer grid box
c           bottoms.
c  DRHOP    vertical density difference on row J+1 at tracer grid box
c           bottoms.
c
c  Variables associated with tidally enhanced vertical mixing model:
c
c  CDTID    tidal friction coefficient.                 (s)
c  MTDDPTH  maximum water depth over which to
c           apply tidal enhancing to vertical mixing.   (cm)
c  TDMXFRC  tidal mixing limit.                         (cm^2/s)
c  TDMXFAC  constant tidal mixing coefficient.          (cm^2/s)
c
c=======================================================================
c
#endif
      common /icvmix/ mldopt
      integer mldopt
c
      common /fcvmix/ aidif,fkpm,vvclim,wvmix,vvc,fkph,vdclim,wdmix,vdc,
     *       cp,atth2o,taumin,latmf0,mcoef,ncoef,mldval,mldmin,mldmax,
     *       mldu,mldum,ekfac,wsdfac,drho,drhop,cdbot,cdtid,mtddpth,
     *       tdmxfac,tdmxfrc
      FLOAT
     *      aidif,atth2o,cdbot,cdtid,cp,ekfac,fkph,fkpm,latmf0,mcoef,
     *      mldmax,mldmin,mldval,mtddpth,ncoef,taumin,tdmxfac,tdmxfrc,
     *      vdclim,vvclim,wdmix,wsdfac,wvmix
      FLOAT
     *      drho(imt,km),drhop(imt,km),mldu(imt),mldum(imt),
     *      vdc(imt,km),vvc(imt,km)
