      subroutine defbparm (ncid,vartyp)
c
c=======================================================================
c                                                                    ===
c  This routine defines the biological parameters to the output      ===
c  netCDF file.  This particular version does so for the             ===
c  Fasham model.                                                     ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     NCID     Identifier for output netCDF file.   (integer)        ===
c     VARTYP   NetCDF code for real variables.      (integer)        ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <cbiopnh.h>
#include <netcdf.inc>
#include <pe_netcdf.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer       ncid,sbgn,send,slen,vartyp
      character*256 wkstr
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define light parameters.
c-----------------------------------------------------------------------
c
      varid = ncvdef (ncid,'attphy',vartyp,0,0,rcode)
      wkstr = 'phytoplankton light attenuation scale'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'liter micromole-1 meter-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'parfrac',vartyp,0,0,rcode)
      wkstr = 'fraction of shortwave radiation that is '//
     &        'photosynthetically active'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
c-----------------------------------------------------------------------
c  Define phytoplankton growth parameters.
c-----------------------------------------------------------------------
c
      varid = ncvdef (ncid,'phygrth',vartyp,0,0,rcode)
      wkstr = 'initial slope of photosynthesis response to light'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'meter2 Watt-1 day-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'phyexud',vartyp,0,0,rcode)
      wkstr = 'fraction of primary production exuded as DON'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'phylr1',vartyp,0,0,rcode)
      wkstr = 'phytoplankton mortality rate'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'day-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
c-----------------------------------------------------------------------
c  Define temperature dependence parameters.
c-----------------------------------------------------------------------
c
      varid = ncvdef (ncid,'grthpa',vartyp,0,0,rcode)
      wkstr = 'temperature-dependent growth rate parameter a'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'day-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'grthpb',vartyp,0,0,rcode)
      wkstr = 'temperature-dependent growth rate parameter b'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'grthpc',vartyp,0,0,rcode)
      wkstr = 'temperature-dependent growth rate parameter a'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'Celsius-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
c-----------------------------------------------------------------------
c  Define nutrient uptake parameters.
c-----------------------------------------------------------------------
c
      varid = ncvdef (ncid,'hsno3',vartyp,0,0,rcode)
      wkstr = 'half saturation constant for nitrate uptake'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'micromole liter-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'hsnh4',vartyp,0,0,rcode)
      wkstr = 'half saturation constant for ammonium uptake'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'micromole liter-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'no3inh',vartyp,0,0,rcode)
      wkstr = 'strength of ammonium inhibition of nitrate uptake'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'liter micromole-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
c-----------------------------------------------------------------------
c  Define zooplankton grazing parameters.
c-----------------------------------------------------------------------
c
      varid = ncvdef (ncid,'zgrazr',vartyp,0,0,rcode)
      wkstr = 'zooplankton maximum growth rate'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'day-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'zgrazk',vartyp,0,0,rcode)
      wkstr = 'zooplankton growth half-saturation constant'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'micromole liter-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'zasseff',vartyp,0,0,rcode)
      wkstr = 'zooplankton assimilation efficiency fraction'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'prefphy',vartyp,0,0,rcode)
      wkstr = 'zooplankton grazing preference for phytoplankton'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'prefbac',vartyp,0,0,rcode)
      wkstr = 'zooplankton grazing preference for bacteria'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'prefpon',vartyp,0,0,rcode)
      wkstr = 'zooplankton grazing preference for PON'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
c-----------------------------------------------------------------------
c  Define zooplankton loss rate parameters.
c-----------------------------------------------------------------------
c
      varid = ncvdef (ncid,'zexcrr',vartyp,0,0,rcode)
      wkstr = 'zooplankton excretion rate'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'day-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'zexcnh4',vartyp,0,0,rcode)
      wkstr = 'fraction of zooplankton excretion to NH4'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'zmortr',vartyp,0,0,rcode)
      wkstr = 'zooplankton mortality rate'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'day-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'zmortex',vartyp,0,0,rcode)
      wkstr = 'fraction of zooplankton mortality to export'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
c-----------------------------------------------------------------------
c  Define bacterial growth parameters.
c-----------------------------------------------------------------------
c
      varid = ncvdef (ncid,'bacgrr',vartyp,0,0,rcode)
      wkstr = 'bacteria maximum growth rate'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'day-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'bacgrk',vartyp,0,0,rcode)
      wkstr = 'bacteria uptake half-saturation constant'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'micromole liter-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'bacfrac',vartyp,0,0,rcode)
      wkstr = 'bacterial ratio of NH4/DON uptake'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'bexcrr',vartyp,0,0,rcode)
      wkstr = 'bacteria excretion rate to NH4'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'day-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
c-----------------------------------------------------------------------
c  Define PON parameters.
c-----------------------------------------------------------------------
c
      varid = ncvdef (ncid,'wsnkpon',vartyp,0,0,rcode)
      wkstr = 'sinking rate for particulate organic nitrogen'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'meter day-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'brknpon',vartyp,0,0,rcode)
      wkstr = 'PON breakdown rate to DON'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'day-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
c-----------------------------------------------------------------------
c  Define remineralization parameters.
c-----------------------------------------------------------------------
c
      varid = ncvdef (ncid,'rmnbio',vartyp,0,0,rcode)
      wkstr = 'aphotic zone decay timescale for PHY, ZOO, BAC, DON'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'day-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'rmnpon1',vartyp,0,0,rcode)
      wkstr = 'linear aphotic zone decay timescale for PON'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'day-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'rmnpon2',vartyp,0,0,rcode)
      wkstr = 'quadratic decay timescale for PON'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'liter micromole-1 day-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'rmnnh4',vartyp,0,0,rcode)
      wkstr = 'aphotic zone decay timescale for NH4'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'day-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
c-----------------------------------------------------------------------
c  Define euphotic zone parameters.
c-----------------------------------------------------------------------
c
      varid = ncvdef (ncid,'sbldep',vartyp,0,0,rcode)
      wkstr = 'euphotic zone depth'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'meter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
c-----------------------------------------------------------------------
c  Define positive insurance parameters.
c-----------------------------------------------------------------------
c
      varid = ncvdef (ncid,'biopos',nclong,0,0,rcode)
      wkstr = 'switch to enforce positive biological fields'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'do not enforce'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'option_0',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'enforce'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'option_1',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'kill run if negative fields found'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'option_3',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
#if defined codunlim | defined codlim
c-----------------------------------------------------------------------
c  Define cod behavior parameters.
c-----------------------------------------------------------------------
c
      varid = ncvdef (ncid,'cdzmin',vartyp,0,0,rcode)
      wkstr = 'Cod minimum preferred depth'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'meter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'cdzmax',vartyp,0,0,rcode)
      wkstr = 'Cod maximum preferred depth'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'meter'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'cdkz',vartyp,0,0,rcode)
      wkstr = 'Cod response to depth coefficient'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
#  ifdef codunlim
      wkstr = 'second-1'
#   else
      wkstr = 'centimeter-1'
#  endif
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'cdkp',vartyp,0,0,rcode)
      wkstr = 'Cod response to prey coefficient'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
#  ifdef codunlim
      wkstr = 'centimeter2 liter second-1 micromole-1'
#   else
      wkstr = 'centimeter liter micromole-1'
#  endif
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'cdtmin',vartyp,0,0,rcode)
      wkstr = 'Cod minimum preferred temperature'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'Celsius'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'cdtmax',vartyp,0,0,rcode)
      wkstr = 'Cod maximum preferred temperature'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'Celsius'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
      varid = ncvdef (ncid,'cdkt',vartyp,0,0,rcode)
      wkstr = 'Cod response to temperature coefficient'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
#  ifdef codunlim
      wkstr = 'centimeter2 second-1 Celsius-2'
#   else
      wkstr = 'centimeter Celsius-2'
#  endif
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
#  ifdef codlim
c
      varid = ncvdef (ncid,'cdspd',vartyp,0,0,rcode)
      wkstr = 'Cod maximum cruising speed'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'centimeter second-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
#  endif
c
      varid = ncvdef (ncid,'cdwmax',vartyp,0,0,rcode)
      wkstr = 'Cod maximum vertical swimming speed'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'long_name',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
      wkstr = 'centimeter second-1'
      call length (wkstr,slen,sbgn,send)
      call ncaptc (ncid,varid,'units',ncchar,slen,
     &             wkstr(sbgn:send),rcode)
c
#endif
      return
      end
