      subroutine defnrg
c
c=======================================================================
c                                                                    ===
c  This routine creates the PE model energy/diagnostics NetCDF file, ===
c  its dimensions, its variables and their attributes.               ===
c                                                                    ===
c  Calls: NCAPT, NCAPTC, NCCRE, NCDDEF, NCENDF, NCPOPT, NCVDEF,      ===
c         NCVID, NCVPT, NCVGPC, NCVGP1 (NetCDF library)              ===
c         DEPTHSLAB, EXITUS, LENGTH                                  ===
c                                                                    ===
c  WARNING:  Character argument to NetCDF routines NCAPT, NCAPTC,    ===
c            NCDDEF, NCVDEF, and NCVID is (upper/lower) case         ===
c            sensitive.                                              ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <scalar.h>
#include <runid.h>
#include <iounits.h>
#include <options.h>
#include <cdiag.h>
#include <moddat.h>
#include <hybrid.h>
#include <netcdf.inc>
#include <pe_netcdf.h>
#include <version.h>
#if defined bioAnder | defined bioFasham | defined bioMcGillic | defined bioDuse
# include <cbiopnh.h>
#endif
c
c-----------------------------------------------------------------------
c Define local data.
c-----------------------------------------------------------------------
c
      integer ax3dim,k,lev1dim,lev2dim,lmod,m,mbgn,mend,mtermdim,
     *        mtermm3dim,olevdim,ptr,sbgn,send,slen,sofar,tlatdim,
     *        tlondim,tnrgdim,trcdim,ttermdim,usrdim1,usrdim2,vartyp,
     *        vec2dim,vec3dim,vlatdim,vlondim
      integer count(5),start(5)
#ifdef coast
      integer ax2dim
#endif
      integer vardim(5)
#if defined bndy_rlx | defined cstfrc | defined botfrc
      character*6 dum6
#endif
      character*256 dummy
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c  Create netCDF file.
c
      call length (nrgname,slen,sbgn,send)
      ncnrgid=nccre(nrgname(sbgn:send),ncnoclob,rcode)
      if(rcode.eq.0) then
         ncnrgst = 1
        else
         write(stdout,900) nrgname(sbgn:send)
         call exitus('DEFNRG')
      endif
c
c  Define the dimensions of the netCDF fields.
c
      tlatdim=ncddef(ncnrgid,'tlat',jmt,rcode)
      tlondim=ncddef(ncnrgid,'tlon',imt,rcode)
      vlatdim=ncddef(ncnrgid,'vlat',jmt,rcode)
      vlondim=ncddef(ncnrgid,'vlon',imt,rcode)
      lev1dim=ncddef(ncnrgid,'level1',km,rcode)
      lev2dim=ncddef(ncnrgid,'level2',kmp1,rcode)
      olevdim=ncddef(ncnrgid,'outlev',nlev,rcode)
      trcdim=ncddef(ncnrgid,'tracer',nt,rcode)
      vec2dim=ncddef(ncnrgid,'vector2',2,rcode)
      vec3dim=ncddef(ncnrgid,'vector3',3,rcode)
      tnrgdim=ncddef(ncnrgid,'time',ncunlim,rcode)
#ifdef coast
      ax2dim=ncddef(ncnrgid,'axis2',2,rcode)
#endif
      ax3dim=ncddef(ncnrgid,'axis3',3,rcode)
      ttermdim=ncddef(ncnrgid,'tterm',tterms,rcode)
      mtermdim=ncddef(ncnrgid,'mterm',mterms,rcode)
      mtermm3dim=ncddef(ncnrgid,'mtermm3',mterms-3,rcode)
      usrdim1=ncddef(ncnrgid,'usrdim1',10,rcode)
      usrdim2=ncddef(ncnrgid,'usrdim2',30,rcode)
c
c-----------------------------------------------------------------------
c  Define type of floating-point variables: single or double precision.
c-----------------------------------------------------------------------
c
#ifdef dblprec
      vartyp=ncdouble
#else
      vartyp=ncfloat
#endif
c
c-----------------------------------------------------------------------
c  Define global attributes.
c-----------------------------------------------------------------------
c
      call length (model,lmod,mbgn,mend)
      dummy=model(mbgn:mend)//' energy/diagnostics fields'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ncglobal,'title',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      call length (outname,slen,sbgn,send)
      call ncaptc (ncnrgid,ncglobal,'out_file',ncchar,slen,
     *             outname(sbgn:send),rcode)
      call length (nrgname,slen,sbgn,send)
      call ncaptc (ncnrgid,ncglobal,'nrg_file',ncchar,slen,
     *             nrgname(sbgn:send),rcode)
#ifdef ldrifters
      call length (trkname,slen,sbgn,send)
      call ncaptc (ncnrgid,ncglobal,'trk_file',ncchar,slen,
     *             trkname(sbgn:send),rcode)
      call length (dposnam,slen,sbgn,send)
      call ncaptc (ncnrgid,ncglobal,'trk_parm',ncchar,slen,
     *             dposnam(sbgn:send),rcode)
#endif
#ifndef analytical
      call length (inpname,slen,sbgn,send)
      call ncaptc (ncnrgid,ncglobal,'inp_file',ncchar,slen,
     *             inpname(sbgn:send),rcode)
#endif
#ifdef forcing
      call length (frcname,slen,sbgn,send)
      call ncaptc (ncnrgid,ncglobal,'frc_file',ncchar,slen,
     *             frcname(sbgn:send),rcode)
#endif
#ifdef oias
      call length (assname,slen,sbgn,send)
      call ncaptc (ncnrgid,ncglobal,'ass_file',ncchar,slen,
     *             assname(sbgn:send),rcode)
      call length (aparnam,slen,sbgn,send)
      call ncaptc (ncnrgid,ncglobal,'ass_parm',ncchar,slen,
     *             aparnam(sbgn:send),rcode)
#endif
#ifdef extraction
      call length (xparnam,slen,sbgn,send)
      call ncaptc (ncnrgid,ncglobal,'xtr_parm',ncchar,slen,
     *             xparnam(sbgn:send),rcode)
#endif
#if defined bioAnder | defined bioFasham | defined bioMcGillic | defined bioDuse
      call length (bparnam,slen,sbgn,send)
      call ncaptc (ncnrgid,ncglobal,'bio_parm',ncchar,slen,
     *             bparnam(sbgn:send),rcode)
#endif
      call ncaptc (ncnrgid,ncglobal,'type',ncchar,lmod,model(mbgn:mend),
     *             rcode)
      call length (vnum,slen,sbgn,send)
      call ncaptc (ncnrgid,ncglobal,'version',ncchar,slen,
     *             vnum(sbgn:send),rcode)
      call length (history,slen,sbgn,send)
      call ncaptc (ncnrgid,ncglobal,'history',ncchar,slen,
     *             history(sbgn:send),rcode)
c
c-----------------------------------------------------------------------
c  Define model parameters.
c-----------------------------------------------------------------------
c
c  Define ocean basin area and volume.
c
      varid = ncvdef (ncnrgid,'area',vartyp,0,0,rcode)
      dummy = 'ocean basin area'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'meter2'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
      varid = ncvdef (ncnrgid,'volume',vartyp,0,0,rcode)
      dummy = 'ocean basin volume'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'meter3'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
c  Define model domain parameters.
c
      varid = ncvdef (ncnrgid,'coord',nclong,0,0,rcode)
      dummy = 'flag for type of horizontal grid'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'cartesian (tangent plane) grid'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'option_0',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'unrotated spherical grid'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'option_1',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'rotated spherical grid'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'option_2',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
      varid = ncvdef (ncnrgid,'rlngd',vartyp,0,0,rcode)
      dummy = 'transformation centroid longitude'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'degrees_east'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
      varid = ncvdef (ncnrgid,'rlatd',vartyp,0,0,rcode)
      dummy = 'transformation centroid latitude'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'degrees_north'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
      varid = ncvdef (ncnrgid,'delx',vartyp,0,0,rcode)
      dummy = 'domain longitudinal offset'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      if (coord.eq.0) then
        dummy = 'centimeter'
       else
        dummy = 'degrees'
      endif
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
      varid = ncvdef (ncnrgid,'dely',vartyp,0,0,rcode)
      dummy = 'domain latitudinal offset'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      if (coord.eq.0) then
        dummy = 'centimeter'
       else
        dummy = 'degrees'
      endif
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
      varid = ncvdef (ncnrgid,'thetad',vartyp,0,0,rcode)
      dummy = 'domain rotation angle'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'degrees'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
c  Define time steping parameters.
c
      varid = ncvdef (ncnrgid,'dtts',vartyp,0,0,rcode)
      dummy = 'length of timestep on tracers'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'seconds'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
      varid = ncvdef (ncnrgid,'dtuv',vartyp,0,0,rcode)
      dummy = 'length of timestep on momentum'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'seconds'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
      varid=ncvdef(ncnrgid,'dtsf',vartyp,0,0,rcode)
      dummy = 'length of timestep on transport streamfunction'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'seconds'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
c-----------------------------------------------------------------------
c  Define flags, options, and switches arrays and their attributes
c  in the NetCDF file.
c-----------------------------------------------------------------------
c
      varid = ncvdef (ncnrgid,'iflag',nclong,1,usrdim1,rcode)
      dummy = 'initialization flags'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
      varid = ncvdef (ncnrgid,'iopt',nclong,1,usrdim1,rcode)
      dummy = 'tunable options and switches'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
      varid = ncvdef (ncnrgid,'iout',nclong,1,usrdim2,rcode)
      dummy = 'switches specifing which fields to write out'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
#if defined bioAnder | defined bioFasham | defined bioMcGillic | defined bioDuse
      varid = ncvdef (ncnrgid,'ibiout',nclong,1,usrdim2,rcode)
      dummy = 'switches specifing which biological fields to write out'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
#endif
      varid = ncvdef (ncnrgid,'outlev',nclong,1,olevdim,rcode)
      dummy = 'output vertical levels or depths'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'meters, if value is greater than number of levels'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
c-----------------------------------------------------------------------
c  Define geometry variables and their attributes in the netCDF file.
c-----------------------------------------------------------------------
c
c  Define depths and thicknesses for the flat reference levels.
c
      varid = ncvdef (ncnrgid,'refz',vartyp,1,lev1dim,rcode)
      dummy = 'depths at center of the flat grid vertical boxes'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'meter'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
      varid = ncvdef (ncnrgid,'hz',vartyp,1,lev1dim,rcode)
      dummy = 'thicknesses of the flat grid vertical boxes'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'meter'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
c  Define 3D grid positions at tracer and velocity points.  These fields
c  are used in the vizualization modules.
c
      vardim(1)=ax3dim
      vardim(2)=olevdim
      vardim(3)=tlondim
      vardim(4)=tlatdim
      if((iout(15).ne.0).or.(iout(20).eq.1)) then
        varid = ncvdef (ncnrgid,'tgrid3',vartyp,4,vardim,rcode)
        dummy = '3D grid positions at tracer points'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        dummy = '1: longitude, 2: latitude, 3: depth'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,varid,'axis',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        dummy = 'degrees_east, degrees_north, meter'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,varid,'units',ncchar,slen,
     *               dummy(sbgn:send),rcode)
      endif
c
      vardim(3)=vlondim
      vardim(4)=vlatdim
      if(iout(10).ne.0) then
        varid = ncvdef (ncnrgid,'vgrid3',vartyp,4,vardim,rcode)
        dummy = '3D grid positions at velocity points'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        dummy = '1: longitude, 2: latitude, 3: depth'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,varid,'axis',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        dummy = 'degrees_east, degrees_north, meter'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,varid,'units',ncchar,slen,
     *               dummy(sbgn:send),rcode)
      endif
#ifdef coast
c
c  Define 2D grid positions at tracer and velocity points.  These fields
c  are used in the vizualization modules.
c
      vardim(1)=ax2dim
      vardim(2)=tlondim
      vardim(3)=tlatdim
      varid = ncvdef (ncnrgid,'tgrid2',vartyp,3,vardim,rcode)
      dummy = '2D grid positions at tracer points'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = '1: longitude, 2: latitude'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'axis',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'degrees_east, degrees_north'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
      vardim(2)=vlondim
      vardim(3)=vlatdim
      varid = ncvdef (ncnrgid,'vgrid2',vartyp,3,vardim,rcode)
      dummy = '2D grid positions at velocity points'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = '1: longitude, 2: latitude'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'axis',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'degrees_east, degrees_north'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
c  Define land/sea mask at the tracer and velocity points.
c
      vardim(1)=tlondim
      vardim(2)=tlatdim
      varid = ncvdef (ncnrgid,'landt',nclong,2,vardim,rcode)
      dummy = 'land/sea mask at tracer points'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = '0: land, 1: sea'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'options',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'Tmask, scalar'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'field',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'tgrid2'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'positions',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
      vardim(1)=tlondim
      vardim(2)=tlatdim
      varid = ncvdef (ncnrgid,'landv',nclong,2,vardim,rcode)
      dummy = 'land/sea mask at velocity points'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = '0: land, 1: boundary, 2: sea'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'options',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'Vmask, scalar'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'field',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'vgrid2'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,varid,'positions',ncchar,slen,
     *             dummy(sbgn:send),rcode)
#endif
c
c-----------------------------------------------------------------------
c  Define diagnostic variables and their attributes.
c-----------------------------------------------------------------------
c
c  Define time coordinate.
c
      tnrgid = ncvdef (ncnrgid,'time',vartyp,1,tnrgdim,rcode)
      dummy = 'time since initialization'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tnrgid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'seconds'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tnrgid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'time, scalar, series'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tnrgid,'field',ncchar,slen,
     *             dummy(sbgn:send),rcode)
c
c  Buoyancy work.
c
      if(iout(15).eq.1) then
        vardim(1)=olevdim
        vardim(2)=tlondim
        vardim(3)=tlatdim
        vardim(4)=tnrgdim
        buoyid = ncvdef (ncnrgid,'buoy',vartyp,4,vardim,rcode)
        dummy = 'buoyancy work per unit volume'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,buoyid,'long_name',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        dummy = 'gigawatt'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,buoyid,'units',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        dummy = 'buoyancy work, scalar, series'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,buoyid,'field',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        dummy = 'tgrid3'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,buoyid,'positions',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        call ncapt (ncnrgid,buoyid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncnrgid,buoyid,'missing_value',vartyp,1,spval,rcode)
      endif
c
c  Average buoyancy work.
c
      vardim(1)=lev2dim
      vardim(2)=tnrgdim
      bavgid = ncvdef (ncnrgid,'buoy_avg',vartyp,2,vardim,rcode)
      dummy = 'average buoyancy work per unit volume'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,bavgid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'gigawatt'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,bavgid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'average buoyancy work, scalar, series'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,bavgid,'field',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      call ncapt (ncnrgid,bavgid,'_FillValue',vartyp,1,spval,rcode)
      call ncapt (ncnrgid,bavgid,'missing_value',vartyp,1,spval,rcode)
c
c  Kinetic energy.
c
      if((iout(10).eq.1).or.(iout(10).eq.3)) then
        vardim(1)=olevdim
        vardim(2)=vlondim
        vardim(3)=vlatdim
        vardim(4)=tnrgdim
        ketotid = ncvdef (ncnrgid,'ke_tot',vartyp,4,vardim,rcode)
        dummy = 'total kinetic energy per unit volume'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,ketotid,'long_name',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        dummy = 'petajoule'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,ketotid,'units',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        dummy = 'kinetic energy, scalar, series'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,ketotid,'field',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        dummy = 'vgrid3'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,ketotid,'positions',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        call ncapt (ncnrgid,ketotid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncnrgid,ketotid,'missing_value',vartyp,1,spval,
     *              rcode)
      endif
c
c  Time rate of change of kinetic energy components.
c
      if((iout(10).eq.2).or.(iout(10).eq.3)) then
        vardim(1)=mtermm3dim
        vardim(2)=olevdim
        vardim(3)=vlondim
        vardim(4)=vlatdim
        vardim(5)=tnrgdim
        ketrmid = ncvdef (ncnrgid,'ke_terms',vartyp,5,vardim,rcode)
        dummy = 'time rate of change of kinetic energy components'//
     *          ' per unit volume'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,ketrmid,'long_name',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        dummy = 'change due to pressure term'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,ketrmid,'term01',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        dummy = 'change due to zonal advection'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,ketrmid,'term02',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        dummy = 'change due to meridional advection'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,ketrmid,'term03',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        dummy = 'change due to vertical advection'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,ketrmid,'term04',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        dummy = 'change due to zonal diffusion'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,ketrmid,'term05',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        dummy = 'change due to meridional diffusion'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,ketrmid,'term06',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        dummy = 'change due to vertical diffusion'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,ketrmid,'term07',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        dummy = 'change due to metric diffusion terms'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,ketrmid,'term08',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        dummy = 'change due to Coriolis term'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,ketrmid,'term09',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        sofar=MTERMS00-3
#if defined bndy_rlx | defined cstfrc | defined botfrc
        sofar=sofar+1
        write (dum6,10) sofar
  10    format ('term',i2.2)
        dummy = 'change due to boundary relaxation terms'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,ketrmid,dum6,ncchar,slen,
     *               dummy(sbgn:send),rcode)
#endif
        dummy = 'microwatt meter-3'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,ketrmid,'units',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        dummy = 'KE components, vector, series'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,ketrmid,'field',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        dummy = 'vgrid3'
        call length (dummy,slen,sbgn,send)
        call ncaptc (ncnrgid,ketrmid,'positions',ncchar,slen,
     *               dummy(sbgn:send),rcode)
        call ncapt (ncnrgid,ketrmid,'_FillValue',vartyp,1,spval,rcode)
        call ncapt (ncnrgid,ketrmid,'missing_value',vartyp,1,spval,
     *              rcode)
      endif
c
c  Time rate of change of tracer components.
c
      if(iout(20).eq.1) then
        vardim(1)=ttermdim
        vardim(2)=olevdim
        vardim(3)=vlondim
        vardim(4)=vlatdim
        vardim(5)=tnrgdim
        do 20 m = 1,nt
          call length (tname(1,m),slen,sbgn,send)
          dummy = tname(1,m)(sbgn:send)//'_bterms'
          call length (dummy,slen,sbgn,send)
          varid = ncvdef(ncnrgid,dummy(sbgn:send),vartyp,5,vardim,rcode)
          trmtvid(m)=varid
          call length (tname(2,m),slen,sbgn,send)
          dummy = 'time rate of change of '//tname(2,m)(sbgn:send)//
     *             ' components per unit volume'
          call length (dummy,slen,sbgn,send)
          call ncaptc (ncnrgid,varid,'long_name',ncchar,slen,
     *                 dummy(sbgn:send),rcode)
          dummy = 'total rate of change'
          call length (dummy,slen,sbgn,send)
          call ncaptc (ncnrgid,varid,'term01',ncchar,slen,
     *                 dummy(sbgn:send),rcode)
          dummy = 'change due to zonal advection'
          call length (dummy,slen,sbgn,send)
          call ncaptc (ncnrgid,varid,'term02',ncchar,slen,
     *                 dummy(sbgn:send),rcode)
          dummy = 'change due to meridional advection'
          call length (dummy,slen,sbgn,send)
          call ncaptc (ncnrgid,varid,'term03',ncchar,slen,
     *                 dummy(sbgn:send),rcode)
          dummy = 'change due to vertical advection'
          call length (dummy,slen,sbgn,send)
          call ncaptc (ncnrgid,varid,'term04',ncchar,slen,
     *                 dummy(sbgn:send),rcode)
          dummy = 'change due to zonal diffusion'
          call length (dummy,slen,sbgn,send)
          call ncaptc (ncnrgid,varid,'term05',ncchar,slen,
     *                 dummy(sbgn:send),rcode)
          dummy = 'change due to meridional diffusion'
          call length (dummy,slen,sbgn,send)
          call ncaptc (ncnrgid,varid,'term06',ncchar,slen,
     *                 dummy(sbgn:send),rcode)
          dummy = 'change due to vertical diffusion'
          call length (dummy,slen,sbgn,send)
          call ncaptc (ncnrgid,varid,'term07',ncchar,slen,
     *                 dummy(sbgn:send),rcode)
          dummy = 'change due to source/sink terms'
          call length (dummy,slen,sbgn,send)
          call ncaptc (ncnrgid,varid,'term08',ncchar,slen,
     *                 dummy(sbgn:send),rcode)
          sofar=8
#ifdef bndy_rlx
          sofar=sofar+1
          write (dum6,10) sofar
          dummy = 'change due to boundary relaxation terms'
          call length (dummy,slen,sbgn,send)
          call ncaptc (ncnrgid,varid,dum6,ncchar,slen,
     *                 dummy(sbgn:send),rcode)
#endif
          call length (tname(3,m),slen,sbgn,send)
          dummy = tname(3,m)(sbgn:send)//' second-1'
          call length (dummy,slen,sbgn,send)
          call ncaptc (ncnrgid,varid,'units',ncchar,slen,
     *                 dummy(sbgn:send),rcode)
          call length (tname(4,m),slen,sbgn,send)
          ptr = index (tname(4,m),',') - 1
          dummy = tname(4,m)(sbgn:ptr)//' balance components, vector,'//
     *            ' series'
          call length (dummy,slen,sbgn,send)
          call ncaptc (ncnrgid,varid,'field',ncchar,slen,
     *                 dummy(sbgn:send),rcode)
          dummy = 'tgrid3'
          call length (dummy,slen,sbgn,send)
          call ncaptc (ncnrgid,varid,'positions',ncchar,slen,
     *                 dummy(sbgn:send),rcode)
          call ncapt (ncnrgid,varid,'_FillValue',vartyp,1,spval,rcode)
          call ncapt (ncnrgid,varid,'missing_value',vartyp,1,spval,
     *                rcode)
  20    continue
      endif
c
c  Time rate of change of average internal mode kinetic energy
c  components.
c
      vardim(1)=mtermdim
      vardim(2)=lev2dim
      vardim(3)=tnrgdim
      ikeavgid = ncvdef (ncnrgid,'ke_intavg',vartyp,3,vardim,rcode)
      dummy = 'time rate of change of average internal mode '//
     *           'kinetic energy components per unit volume'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ikeavgid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'total time rate of change'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ikeavgid,'term01',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to pressure term'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ikeavgid,'term02',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to zonal advection'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ikeavgid,'term03',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to meridional advection'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ikeavgid,'term04',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to vertical advection'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ikeavgid,'term05',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to zonal diffusion'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ikeavgid,'term06',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to meridional diffusion'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ikeavgid,'term07',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to vertical diffusion'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ikeavgid,'term08',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to work by wind'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ikeavgid,'term09',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to bottom drag'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ikeavgid,'term10',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to metric diffusion terms'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ikeavgid,'term11',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to Coriolis term'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ikeavgid,'term12',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      sofar=MTERMS00
#if defined bndy_rlx | defined cstfrc | defined botfrc
      sofar=sofar+1
      write (dum6,10) sofar
      dummy = 'change due to boundary relaxation terms'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ikeavgid,dum6,ncchar,slen,
     *             dummy(sbgn:send),rcode)
#endif
      dummy = 'gigawatt'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ikeavgid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'internal KE averages, scalar, series'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ikeavgid,'field',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      call ncapt (ncnrgid,ikeavgid,'_FillValue',vartyp,1,spval,rcode)
      call ncapt (ncnrgid,ikeavgid,'missing_value',vartyp,1,spval,rcode)
c
c  Time rate of change of average external mode kinetic energy
c  components.
c
      vardim(1)=mtermdim
      vardim(2)=tnrgdim
      ekeavgid = ncvdef (ncnrgid,'ke_extavg',vartyp,2,vardim,rcode)
      dummy = 'time rate of change of average external mode '//
     *           'kinetic energy components per unit volume'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ekeavgid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'total time rate of change'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ekeavgid,'term01',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to pressure term'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ekeavgid,'term02',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to zonal advection'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ekeavgid,'term03',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to meridional advection'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ekeavgid,'term04',ncchar,sbgn,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to vertical advection'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ekeavgid,'term05',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to zonal diffusion'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ekeavgid,'term06',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to meridional diffusion'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ekeavgid,'term07',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to vertical diffusion'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ekeavgid,'term08',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to work by wind'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ekeavgid,'term09',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to bottom drag'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ekeavgid,'term10',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to metric diffusion terms'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ekeavgid,'term11',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to Coriolis term'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ekeavgid,'term12',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      sofar=MTERMS00
#if defined bndy_rlx | defined cstfrc | defined botfrc
      sofar=sofar+1
      write (dum6,10) sofar
      dummy = 'change due to boundary relaxation terms'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ekeavgid,dum6,ncchar,slen,
     *             dummy(sbgn:send),rcode)
#endif
      dummy = 'gigawatt'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ekeavgid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'external KE averages, scalar, series'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ekeavgid,'field',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      call ncapt (ncnrgid,ekeavgid,'_FillValue',vartyp,1,spval,rcode)
      call ncapt (ncnrgid,ekeavgid,'missing_value',vartyp,1,spval,rcode)
c
c  Term balances for tracers.
c
      vardim(1)=trcdim
      vardim(2)=ttermdim
      vardim(3)=lev2dim
      vardim(4)=tnrgdim
      tbtrmid = ncvdef (ncnrgid,'t_bterms',vartyp,4,vardim,rcode)
      dummy = 'term balances for the time rate of change of '//
     *           'tracer per unit volume'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tbtrmid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'total time rate of change'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tbtrmid,'term01',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to zonal advection'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tbtrmid,'term02',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to meridional advection'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tbtrmid,'term03',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to vertical advection'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tbtrmid,'term04',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to zonal diffusion'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tbtrmid,'term05',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to meridional diffusion'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tbtrmid,'term06',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to vertical diffusion'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tbtrmid,'term07',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to source/sink terms'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tbtrmid,'term08',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      sofar=8
#ifdef bndy_rlx
      sofar=sofar+1
      write (dum6,10) sofar
      dummy = 'change due to boundary relaxation term'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tbtrmid,dum6,ncchar,slen,
     *             dummy(sbgn:send),rcode)
#endif
      dummy = 'meter3 second-1'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tbtrmid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'T_balances, matrix, series'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tbtrmid,'field',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      call ncapt (ncnrgid,tbtrmid,'_FillValue',vartyp,1,spval,rcode)
      call ncapt (ncnrgid,tbtrmid,'missing_value',vartyp,1,spval,rcode)
c
c  Term balances for momentum.
c
      vardim(1)=vec2dim
      vardim(2)=mtermdim
      vardim(3)=lev2dim
      vardim(4)=tnrgdim
      mbtrmid = ncvdef (ncnrgid,'m_bterms',vartyp,4,vardim,rcode)
      dummy = 'term balances for the time rate of change of '//
     *           'momentum per unit volume'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,mbtrmid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'total time rate of change'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,mbtrmid,'term01',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to pressure term'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,mbtrmid,'term02',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to zonal advection'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,mbtrmid,'term03',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to meridional advection'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,mbtrmid,'term04',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to vertical advection'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,mbtrmid,'term05',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to zonal diffusion'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,mbtrmid,'term06',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to meridional diffusion'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,mbtrmid,'term07',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to vertical diffusion'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,mbtrmid,'term08',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to work by wind'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,mbtrmid,'term09',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to bottom drag'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,mbtrmid,'term10',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to metric diffusion terms'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,mbtrmid,'term11',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'change due to Coriolis term'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,mbtrmid,'term12',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      sofar=MTERMS00
#if defined bndy_rlx | defined cstfrc | defined botfrc
      sofar=sofar+1
      write (dum6,10) sofar
      dummy = 'change due to boundary relaxation terms'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,mbtrmid,dum6,ncchar,39,
     *             dummy(sbgn:send),rcode)
#endif
      dummy = 'meter3 second-1'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,mbtrmid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'M_balances, vector, series'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,mbtrmid,'field',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      call ncapt (ncnrgid,mbtrmid,'_FillValue',vartyp,1,spval,rcode)
      call ncapt (ncnrgid,mbtrmid,'missing_value',vartyp,1,spval,rcode)
c
c  Northward transport of tracer.
c
      vardim(1)=trcdim
      vardim(2)=ttermdim
      vardim(3)=tlatdim
      vardim(4)=tnrgdim
      ttnid = ncvdef (ncnrgid,'ttn',vartyp,4,vardim,rcode)
      dummy = 'northward transport of tracer by components'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ttnid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'tracer centimeter3 second-1'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ttnid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'tracer transport, matrix, series'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,ttnid,'field',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      call ncapt (ncnrgid,ttnid,'_FillValue',vartyp,1,spval,rcode)
      call ncapt (ncnrgid,ttnid,'missing_value',vartyp,1,spval,rcode)
c
c  Meridional mass transport.
c
      vardim(1)=olevdim
      vardim(2)=vlatdim
      vardim(3)=tnrgdim
      tmtid = ncvdef (ncnrgid,'tmt',vartyp,3,vardim,rcode)
      dummy = 'meridional mass transport'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tmtid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'centimeter3 second-1'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tmtid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'mass transport, scalar, series'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tmtid,'field',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      call ncapt (ncnrgid,tmtid,'_FillValue',vartyp,1,spval,rcode)
      call ncapt (ncnrgid,tmtid,'missing_value',vartyp,1,spval,rcode)
c
c  Surface tracer flux.
c
      vardim(1)=trcdim
      vardim(2)=tnrgdim
      stflxid = ncvdef (ncnrgid,'stflx',vartyp,2,vardim,rcode)
      dummy = 'surface tracer flux per unit volume'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,stflxid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'centimeter2 second-1'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,stflxid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'surface tracer flux, vector, series'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,stflxid,'field',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      call ncapt (ncnrgid,stflxid,'_FillValue',vartyp,1,spval,rcode)
      call ncapt (ncnrgid,stflxid,'missing_value',vartyp,1,spval,rcode)
c
c  Surface momentum flux.
c
      vardim(1)=vec2dim
      vardim(2)=tnrgdim
      smflxid = ncvdef (ncnrgid,'smflx',vartyp,2,vardim,rcode)
      dummy = 'surface momentum flux per unit volume'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,smflxid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'dyne centimeter-2'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,smflxid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'surface momentum flux, vector, series'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,smflxid,'field',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      call ncapt (ncnrgid,smflxid,'_FillValue',vartyp,1,spval,rcode)
      call ncapt (ncnrgid,smflxid,'missing_value',vartyp,1,spval,rcode)
c
c  Average surface tracer.
c
      vardim(1)=trcdim
      vardim(2)=tnrgdim
      asstid = ncvdef (ncnrgid,'asst',vartyp,2,vardim,rcode)
      dummy = 'average surface tracer'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,asstid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'tracer units'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,asstid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'average surface tracer, vector, series'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,asstid,'field',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      call ncapt (ncnrgid,asstid,'_FillValue',vartyp,1,spval,rcode)
      call ncapt (ncnrgid,asstid,'missing_value',vartyp,1,spval,rcode)
c
c  Average tracer within volume.
c
      vardim(1)=trcdim
      vardim(2)=tnrgdim
      atwvid = ncvdef (ncnrgid,'atwv',vartyp,2,vardim,rcode)
      dummy = 'average tracer within volume'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,atwvid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'tracer units centimeter-3'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,atwvid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'average tracer, vector, series'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,atwvid,'field',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      call ncapt (ncnrgid,atwvid,'_FillValue',vartyp,1,spval,rcode)
      call ncapt (ncnrgid,atwvid,'missing_value',vartyp,1,spval,rcode)
c
c  Rate of change of tracer due to convection.
c
      vardim(1)=trcdim
      vardim(2)=tnrgdim
      tconvid = ncvdef (ncnrgid,'tconv',vartyp,2,vardim,rcode)
      dummy = 'time rate of change of tracer due to convection '//
     *           'per unit volume'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tconvid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'second-1'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tconvid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'T_convection, vector, series'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tconvid,'field',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      call ncapt (ncnrgid,tconvid,'_FillValue',vartyp,1,spval,rcode)
      call ncapt (ncnrgid,tconvid,'missing_value',vartyp,1,spval,rcode)
c
c  Rate of change of tracer variance.
c
      vardim(1)=trcdim
      vardim(2)=lev2dim
      vardim(3)=tnrgdim
      tvarid = ncvdef (ncnrgid,'tvar',vartyp,3,vardim,rcode)
      dummy = 'time rate of change of tracer variance per unit volume'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tvarid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'second-1'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tvarid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'T_variance, vector, series'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,tvarid,'field',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      call ncapt (ncnrgid,tvarid,'_FillValue',vartyp,1,spval,rcode)
      call ncapt (ncnrgid,tvarid,'missing_value',vartyp,1,spval,rcode)
c
c  Average velocity within volume.
c
      vardim(1)=vec3dim
      vardim(2)=tnrgdim
      avwvid = ncvdef (ncnrgid,'avwv',vartyp,2,vardim,rcode)
      dummy = 'average velocity within volume'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,avwvid,'long_name',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'centimeter second-1 centimeter-3'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,avwvid,'units',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      dummy = 'average velocity, vector, series'
      call length (dummy,slen,sbgn,send)
      call ncaptc (ncnrgid,avwvid,'field',ncchar,slen,
     *             dummy(sbgn:send),rcode)
      call ncapt (ncnrgid,avwvid,'_FillValue',vartyp,1,spval,rcode)
      call ncapt (ncnrgid,avwvid,'missing_value',vartyp,1,spval,rcode)
c
c=======================================================================
c  Leave definition mode.  =============================================
c=======================================================================
c
      call ncendf(ncnrgid,rcode)
      if(rcode.eq.0) then
         ncnrgst = 2
        else
         call length (nrgname,slen,sbgn,send)
         write(stdout,910) nrgname(sbgn:send)
         call exitus('DEFNRG')
      endif
c
c  Write out model domain parameters.
c
      varid=ncvid(ncnrgid,'coord',rcode)
      call ncvpt1(ncnrgid,varid,1,coord,rcode)
      varid=ncvid(ncnrgid,'rlngd',rcode)
      call ncvpt1(ncnrgid,varid,1,rlngd,rcode)
      varid=ncvid(ncnrgid,'rlatd',rcode)
      call ncvpt1(ncnrgid,varid,1,rlatd,rcode)
      varid=ncvid(ncnrgid,'delx',rcode)
      call ncvpt1(ncnrgid,varid,1,delx,rcode)
      varid=ncvid(ncnrgid,'dely',rcode)
      call ncvpt1(ncnrgid,varid,1,dely,rcode)
      varid=ncvid(ncnrgid,'thetad',rcode)
      call ncvpt1(ncnrgid,varid,1,thetad,rcode)
c
c  Write out time steping parameters.
c
      varid=ncvid(ncnrgid,'dtts',rcode)
      call ncvpt1(ncnrgid,varid,1,dtts,rcode)
      varid=ncvid(ncnrgid,'dtuv',rcode)
      call ncvpt1(ncnrgid,varid,1,dtuv,rcode)
      varid=ncvid(ncnrgid,'dtsf',rcode)
      call ncvpt1(ncnrgid,varid,1,dtsf,rcode)
c
c=======================================================================
c  Write out flags, options and switches arrays into the NetCDF file.
c=======================================================================
c
      varid=ncvid(ncnrgid,'iflag',rcode)
      start(1)=1
      count(1)=10
      call ncvpt(ncnrgid,varid,start,count,iflag,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'iflag'
        call exitus('DEFNRG')
      endif
      varid=ncvid(ncnrgid,'iopt',rcode)
      start(1)=1
      count(1)=10
      call ncvpt(ncnrgid,varid,start,count,iopt,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'iopt'
        call exitus('DEFNRG')
      endif
      varid=ncvid(ncnrgid,'iout',rcode)
      start(1)=1
      count(1)=20
      call ncvpt(ncnrgid,varid,start,count,iout,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'iout'
        call exitus('DEFNRG')
      endif
#if defined bioAnder | defined bioFasham | defined bioMcGillic | defined bioDuse
      varid=ncvid(ncnrgid,'ibiout',rcode)
      start(1)=1
      count(1)=20
      call ncvpt(ncnrgid,varid,start,count,ibiout,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'ibiout'
        call exitus('DEFNRG')
      endif
#endif
      varid=ncvid(ncnrgid,'outlev',rcode)
      start(1)=1
      count(1)=nlev
      call ncvpt(ncnrgid,varid,start,count,lev,rcode)
      if(rcode.ne.0) then
        write(stdout,930) 'outlev'
        call exitus('DEFNRG')
      endif
c
c  Write depths and thicknesses for the reference flat levels.
c
      do 30 k=1,km
        start(1)=k
        count(1)=1
        varid=ncvid(ncnrgid,'refz',rcode)
        call ncvpt(ncnrgid,varid,start,count,-abs(refz(k)*cm2m),rcode)
        if(rcode.ne.0) then
          write(stdout,930) 'refz'
          call exitus('DEFNRG')
        endif
        varid=ncvid(ncnrgid,'hz',rcode)
        call ncvpt(ncnrgid,varid,start,count,hz(k)*cm2m,rcode)
        if(rcode.ne.0) then
          write(stdout,930) 'hz'
          call exitus('DEFNRG')
        endif
  30  continue
c
c
 900  format(/' DEFNRG - unable to create PE output NetCDF file: ',a)
 910  format(/' DEFNRG - unable to define PE output NetCDF file: ',a)
 920  format(/' DEFNRG - error while writing variable: ',a,2x,
     *        ' into PE output NetCDF file.')
 930  format(/' DEFNRG - error while writing variable: ',a,2x,
     *        ' at row J = ',i5,2x,' into PE output NetCDF file.')
 940  format(/' DEFNRG - error while writing variable: ',a,2x,
     *        ' at row J = ',i5,2x,' and LEVEL = ',i5,2x,
     *        ' into PE output NetCDF file.')
      return
      end
