      subroutine depthslab(j,keytv,depthtv)
c
c=======================================================================
c                                                                    ===
c  This routine returns the depth at each grid point along a slab    ===
c  of constant J in the hybrid coordinate system.                    ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     J         index to select a slab of constant Y (integer).      ===
c     KEYTV     index to select depth at tracer [0] or U,V [1]       ===
c               grid point (integer).                                ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     DEPTHTV   the depths at points selected by KEYTV (real array). ===
c                                                                    ===
c     Calls:  none                                                   ===
c                                                                    ===
c     Common Blocks: (only relevant variables listed)                ===
c                                                                    ===
c                                                                    ===
c     /VERTICAL/                                                     ===
c                                                                    ===
c     HVZ       the depths at uv  3D grid points                     ===
c               (input; real array)                                  ===
c     HTZ       the depths at tracer  3D grid points                 ===
c               (input; real array)                                  ===
c                                                                    ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <pconst.h>
#include <param.h>
#include <vertical.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j,k,keytv
      FLOAT
     *      depthtv(imt,km)
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c

c
c-----------------------------------------------------------------------
c  Compute depths at each horizontal grid point.
c-----------------------------------------------------------------------
c
      if(keytv.eq.tgrid) then
        do 10  i=1,imt
          do 10  k=1,km
            depthtv(i,k)=htz(i,k,j)
  10    continue
      else
        do 20 i=1,imt
          do 20 k=1,km
            depthtv(i,k)=hvz(i,k,j)
  20    continue
      endif
      return
      end
