      subroutine drftdv (jpt,u,ub,v,vb)
c
c=======================================================================
c                                                                    ===
c  This routine gets the tidal velocity fields for computing drifter ===
c  positions.                                                        ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     JPT   Desired slab of velocities.       (integer)              ===
c     U     Present zonal velocities.         (real array; cm/s)     ===
c     UB    Previous zonal velocities.        (real array; cm/s)     ===
c     V     Present meridional velocities.    (real array; cm/s)     ===
c     VB    Previous meridional velocities.   (real array; cm/s)     ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /FULLWD/                                                          ===
c                                                                    ===
c     TTSEC    current elapsed time.   (real; s)                     ===
c                                                                    ===
c  /SCALAR/                                                          ===
c                                                                    ===
c     DTTS     length of timestep on tracer.   (real; s)             ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     U     Present zonal velocities +tide.        (real array; cm/s)===
c     UB    Previous zonal velocities +tide.       (real array; cm/s)===
c     V     Present meridional velocities +tide.   (real array; cm/s)===
c     VB    Previous meridional velocities +tide.  (real array; cm/s)===
c                                                                    ===
c  Calls:  GET_TIDE                                                  ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <fullwd.h>
#include <scalar.h>
#include <tidesp.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,jpt,k
      FLOAT
     *      u(imt,km),ub(imt,km),v(imt,km),vb(imt,km)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Get present tidal velocities.
c-----------------------------------------------------------------------
c
      call get_tide (max((jpt-1),1))
c
      if (jpt.gt.1) then
         do 10 k = 1, km
         do 10 i = 1, imt
            u(i,k) = u(i,k) + utidep(i,k)
            v(i,k) = v(i,k) + vtidep(i,k)
  10     continue
       else
         do 20 k = 1, km
         do 20 i = 1, imt
            u(i,k) = u(i,k) + utide(i,k)
            v(i,k) = v(i,k) + vtide(i,k)
  20     continue
      end if
c
c-----------------------------------------------------------------------
c  Get previous tidal velocities.
c-----------------------------------------------------------------------
c
      ttsec = ttsec - dtts
c
      call get_tide (max((jpt-1),1))
c
      ttsec = ttsec + dtts
c
      if (jpt.gt.1) then
         do 30 k = 1, km
         do 30 i = 1, imt
            ub(i,k) = ub(i,k) + utidep(i,k)
            vb(i,k) = vb(i,k) + vtidep(i,k)
  30     continue
       else
         do 40 k = 1, km
         do 40 i = 1, imt
            ub(i,k) = ub(i,k) + utide(i,k)
            vb(i,k) = vb(i,k) + vtide(i,k)
  40     continue
      end if
c
      return
      end
