      subroutine drifters
c
c=======================================================================
c                                                                    ===
c  This routine routine computes simulated Lagrangian trajectories   ===
c  that  start  at the  locations  specified in the file  variable   ===
c  DPOSNAM.                                                          ===
c                                                                    ===
c  Input format for file in DPOSNAM:                                 ===
c                                                                    ===
c     1st record:   NFLOATS, number of drifters to simulate          ===
c                            (free formatted integer)                ===
c     2nd record:   ITYPE, IDENT  drifter type (i4) and              ===
c                                 drifter identifier (a40)           ===
c                                                                    ===
c                   ITYPE = 1 surface drifter                        ===
c                   ITYPE = 2 density drifter (Swallow floats)       ===
c                                                                    ===
c     3rd record:   LAT, LON, Z, T  (free formatted)                 ===
c                                                                    ===
c                   LAT: drifter latitude at time T                  ===
c                   LON: drifter longitude at time T                 ===
c                     Z: drifter depth at time T (meters)            ===
c                     T: release time after model initialization     ===
c                        (days)                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <tracks.h>
#include <pconst.h>
#include <moddat.h>
#include <iounits.h>
c
c-----------------------------------------------------------------------
c  Define local data
c-----------------------------------------------------------------------
c
      integer i,ihour,itype,jday,np
      integer trackbound
#ifdef cyclic
     *        ,ncyc
#endif
      FLOAT
     *      aux,lat,lon,t,x,y,z
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      if(nfloats.gt.-1) then
c
c=======================================================================
c  On First call, read in release data for drifters and initialize
c  Lagrangian trajectories.
c=======================================================================
c
        if(nfloats.eq.0) then
          open(trkinp,file=dposnam,form='formatted',status='old',err=20)
          write(stdout,900) dposnam
c
c-----------------------------------------------------------------------
c  Initialize information needed to compute velocity.
c-----------------------------------------------------------------------
c
          call trackinit
c
c-----------------------------------------------------------------------
c  Read in track release information.
c-----------------------------------------------------------------------
c
          read(trkinp,*) nfloats
          if(nfloats.gt.maxfloats) then
            write(stdout,901) nfloats,maxfloats
            call exitus('DRIFTERS')
          endif
          do 10 np=1,nfloats
            read(trkinp,902,err=30) itype,ident(np)
            read(ident(np),903) jday
            read(ident(np),904) ihour
            tstart(1,np)=FLoaT(jday)+FLoaT(ihour/100)/c24+
     *                 FLoaT(mod(ihour,100))/c3600
            if(itype.eq.1) then
              type(np)='z'
            elseif(itype.eq.2) then
              type(np)='s'
            elseif(itype.eq.3) then
              type(np)='x'
            else
              write(stdout,905)
              call exitus('DRIFTERS')
            endif
            write(stdout,906) itype,type(np),ident(np)
            read(trkinp,*,err=30) lat,lon,z,t,aux
c
c-----------------------------------------------------------------------
c  Convert (LON,LAT) to grid coordinates (X,Y).  Initialize drifter
c  velocities.
c-----------------------------------------------------------------------
c
            call ll2xy (lon,lat,coord,imt,jmt,gridx,gridy,rlngd,rlatd,
     *                  delx,dely,thetad,x,y)
#ifdef cyclic
            ncyc=int(x-c1)/imtm2
            if(x.lt.c1) ncyc=ncyc-1
            x=x-FLoaT(ncyc*imtm2)
#endif
            track(1,np)=x
            track(2,np)=y
            track(3,np)=z
            track(4,np)=t
            track(5,np)=c0
            track(6,np)=c0
            track(7,np)=c0
            tstart(2,np)=t
            if (type(np).eq.'s') then
              call fsigma(track(1,np))
            elseif (type(np).eq.'x') then
              track(8,np)=aux*m2cm
            else
              track(8,np)=c0
            endif
c
c-----------------------------------------------------------------------
c  Check for bounds.
c-----------------------------------------------------------------------
c
            status(np)=trackbound(track(1,np))
            if(status(np).eq.1) status(np)=0
            write(stdout,907) (track(i,np),i=1,8),status(np)
  10      continue
          close(trkinp)
          write(stdout,908)
c
c-----------------------------------------------------------------------
c  Create and initialize output NetCDF file.
c-----------------------------------------------------------------------
c
          call tracksout(stdout)
          goto 50
c
c-----------------------------------------------------------------------
c  This setup prevents calls to TRACKREFRESH, TRACKSTEP and TRACKOUT.
c-----------------------------------------------------------------------
c
  20      continue
          write(stdout,909) dposnam
          goto 40
  30      continue
          write(stdout,910) np
  40      continue
          write(stdout,911)
          nfloats=-1
  50      continue
c
c=======================================================================
c  End of introductory section.
c=======================================================================
c
        else
c
c-----------------------------------------------------------------------
c  Update velocity fields.
c-----------------------------------------------------------------------
c
          call trackrefresh
c
c-----------------------------------------------------------------------
c  Update trajectories.
c-----------------------------------------------------------------------
c
          call trackstep
c
c-----------------------------------------------------------------------
c  Write out tracjectories.
c-----------------------------------------------------------------------
c
          call tracksout(stdout)
        endif
      endif
c
 900  format(/' DRIFTERS - file: ',a,' was opened.'/)
 901  format(/' DRIFTERS - number of floats is bigger than allocated; ',
     *        ' NFLOATS, MAXFLOATS = ',2i5)
 902  format(i4,a40)
 903  format(18x,i6)
 904  format(24x,i5)
 905  format(/' DRIFTERS - Inaproppriated drifter type.')
 906  format(i4,3x,a1,a40)
 907  format(2f12.4,6f9.2,i5)
 908  format(/' DRIFTERS - particle tracing will be done.'/)
 909  format(/' DRIFTERS - file: ',a,' was not opened.')
 910  format(/' DRIFTERS - error while reading data for drifter: ',i4)
 911  format(/' DRIFTERS - particle tracing will not be done.'/)
      return
      end
