      subroutine exitus (module)
c
c=======================================================================
c                                                                    ===
c  This routine is used to terminate execution during abnormal       ===
c  computations.   All output units  are properly  flushed and       ===
c  closed.                                                           ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     MODULE   routine issuing termination (character)               ===
c                                                                    ===
c  Calls:         OCLOSE                                             ===
c  NetCDF Calls:  NCABOR,  NCCLOS                                    ===
c  PVM Calls:     PVMFEXIT                                           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#if defined nest2larger | defined nest2smaller
# include <fpvm3.h>
#endif
#include <fullwd.h>
#include <iounits.h>
#include <pe_netcdf.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      logical       opnd
      character*(*) module
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Close virtual disc datasets.
c-----------------------------------------------------------------------
c
      call oclose(kontrl)
      call oclose(kflds)
      call oclose(labs(1))
      call oclose(labs(2))
      call oclose(labs(3))
c
#ifdef sunflush
c-----------------------------------------------------------------------
c  Flush output buffers.
c-----------------------------------------------------------------------
c
      call flush(stdout)
c
#endif
c-----------------------------------------------------------------------
c  Close NetCDF files.
c-----------------------------------------------------------------------
c
c  Close PE output NetCDF file.
c
      if (ncoutst.eq.1) then
         call ncabor(ncoutid,rcode)
        else if (ncoutst.eq.2) then
         call ncclos(ncoutid,rcode)
      end if
c
c  Close energy/diagnostics output NetCDF file.
c
      if (ncnrgst.eq.1) then
         call ncabor(ncnrgid,rcode)
        else if (ncnrgst.eq.2) then
         call ncclos(ncnrgid,rcode)
      end if
#ifdef ldrifters
c
c  Close output Lagrangian trajectories NetCDF file.
c
      if (nctrkst.eq.1) then
         call ncabor(nctrkid,rcode)
        else if (nctrkst.eq.2) then
         call ncclos(nctrkid,rcode)
      end if
#endif
#ifdef pressbias
c
c  Close input/output pressure gradient bias NetCDF file.
c
      if (ncpbst.eq.1) then
         call ncabor(ncpbid,rcode)
        else if (ncpbst.eq.2) then
         call ncclos(ncpbid,rcode)
      end if
#endif
#ifdef ext_tide
c
c  Close input tidal NetCDF data file.
c
      if (nctdst.eq.2) then
         call ncclos(nctdid,rcode)
      end if
#endif
c
c-----------------------------------------------------------------------
c  Close opened ASCII I/O files.
c-----------------------------------------------------------------------
c
c  Lagrangian drifter files.
c
      inquire (unit=trkinp, opened=opnd)
      if (opnd) close (trkinp)
c
c  Assimilation files.
c
      inquire (unit=ioiout, opened=opnd)
      if (opnd) close (ioiout)
c
      inquire (unit=ioipar, opened=opnd)
      if (opnd) close (ioipar)
c
c  Biological files.
c
      inquire (unit=bioinp, opened=opnd)
      if (opnd) close (bioinp)
c
#ifdef bioDuse
      inquire (unit=absinp, opened=opnd)
      if (opnd) close (absinp)
c
#endif
c  Tracer point source files.
c
      inquire (unit=tsrcinp, opened=opnd)
      if (opnd) close (tsrcinp)
c
c  Profile extraction files.
c
      inquire (unit=inpprf, opened=opnd)
      if (opnd) close (inpprf)
c
      inquire (unit=outprf, opened=opnd)
      if (opnd) close (outprf)
c
c  User files.
c
      inquire (unit=usrinp, opened=opnd)
      if (opnd) close (usrinp)
c
c  Extraction (1-way nesting) files.
c
      inquire (unit=xtrinp, opened=opnd)
      if (opnd) close (xtrinp)
c
c  Tidal files.
c
      inquire (unit=tdbxin, opened=opnd)
      if (opnd) close (tdbxin)
c
#ifdef ext_tide
      inquire (unit=tdphin, opened=opnd)
      if (opnd) close (tdphin)
c
#endif
c-----------------------------------------------------------------------
c  Indicate which routine issued abnormal termination.
c-----------------------------------------------------------------------
c
      if(module(1:10).eq.'OCEAN DONE') then
        write(stdout,10) module
  10    format(a)
      else
        write(stdout,20) module
  20    format(/,' Execution abnormally terminated in module: ',a,/)
      endif
c
#if defined nest2larger | defined nest2smaller
c-----------------------------------------------------------------------
c  Exit from PVM virtual machine.
c-----------------------------------------------------------------------
c
c  Leave PVM virtual machine
c
      call pvmfexit (rcode)
c
# if defined nest2larger
c  Close redirected I/O units.
c
      close (stdinp)
      close (stdout)
c
# endif
#endif
      stop
      end
