      subroutine extrap (nval,dep,val,xtrp)
c
c=======================================================================
c                                                                    ===
c  This subroutine provides extrapolated values for those values so  ===
c  indicated.                                                        ===
c                                                                    ===
c  Arguments:                                                        ===
c                                                                    ===
c  NVAL   the number of values to consider (input; integer).         ===
c  DEP    the depth at which values are sought (input; real).        ===
c  VAL    on input both the accepted values and those with           ===
c         questionable extrapolation.  On output both the accepted   ===
c         values and the corrected extrapolations (input/output;     ===
c         real array).                                               ===
c  XTRP   flags to indicate whether each value is accepted or        ===
c         a questionable extrapolation (input; logical array).       ===
c         XTRP(i) = .true.   =>  an extrapolated value.              ===
c         XTRP(i) = .false.  =>  an accepted value.                  ===
c                                                                    ===
#ifndef hpg4
c  Calls:  EXTRAP2                                                   ===
# else
c  Calls:  none                                                      ===
#endif
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <pconst.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer nval
#ifdef hpg4
     *        ,n,no_acc
#endif
      logical xtrp(nval)
      FLOAT
     *      dep
#ifdef hpg4
     *      ,avg_val
#endif
      FLOAT
     *      val(nval)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
#ifndef hpg4
c-----------------------------------------------------------------------
c  Interpolate values depending on the number of acceptible values.
c-----------------------------------------------------------------------
c
      call extrap2 (val,xtrp)
c
# else
c-----------------------------------------------------------------------
c  Simply set the extrapolated values to the average of the accepted
c  values.
c-----------------------------------------------------------------------
c
      no_acc=0
      avg_val=c0
      do 10 n=1,nval
        if(.not. xtrp(n)) then
          no_acc=no_acc+1
          avg_val=avg_val+val(n)
        endif
  10  continue
c
      if(no_acc.gt.0) avg_val=avg_val/FLoaT(no_acc)
      do 20 n=1,nval
        if(xtrp(n)) val(n)=avg_val
  20  continue
#endif
      return
      end
