      subroutine file_chk (fname,desc,iotype,ok)
c
c=======================================================================
c                                                                    ===
c  This routine checks to see if the supplied filename is valid.     ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     FNAME    File name to test.                          (string)  ===
c     DESC     Descriptor for file.                        (string)  ===
c     IOTYPE   Type of file, case insensitive.             (string)  ===
c              "Input"            Input file.                        ===
c              "Output"           Output file.                       ===
c              "OutputNoClobber"  Output file which cannot           ===
c                                 already exist.                     ===
c     OK       Current status of test flag.                (logical) ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /IOUNITS/                                                         ===
c                                                                    ===
c     STDOUT   standard output logical unit.                (integer)===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     OK       Updated status of test flag.                (logical) ===
c                                                                    ===
c  Calls:  ALL_UC,  LENGTH                                           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <iounits.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer fxln,sbgn,sbgn0,send,send0,slen,slen0
      logical       found,not_ok,ok
      character*128 fmt,wkstr
      character*(*) desc,fname,iotype
c
      parameter (fxln=31)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Test to see if filename is valid.
c-----------------------------------------------------------------------
c
      call length (fname,slen0,sbgn0,send0)
c
      if (slen0.le.0) then
         call length (desc,slen,sbgn,send)
         write (stdout,900) desc(sbgn:send)
         ok = .false.
         return
      end if
c
c-----------------------------------------------------------------------
c  Test to see if input file exists.
c-----------------------------------------------------------------------
c
c  Determine file type
c
      call all_uc (iotype,wkstr)
      call length (wkstr,slen,sbgn,send)
c
c  Test input files for existance.
c
      if (wkstr(sbgn:send).eq.'INPUT') then
         inquire (file=fname(sbgn0:send0), exist=found)
         if (.not.found) then
            call length (desc,slen,sbgn,send)
            write (stdout,910) desc(sbgn:send),fname(sbgn0:send0)
            ok = .false.
            return
         end if
c
       elseif (wkstr(sbgn:send).eq.'OUTPUTNOCLOBBER') then
         inquire (file=fname(sbgn0:send0), exist=not_ok)
         if (not_ok) then
            call length (desc,slen,sbgn,send)
            write (stdout,920) desc(sbgn:send),fname(sbgn0:send0)
            ok = .false.
            return
         end if
      end if
c
c-----------------------------------------------------------------------
c  Report on valid file.
c-----------------------------------------------------------------------
c
      call length (desc,slen,sbgn,send)
      write (fmt,930) max(0, (fxln-slen)) + 2
      write (stdout,fmt) desc(sbgn:send),fname(sbgn0:send0)
c
      return
c
 900  format (/1x,'***Error:  FILE_CHK - invalid file name for ',1h",a,
     &        1h")
 910  format (/1x,'***Error:  FILE_CHK - unable to find ',a/11x,1h",a,
     &        1h")
 920  format (/1x,'***Error:  FILE_CHK - unable to overwrite ',a/11x,
     &        1h",a,1h")
 930  format ('(',i2,'x,a,',1h',': ',1h',',a)')
c
      end
