      subroutine flip(fout,iout,jout,finp,iinp,jinp)
c
c=======================================================================
c                                                                    ===
c  This routine flip a generic array from column to row majority.    ===
c                                                                    ===
c  On input:                                                         ===
c                                                                    ===
c     FINP    2D array out column majority (col,row).                ===
c     IINP    first dimension of FINP.                               ===
c     JINP    second dimension of FINP.                              ===
c     IOUT    first dimension of FOUT.                               ===
c     JOUT    first dimension of FOUT.                               ===
c                                                                    ===
c  On input:                                                         ===
c                                                                    ===
c     FOUT    2D array ordered by row majority (row,col).            ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
      integer i,iinp,iout,j,jinp,jout
      FLOAT
     *      finp(iinp,jinp),fout(iout,jout)
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      do 10 j=1,jinp
      do 10 i=1,iinp
        fout(j,i)=finp(i,j)
  10  continue
      return
      end
