      subroutine get_ewpt (clon,clat,rotang,elon,elat,wlon,wlat)
c
c=======================================================================
c                                                                    ===
c  This routine computes two points to determine a spherical         ===
c  rotation.  In rotated system, the points would lie on the         ===
c  "Equator" at "longitudes" 45E and 45W.                            ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     CLAT, CLON   The center of the grid.  (radians; real)          ===
c     ROTANG       The angle the new "Equator" make with geographic  ===
c                  east at the center of the grid.  (radians; real)  ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     ELAT, ELON   The geographic coordinates of the "east point".   ===
c                  New latitude=0, New longitude=45.  (radians; real)===
c     WLAT, WLON   The geographic coordinates of the "west point".   ===
c                  New latitude=0, New longitude=-45. (radians; real)===
c                                                                    ===
c     Calls:  LON_CHK                                                ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <pconst.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      FLOAT
     *      a,c2pi,clat,clon,colat,elat,elon,hpi,mhpi,mpi,num,rotang,
     *      rrt2,wlat,wlon
      FLOAT
     *      lon_chk
      parameter (c2pi=c2*pi,hpi=p5*pi,mhpi=cm1*hpi,mpi=cm1*pi,
     *           rrt2=c1/root2)
c
c-----------------------------------------------------------------------
c  Longitude range check function.
c-----------------------------------------------------------------------
c
      lon_chk(a)=sign(c1,a)*
     *           (mod(abs(a),c2pi)-c2pi*int(mod(abs(a),c2pi)/pi))
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c  Find "eastern" point.
c-----------------------------------------------------------------------
c
      colat=acos(rrt2*(sin(clat)+cos(clat)*sin(rotang)))
      elat=hpi-colat
c
      if((colat.ne.c0).and.(colat.ne.pi)) then
        num=rrt2*(cos(clat)-sin(clat)*sin(rotang))
        if(abs(rotang).le.hpi) then
          elon=clon+acos(num/sin(colat))
        else
          elon=clon-acos(num/sin(colat))
        endif
      else
        elon=clon
      endif
c
c-----------------------------------------------------------------------
c  Find "western" point.
c-----------------------------------------------------------------------
c
      colat=acos(rrt2*(sin(clat)-cos(clat)*sin(rotang)))
      wlat=hpi-colat
c
      if((colat.ne.c0).and.(colat.ne.pi)) then
        num=rrt2*(cos(clat)+sin(clat)*sin(rotang))
        if(abs(rotang).le.hpi) then
          wlon=clon-acos(num/sin(colat))
        else
          wlon=clon+acos(num/sin(colat))
        endif
      else
        wlon=clon
      endif
c
c-----------------------------------------------------------------------
c  Make sure latitudes are in the range [-PI/2, PI/2].
c    Step 1:  ensure that latitudes are in the range [-PI, PI].
c    Step 2:  further correct to [-PI/2, PI/2] (this involves the
c             longitudes).
c  Make sure longitudes are in the range [-PI, PI].
c-----------------------------------------------------------------------
c
      elat=lon_chk(elat)
      wlat=lon_chk(wlat)
c
      if(elat.gt.hpi) then
        elat=pi-elat
        elon=elon+pi
      elseif(elat.lt.mhpi) then
        elat=mpi-elat
        elon=elon+pi
      endif
c
      if(wlat.gt.hpi) then
        wlat=pi-wlat
        wlon=wlon+pi
      elseif(wlat.lt.mhpi) then
        wlat=mpi-wlat
        wlon=wlon+pi
      end if
c
      elon=lon_chk(elon)
      wlon=lon_chk(wlon)
      return
      end
