#ifdef gridold
      subroutine get_thick (depth,dzqz,dzzqz,kzz)
#else
      subroutine get_thick (j,keytv,dzqz,dzzqz,kzz)
#endif
c
c=======================================================================
c                                                                    ===
c  This routine computes the basic level thicknesses from the        ===
c  supplied depths at the middle of the boxes.                       ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
#ifdef gridold
c     DEPTH   Depths at the middle of the boxes.   (real array; cm)  ===
#else
c     J       Slab index for depths.               (integer)         ===
c     KEYTV   Flag to select T or V grid.          (integer)         ===
#endif
c     KZZ     Number of levels in DZZQZ.           (integer)         ===
c                                                                    ===
#ifndef gridold
c  Common Blocks:                                                    ===
c                                                                    ===
c  /VERTICAL/                                                        ===
c                                                                    ===
c     DZT   Thicknesses of T vertical boxes.        (real array; cm) ===
c     DZV   Thicknesses of UV vertical boxes.       (real array; cm) ===
c                                                                    ===
#endif
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     DZQZ    The thickness of a vertical box.      (real array; cm) ===
c     DZZQZ   the vertical spacing between levels.  (real array; cm) ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#ifndef gridold
# include <vertical.h>
#endif
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,kzz
#ifndef gridold
     *        ,j,keytv
#endif
#if !defined gridold | !defined barotropic
      integer k
#endif
#ifndef barotropic
      integer km1
#endif
      FLOAT
     *      dzqz(imt,km),dzzqz(imt,kzz)
#ifdef gridold
     *      ,depth(imt,km)
#endif
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
#ifdef gridold
c-----------------------------------------------------------------------
c  Compute spacing in top level separately.
c-----------------------------------------------------------------------
c
      do 10 i=1,imt
        dzzqz(i,1)=depth(i,1)
        dzqz(i,1)=c2*dzzqz(i,1)
  10  continue
c
c-----------------------------------------------------------------------
c  Compute spacing in remaining levels.
c-----------------------------------------------------------------------
c
# ifndef barotropic
      do 30 k=2,km
        km1=k-1
        do 20 i=1,imt
          dzzqz(i,k)=depth(i,k)-depth(i,km1)
          dzqz(i,k)=c2*dzzqz(i,k)-dzqz(i,km1)
  20    continue
  30  continue
# endif
c
c-----------------------------------------------------------------------
c  Tracer grid has an extra level of DZZ thicknesses.
c-----------------------------------------------------------------------
c
      do 40 i=1,imt
        dzzqz(i,kmp1)=p5*dzqz(i,km)
  40  continue
c
#else
c-----------------------------------------------------------------------
c  Extract box thicknesses.
c-----------------------------------------------------------------------
c
      if (keytv.eq.tgrid) then
         do 10  i = 1, imt
         do 10  k = 1, km
            dzqz(i,k) = dzt(i,j,k)
  10     continue
       else
         do 20 i = 1, imt
         do 20 k = 1, km
            dzqz(i,k) = dzv(i,j,k)
  20     continue
      endif
c
c-----------------------------------------------------------------------
c  Compute spacing between levels.
c-----------------------------------------------------------------------
c
      do 30 i = 1, imt
        dzzqz(i,1)    = p5*dzqz(i,1)
        dzzqz(i,kmp1) = p5*dzqz(i,km)
  30  continue
c
# ifndef barotropic
      do 50 k = 2, km
         km1 = k-1
         do 40 i = 1, imt
            dzzqz(i,k) = p5*(dzqz(i,k)+dzqz(i,km1))
  40     continue
  50  continue
# endif
#endif
      return
      end
