      subroutine hopsrecv (module,tid,msgid,bufid)
c
c=======================================================================
c                                                                    ===
c  This routine is a front-end for the timed PVM receive routine.    ===
c  This routine calls the PVM timed receive routine.  If no message  ===
c  is received, this routine enters a loop of checking the status of ===
c  the sending process and then calling the PVM timed receive.  This ===
c  continues until either the message is received or the sending     ===
c  process is determined to have failed.                             ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     MODULE  Name of calling routine.          (string)             ===
c     TID     Sending task identifier.          (integer)            ===
c     MSGID   Message identifier.               (integer)            ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     BUFID   Buffer identifier/ exit status.   (integer)            ===
c                                                                    ===
c  Calls:      NEST_ERRCHK                                           ===
c  PVM Calls:  PVMFPSTAT,   PVMFTRECV                                ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <fpvm3.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer bufid,msgid,sec,status,tid,usec
      character*(*) module
c
      parameter (sec=300, usec=0)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Repeatedly check message buffer until message received, sending task
c  fails or an error occurs.
c-----------------------------------------------------------------------
c
  10  continue
         call pvmftrecv (tid,msgid,sec,usec,bufid)
         if (bufid.eq.0) then
            call pvmfpstat (tid,status)
            call nest_errchk (module,'StatusCheck',status,1,1,1)
          elseif (bufid.lt.0) then
            call nest_errchk (module,'Receive',bufid,1,1,1)
         end if
      if (bufid.eq.0) goto 10
c
      return
      end
