      subroutine host_check (hostname,hlen,hbgn,hend,hostok)
c
c=======================================================================
c                                                                    ===
c  This routine checks to see if the supplied host name is valid.    ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     HOSTNAME   Name of purported host.                 (string)    ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     HLEN       Length of active portion of hostname.   (integer)   ===
c     HBGN       Starting index of hostname.             (integer)   ===
c     HEND       Ending index of hostname.               (integer)   ===
c     HOSTOK     Flag indicating validity of hostname.   (logical)   ===
c                                                                    ===
c      Calls:  LENGTH,     NEST_ERRCHK                               ===
c  PVM Calls:  PVMFCONFIG                                            ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer dtid,hbgn,hend,hlen,narch,nchk,nhost,sbgn,send,slen,speed,
     &        status
      logical       hostok
      character*128 archtyp,hostnm
      character*(*) hostname
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Make sure proposed host name is not empty.
c-----------------------------------------------------------------------
c
      call length (hostname,hlen,hbgn,hend)
c
      hostok = hlen .gt. 0
c
      if (.not.hostok) return
c
c-----------------------------------------------------------------------
c  For non-empty strings, make sure requested host is in machine.
c-----------------------------------------------------------------------
c
c  Determine number of hosts in machine & name of first one.
c
      call pvmfconfig (nhost,narch,dtid,hostnm,archtyp,speed,status)
      call nest_errchk ('HOST_CHECK','Configuration',status,1,1,1)
c
c  Compare actual host to requested host.
c
      call length (hostnm,slen,sbgn,send)
      if (slen.gt.0) then
         hostok = hostname(hbgn:hend) .eq. hostnm(sbgn:send)
       else
         hostok = .false.
      end if
c
c  Repeat with remaining hosts until a match is found or list is empty.
c
      nchk = 1
c
      do 10 while ((.not.hostok).and.(nchk.lt.nhost))
         call pvmfconfig (nhost,narch,dtid,hostnm,archtyp,speed,status)
         call nest_errchk ('HOST_CHECK','Configuration',status,1,1,1)
         call length (hostnm,slen,sbgn,send)
         if (slen.gt.0)
     &      hostok =hostok.or.(hostname(hbgn:hend).eq.hostnm(sbgn:send))
         nchk = nchk + 1
  10  continue
c
      return
      end
