      subroutine ind_bdy(ind_b)
c
c=======================================================================
c                                                                    ===
c  This routine finds the indexes (i and ib) of the points in        ===
c  boundary arrays (po) that correspond to:	        	     ===
c                                                                    ===
c    the first pt before the beginning of the segment: ind_b(1,.,.)  ===
c    the point at the beginning of the segment:        ind_b(2,.,.)  ===
c    the point at the end of the segment:              ind_b(3,.,.)  ===
c                                                                    ===
c     IB: west=1, south=2, east=3, north=4                           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <fullwd.h>
#include <bndata.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i1,j1,i2,j2,l
      integer ind_b(4,2,mcseg)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c  Loop over all segments to find end points at domain boundaries.
c
#ifdef islands
      do 10 l=1,ncseg-nisle
#else
      do 10 l=1,ncseg
#endif
        i1=icoast(1,l)
        j1=jcoast(1,l)
        if (j1.eq.1) then
           if ((i1.gt.1).and.(i1.lt.imt)) then
             ind_b(1,1,l) = i1-1
             ind_b(1,2,l) = south
             ind_b(2,1,l) = i1
             ind_b(2,2,l) = south
           endif 
        else if (j1.eq.jmt) then  
           if ((i1.gt.1).and.(i1.lt.imt)) then
             ind_b(1,1,l) = i1+1
             ind_b(1,2,l) = north
             ind_b(2,1,l) = i1
             ind_b(2,2,l) = north
           end if
        else if (i1.eq.1) then
           if ((j1.gt.1).and.(j1.lt.jmt)) then
             ind_b(1,1,l) = j1+1
             ind_b(1,2,l) = west
             ind_b(2,1,l) = j1
             ind_b(2,2,l) = west
           end if
        else if (i1.eq.imt) then
           if ((j1.gt.1).and.(j1.lt.jmt)) then
             ind_b(1,1,l) = j1-1
             ind_b(1,2,l) = east
             ind_b(2,1,l) = j1
             ind_b(2,2,l) = east
           end if
        else 
          call exitus('IND_BDY1')
        endif
        i2=icoast(lencoast(l),l)
        j2=jcoast(lencoast(l),l)
        if (j2.eq.2) then
           if ((i2.gt.1).and.(i2.lt.imt)) then
             ind_b(3,1,l) = i2
             ind_b(3,2,l) = south
             ind_b(4,1,l) = i2+1
             ind_b(4,2,l) = south
           endif
        else if (j2.eq.jmtm1) then
           if ((i2.gt.1).and.(i2.lt.imt)) then
             ind_b(3,1,l) = i2
             ind_b(3,2,l) = north
             ind_b(4,1,l) = i2-1
             ind_b(4,2,l) = north
           end if
        else if (i2.eq.2) then
           if ((j2.gt.1).and.(j2.lt.jmt)) then
             ind_b(3,1,l) = j2
             ind_b(3,2,l) = west
             ind_b(4,1,l) = j2-1
             ind_b(4,2,l) = west
           end if
        else if (i2.eq.imtm1) then
           if ((j2.gt.1).and.(j2.lt.jmt)) then
             ind_b(3,1,l) = j2
             ind_b(3,2,l) = east
             ind_b(4,1,l) = j2+1
             ind_b(4,2,l) = east
           end if
        else
          call exitus('IND_BDY2') 
        endif
 10   continue
c
      return
      end
