      subroutine init_srch (khi,klow,imt,km,istar)
c
c=======================================================================
c                                                                    ===
c  This routine initializes the high/low search indices.             ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     IMT     number of grid points in the x-direction (integer)     ===
c     KM      number of grid points in the z-direction (integer)     ===
c     ISTAR   number of grid points in the finite difference "star"  ===
c             (integer)                                              ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     KHI     high search indices (integer array)                    ===
c     KLOW    low search indices (integer array)                     ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,imt,istar,k,km
      integer khi(imt,istar),klow(imt,istar)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      do 10 k=1,istar
      do 10 i=1,imt
        klow(i,k)=1
        khi(i,k)=min(2,km)
  10  continue
      return
      end
