      subroutine inittdpth (maxbox,nbox,ist,ind,jst,jnd,zmax)
c
c=======================================================================
c                                                                    ===
c  This routine reads the data defining the tidally active zones.    ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     MAXBOX   Maximum number of tidally active zones.   (integer)   ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /IOUNITS/                                                         ===
c                                                                    ===
c     TDBXIN    Unit number for tidal regions file.     (integer)    ===
c     TIDEBOX   Name for file defining tidal regions.   (string)     ===
c     STDOUT    standard output logical unit.           (integer)    ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     NBOX     Number of tidally active zones.     (integer)         ===
c     IST      Starting i-index of active zones.   (integer vector)  ===
c     IND      Ending i-index of active zones.     (integer vector)  ===
c     JST      Starting j-index of active zones.   (integer vector)  ===
c     JND      Ending j-index of active zones.     (integer vector)  ===
c     ZMAX     Maximum active bottom depth.        (real vector; cm) ===
c                                                                    ===
c  Calls:  ERRIO,  EXITUS,  LENGTH,  NO_DIGIT                        ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <pconst.h>
#include <iounits.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer ios,maxbox,n,nbox,sbgn,send,slen
      integer ist(maxbox),ind(maxbox),jst(maxbox),jnd(maxbox)
      integer no_digit
      logical first
      FLOAT
     &              zmax(maxbox)
      character*128 fmt
c
      data first /.true./
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Open data file on first pass.
c-----------------------------------------------------------------------
c
      if (first) then
         call length (tidebox,slen,sbgn,send)
         open (tdbxin, file=tidebox(sbgn:send), status='old',iostat=ios)
         if (ios.ne.0) then
            write (stdout,900) tidebox(sbgn:send)
            call exitus ('INITTDPTH')
         end if
         first = .false.
      end if
c
c-----------------------------------------------------------------------
c  Read data.
c-----------------------------------------------------------------------
c
c  Read number of tidally active zones.
c
      read (tdbxin,*,iostat=ios) nbox
      call errio (stdout,'INITTDPTH',
     &                   ' reading number of tidally active zones ',ios)
c
      if (nbox.gt.maxbox) then
         write (fmt,910) no_digit(nbox),no_digit(maxbox)
         write (stdout,fmt) nbox,maxbox
         call exitus ('INITTDPTH')
      end if
c
c  Read tidal zone data.
c
      read (tdbxin,*,iostat=ios) (ist(n),ind(n),jst(n),jnd(n),zmax(n),
     &                             n = 1, nbox)
      call errio (stdout,'INITTDPTH','reading tidal zone data',ios)
c
c-----------------------------------------------------------------------
c  Close input file.
c-----------------------------------------------------------------------
c
      close (tdbxin)
c
c-----------------------------------------------------------------------
c  Convert depths to centimeters.
c-----------------------------------------------------------------------
c
      do 10 n = 1, nbox
         zmax(n) = zmax(n)*m2cm
  10  continue
c
      return
c
 900  format (/'***Error:  INITTDPTH - unable to open tidal zone input',
     &        ' file:'/11x,1h",a,1h")
 910  format('(/',1h','***Error:  INITTDPTH - insufficient storage.',1h'
     &        ,'/11x,',1h','Number tidally active zones:  ',3h',i,i2,
     &        '/11x,',1h','Allotted storage (TDBOXMX):   ',3h',i,i2,
     &        '/11x,',1h','edit param.h and recompile.',2h'))
c
      end
