      subroutine inparm
c
c=======================================================================
c                                                                   ====
c  This routine reads in input run parameters from standard input,  ====
c  STDINP.  It also writes out run information to standard output,  ====
c  STDOUT.                                                          ====
c                                                                   ====
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <fullwd.h>
#include <scalar.h>
#include <bndata.h>
#include <moddat.h>
#include <filtdat.h>
#include <options.h>
#include <iounits.h>
#include <hybrid.h>
#include <rhomean.h>
#include <runid.h>
#include <cvmix.h>
#include <cppmix.h>
#include <bndyrlx.h>
#if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
# include <cbiopnh.h>
#endif
#ifdef advtide0
# include <tidesp.h>
#endif
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,icard,ios
#ifdef nest2smaller
     &        ,lenstr,sbgn,send
#endif
      logical ok
#if (defined forcing | defined peprf | defined ext_tide ) & defined resetjulian
      integer iday,month,iyear,iyday
      character*8  tchar
      character*11 dchar
#endif
      character*55 text
c
      data ok /.true./
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Read in and report out input parameters
c-----------------------------------------------------------------------
c
      write(stdout,900)
      read(stdinp,*,iostat=ios) icard
c
      do 10 while ((icard.gt.0).and.(icard.lt.99).and.(ios.eq.0))
c
        if (icard.eq.1) then
          read(stdinp,*,iostat=ios) nfirst,nlast,d0start,nnergy,ntsout,
     *                              ntsi,nmix,ncon,ntdgn
#ifdef AsselinFilt
          _nu=Float(nmix)/c1000
          nmix=nlast+1
#endif
          if (ios.eq.0) write(stdout,910) nfirst,nlast,nnergy,ntsout,
#ifdef AsselinFilt
     *                                    ntsi,nmix,_nu,ncon,ntdgn
#else
     *                                    ntsi,nmix,ncon,ntdgn
#endif
c
         elseif (icard.eq.2) then
          read(stdinp,*,iostat=ios) dtts,dtuv,dtsf
          if (ios.eq.0) write(stdout,920) dtts,dtuv,dtsf
c
         elseif (icard.eq.3) then
          read(stdinp,*,iostat=ios) mixvel,mixtrc,mixztd
          if (ios.eq.0) write(stdout,930) mixvel,mixtrc,mixztd
c
         elseif (icard.eq.4) then
          read(stdinp,*,iostat=ios) nordv,ntimv,nfrqv,nordt,ntimt,nfrqt,
     *                              nordz,ntimz,nfrqz,nordp,ntimp,nfrqp
#ifdef shapiro
          if (ios.eq.0) write(stdout,940) nordv,ntimv,nfrqv,nordt,ntimt,
     *                                    nfrqt,nordz,ntimz,nfrqz,nordp,
     *                                    ntimp,nfrqp
#endif
c
         elseif (icard.eq.5) then
          read(stdinp,*,iostat=ios) am,ah
          if (ios.eq.0) write(stdout,950) am,ah
c
         elseif (icard.eq.6) then
          read(stdinp,*,iostat=ios) aidif,fkpm,vvclim,wvmix,fricmx,fkph,
     *                              vdclim,wdmix
#ifdef ppvmix
          if (ios.eq.0) write(stdout,960) aidif,fkpm,vvclim,wvmix,fricmx
     *                                    ,fkph,vdclim,wdmix
#else
          if (ios.eq.0) write(stdout,960) aidif,fkpm,vvclim,wvmix,fkph,
     *                                    vdclim,wdmix
#endif
c
         elseif (icard.eq.7) then
          read(stdinp,*,iostat=ios) mldopt,mldval,mldmin,mldmax,ekfac,
     *                              mcoef,ncoef,wsdfac
          if (ios.eq.0) then
            write(stdout,970) mldopt,mldval,mldmin,mldmax,ekfac,
#ifndef nkfix
     *                              mcoef,ncoef,wsdfac
# else
     *                              mcoef,ncoef
#endif
            if((mldopt.lt.0).or.(mldopt.gt.2)) then
              write(stdout,980) 'MLDOPT'
              call exitus('INPARM')
            endif
          endif
c
         elseif (icard.eq.8) then
          read(stdinp,*,iostat=ios) mxscan,sor,crit,acor
          if (ios.eq.0) then
            write(stdout,990) mxscan,sor,crit,acor
            crit=abs(crit)
            if((crit.lt.c0).or.(crit.gt.c1)) then
              write(stdout,980) 'CRIT'
              call exitus('INPARM')
            endif
          endif
c
         elseif (icard.eq.9) then
          read(stdinp,*,iostat=ios) cdbot
          if (ios.eq.0) write(stdout,1000) cdbot
c
         elseif (icard.eq.10) then
#if defined ext_tide & defined advtide & defined advtide0
          read(stdinp,*,iostat=ios) cdtid,mtddpth,tdmxfrc,tdmxfac,sadv
#else
          read(stdinp,*,iostat=ios) cdtid,mtddpth,tdmxfrc,tdmxfac
#endif
#if defined ext_tide & defined mixtide
          if (ios.eq.0) write(stdout,1003) cdtid,mtddpth,tdmxfrc
          mtddpth=mtddpth*m2cm
# elif defined posmxtid
          if (ios.eq.0) write(stdout,1008) tdmxfac
#endif
#if defined ext_tide & defined advtide & defined advtide0
          if (ios.eq.0) write(stdout,1009) sadv
#endif
c
         elseif (icard.eq.11) then
          read(stdinp,*,iostat=ios) dvbrlx,tvbrlx,dtbrlx,ttbrlx,dcsfrc,
     &                              tcsfrc,dbtfrc,tbtfrc
#ifdef bndy_rlx
          if (ios.eq.0) write(stdout,1010) dvbrlx,tvbrlx,dtbrlx,ttbrlx
#endif
#ifdef cstfrc
          if (ios.eq.0) write(stdout,1020) dcsfrc,tcsfrc
#endif
#ifdef botfrc
          if (ios.eq.0) write(stdout,1030) dbtfrc,tbtfrc
#endif
c
         elseif (icard.eq.12) then
          read(stdinp,*,iostat=ios) (iopt(i),i=1,10)
#ifdef nest2larger
          iopt(8) = min(iopt(8),nt)
#endif
#ifdef nest2smaller
          iopt(9) = min(iopt(9),nt)
#endif
c
         elseif (icard.eq.13) then
          read(stdinp,*,iostat=ios) (iout(i),i=1,11)
c
         elseif (icard.eq.14) then
          read(stdinp,*,iostat=ios) (iout(i),i=12,21)
c
         elseif (icard.eq.15) then
          read(stdinp,*,iostat=ios) nlev,(lev(i),i=1,nlev)
c
         elseif (icard.eq.16) then
          read(stdinp,'(20a4)',iostat=ios) (titlrun(i),i=1,20)
c
         elseif (icard.eq.17) then
          read(stdinp,'(a)',iostat=ios) outname
c
         elseif (icard.eq.18) then
          read(stdinp,'(a)',iostat=ios) nrgname
c
         elseif (icard.eq.19) then
          read(stdinp,'(a)',iostat=ios) trkname
c
         elseif (icard.eq.20) then
          read(stdinp,'(a)',iostat=ios) inpname
c
         elseif (icard.eq.21) then
          read(stdinp,'(a)',iostat=ios) frcname
c
         elseif (icard.eq.22) then
          read(stdinp,'(a)',iostat=ios) assname
c
         elseif (icard.eq.23) then
          read(stdinp,'(a)',iostat=ios) aparnam
c
         elseif (icard.eq.24) then
          read(stdinp,'(a)',iostat=ios) dposnam
c
         elseif (icard.eq.25) then
          read(stdinp,'(a)',iostat=ios) xparnam
c
         elseif (icard.eq.26) then
          read(stdinp,'(a)',iostat=ios) smltnm
c
         elseif (icard.eq.27) then
          read(stdinp,'(a)',iostat=ios) smlhnm
c
         elseif (icard.eq.28) then
          read(stdinp,'(a)',iostat=ios) smlinm
c
         elseif (icard.eq.29) then
          read(stdinp,'(a)',iostat=ios) smlonm
c
         elseif (icard.eq.30) then
          read(stdinp,'(a)',iostat=ios) pbisnam
c
         elseif (icard.eq.31) then
          read(stdinp,'(a)',iostat=ios) bparnam
c
         elseif (icard.eq.32) then
          read(stdinp,'(a)',iostat=ios) tsrcnam
c
         elseif (icard.eq.33) then
          read(stdinp,'(a)',iostat=ios) grdname
c
         elseif (icard.eq.34) then
          read(stdinp,'(a)',iostat=ios) usrname
c
         elseif (icard.eq.35) then
          read(stdinp,'(a)',iostat=ios) sampin
c
         elseif (icard.eq.36) then
          read(stdinp,'(a)',iostat=ios) sampout
c
         elseif (icard.eq.37) then
          read(stdinp,'(a)',iostat=ios) tidedat
c
         elseif (icard.eq.38) then
          read(stdinp,'(a)',iostat=ios) tdphdat
c
         elseif (icard.eq.39) then
          read(stdinp,'(a)',iostat=ios) tidebox
        endif
c
        if (ios.eq.0) read(stdinp,*,iostat=ios) icard
c
  10  continue
c
      if (ios.ne.0) then
        write(stdout,20) icard
  20    format(/' INPARM - read error at or near input card: ',i4)
        call exitus('INPARM')
      endif
c
c  Write out other input parameters to STDOUT file.
c
      write(stdout,1040) rho0,smean
#ifdef leqstate
      write(stdout,1050) rbar,sbar,scoef,tbar,tcoef
#endif
      write(stdout,'(20a4)') (titlrun(i),i=1,20)
c
c-----------------------------------------------------------------------
c  Report output/input files and check availability of input files.
c-----------------------------------------------------------------------
c
      write(stdout,80)
  80  format(//' Output/Input Files:'/)
      call file_chk (outname,'Output PE Fields File',
     &               'OutputNoClobber',ok)
      call file_chk (nrgname,'Energy and Diagnostics File',
     &               'OutputNoClobber',ok)
#if defined shapmean & defined pressbias & !defined pressinbias
      call file_chk (pbisnam,'Pressure bias and Mean TS File',
     &               'Input',ok)
#elif defined shapmean & defined pressbias & defined pressinbias 
      call file_chk (pbisnam,'Pressure bias and Mean TS File',
     &               'OutputNoClobber',ok)
#elif defined pressbias & !defined pressinbias
      call file_chk (pbisnam,'Pressure bias File',
     &               'Input',ok)
#elif defined pressbias & defined pressinbias
      call file_chk (pbisnam,'Pressure bias File',
     &               'OutputNoClobber',ok)
#endif
#ifdef ldrifters
      call file_chk (trkname,'Langrangian Trajectories File',
     &               'Output',ok)
#endif
#ifndef analytical
      call file_chk (inpname,'Initial/Boundary File',
     &               'Input',ok)
# ifdef grids
      call file_chk (grdname,'GRIDS NetCDF File',
     &               'Input',ok)
# endif
#endif
#ifdef forcing
      call file_chk (frcname,'Forcing File',
     &               'Input',ok)
#endif
#ifdef oias
      call file_chk (assname,'Assimilation Fields File',
     &               'Input',ok)
      call file_chk (aparnam,'Assimilation Parameters File',
     &               'Input',ok)
#endif
#ifdef ldrifters
      call file_chk (dposnam,'Initial Drifters Positions File',
     &               'Input',ok)
#endif
#ifdef extraction
      call file_chk (xparnam,'Extraction Parameters File',
     &               'Input',ok)
#endif
#if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
      call file_chk (bparnam,'Biological Parameters File',
     &               'Input',ok)
#endif
#ifdef pttrcsrc
      call file_chk (tsrcnam,'Tracers Point Source File',
     &               'Input',ok)
#endif
#ifdef peprf
      call file_chk (sampin,'Sampling Parameter Input File',
     &               'Input',ok)
      call file_chk (sampout,'Sampling Profile Output File',
     &               'OutputNoClobber',ok)
#endif
#ifdef ext_tide
      call file_chk (tidedat,'Tidal Fields Input File',
     &               'Input',ok)
      call file_chk (tdphdat,'Tidal Phase Input File',
     &               'Input',ok)
#endif
#if defined posmxtid & (!defined mixtide | !defined ext_tide)
      call file_chk (tidebox,'Tidal Region Input File',
     &               'Input',ok)
#endif
#ifdef nest2smaller
      call length (smltnm,lenstr,sbgn,send)
      write(stdout,90) '  Executable for smaller domain: ',
     *                  smltnm(sbgn:send)
  90  format(2x,a,a)
      call length (smlhnm,lenstr,sbgn,send)
      if (lenstr.gt.0)
     *   write(stdout,90) '   Host on which to run smaller: ',
     *                  smlhnm(sbgn:send)
      call file_chk (smlinm,'Input File for Smaller Domain',
     &               'Input',ok)
      call file_chk (smlonm,'Output File for Smaller Domain',
     &               'Output',ok)
#endif
      if (.not.ok) call exitus ('INPARM')
c
#if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
c-----------------------------------------------------------------------
c  Read in input parameters for biological Model.
c-----------------------------------------------------------------------
c
      call bioparm
c
#endif
c-----------------------------------------------------------------------
c  Report activated C-preprocessing options.
c-----------------------------------------------------------------------
c
      write(stdout,200)
 200  format(/' Activated CPP Options: ')
      write (stdout,210) '(default)','output fields in NetCDF format'
 210  format(t6,a:,t22,a)
#ifdef analytical
      write (stdout,210) 'analytical',
     &                   'Analytical initial and boundary fields'
# ifdef grids
      write (stdout,210) 'grids',
     &                   'Domain configuration from GRIDS NetCDF file'
# endif
#endif
#ifdef bioMcGillic
      write (stdout,210) 'bioMcGillic',
     &                   'McGillicuddy et al. (1995) biological model'
#endif
#ifdef bioAnder
      write (stdout,210) 'bioAnder',
     &             'Anderson expansion of McGillicuddy biological model'
#endif
#ifdef bioDuse
      write (stdout,210) 'bioDuse',
     &             'Dusenberry biological model'
# ifdef dusDroop
      write (stdout,210) 'dusDroop',
     &             'Droop nutrient limitation equations'
# endif
#endif
#ifdef bioFasham
      write (stdout,210) 'bioFasham',
     &                   'Fasham et al. (1990) biological model'
#endif
#if defined codunlim
      write (stdout,210) 'codunlim',
     &                   'Cod; unlimited behavioral response'
# elif defined codlim
      write (stdout,210) 'codlim',
     &                   'Cod; limited behavioral response'
#endif
#if (defined codunlim | defined codlim) & defined codvadvect
      write (stdout,210) 'codvadvect',
     &                   'Allow cod to be vertically advected'
#endif
#if (defined codunlim | defined codlim) & defined codvmix
      write (stdout,210) 'codvmix',
     &                   'Allow cod to be vertically mixed'
#endif
#if (defined codunlim | defined codlim) & defined cod_ing
      write (stdout,210) 'cod_ing',
     &                   'Revised cod model'
# ifdef zoo_ing
      write (stdout,210) 'zoo_ing',
     &                   'Revised cod model w/ zooplankton response'
# endif
# ifdef cod_square
      write (stdout,210) 'cod_square',
     &                   'speed-response is the square functional'
# endif
# if defined AsselinFilt & defined AsselinFilt_cod
      write (stdout,210) 'AsselinFilt_cod',
     &                   'only apply Asselin filter to cod'
# endif
#endif
#if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
# ifdef bio_12_A
      write (stdout,210) 'bio_12_A',
     &                   'Additional productivity terms'
# endif
#endif
#ifdef coast
      write (stdout,210) 'coast','Coastal boundary conditions'
#endif
#if defined islands & defined coast
      write (stdout,210) 'islands','Island BCs in transport eq.'
#endif
#if defined coastedge & defined coast
      write (stdout,210) 'coastedge',
     &           'Next to mask, average unmasked values (control noise)'
#endif
#ifdef cyclic
      write (stdout,210) 'cyclic',
     &                   'Cyclic (west/east) boundary conditions'
#endif
#ifdef dblsigma
      write (stdout,210) 'dblsigma',
     &                   'Double sigma transformation in the vertical'
#endif
#ifdef gridold
      write (stdout,210) 'gridold',
     &                   'Use old algorithm to set vertical coordinates'
#endif
#ifdef dblprec
      write (stdout,210) 'dblprec',
     &           'Double precision floating-point operations and output'
#endif
#ifdef extraction
      write (stdout,210) 'extraction',
     &                         'extraction of initial and boundary data'
#endif
#ifdef forcing
      write (stdout,210) 'forcing','space/time variable forcing.'
#endif
#if (defined forcing | defined peprf | defined ext_tide ) & defined resetjulian
      write (stdout,210) 'resetjulian',
     &                 'Start surface forcing clock from supplied value'
#endif
#ifdef ldrifters
      write (stdout,210) 'ldrifters','Lagrangian drifters'
#endif
#ifdef cubspl
      write (stdout,210) 'cubspl',
     &                   'Vertical spline interpolation in GRAD(P)'
#else
      write (stdout,210) '(default)',
     &                   'Vertical linear interpolation in GRAD(P)'
#endif
#ifdef hpg4
      write (stdout,210) 'hpg4',
     &                   'fourth order GRAD(P)'
#else
      write (stdout,210) '(default)',
     &                   'second order GRAD(P)'
#endif
#ifdef noxtrp
      write (stdout,210) 'noxtrp',
     &                   'no extrapolation in GRAD(P)'
#else
      write (stdout,210) '(default)',
     &                   'extrapolation in GRAD(P)'
#endif
#ifdef vbart
      write (stdout,210) 'vbart',
     &                   'vertical Simpson integration in GRAD(P)'
#else
      write (stdout,210) '(default)',
     &                   'vertical trapezoidal integration in GRAD(P)'
#endif
#ifdef rmdenbar
      write (stdout,210) 'rmdenbar',
     &                   'mean density removed when computing GRAD(P)'
#endif
#if defined pressbias & !defined pressinbias
      write (stdout,210) 'pressbias','Remove bias in GRAD(P)'
#elif defined pressbias & defined pressinbias
      write (stdout,210) 'pressbias',
     &                   'Prepare for: Remove bias in GRAD(P)'
      write (stdout,210) 'pressinbias','Create GRAD(P) bias datafile'
#endif
#ifdef nest2larger
      write (stdout,210) 'nest2larger',
     &                   'Two-way nesting to larger grid via PVM'
# if defined nest_ext2lrgr
      write (stdout,210) 'nest_ext2lrgr',
     &               'Replace transport streamfunction coarse estimate'
# endif
#endif
#ifdef nest2smaller
      write (stdout,210) 'nest2smaller',
     &                   'Two-way nesting to smaller grid via PVM'
# if defined nest_ext2smlr
      write (stdout,210) 'nest_ext2smlr',
     &                   'Send transport streamfunction to smaller grid'
# endif
#endif
#if defined nest2larger | defined nest2smaller
# if defined nestnultest
      write (stdout,210) 'nestnultest',
     &                   'Create nested code without active nesting'
# endif
#endif
#ifdef sor5pt
      write (stdout,210) 'sor5pt','Successive Over-relaxation solution'
#else
      write (stdout,210) '(default)','Conjugate Gradient solution'
#endif
#ifdef vel_conv
      write (stdout,210) 'vel_conv',
     &                 'Require baro. vel. convergence in solution PBAR'
#endif
#if defined notadvm & !defined linear_physics
      write (stdout,210) 'notadvm','no advection of momentum'
#endif
#if defined notadvt & !defined linear_physics
      write (stdout,210) 'notadvt','no advection of tracers'
#endif
#ifdef linear_physics
      write (stdout,210) 'linear_physics',
     &         'Linear physics: no adv mom, only vert. adv mean tracers'
#endif
#ifdef oias
      write (stdout,210) 'oias','intermittent OI assimilation'
# ifdef fcsterr
      write (stdout,210) 'fcsterr',
     &                   'Estimate & write out the forecast errors'
#  ifdef simpramp
      write (stdout,210) 'simpramp',
     &                   'Use simpler ramping scheme'
#  endif
# elif defined wgterr
      write (stdout,210) 'wgterr',
     &                   'Simple weighted observation error'
# endif
#endif
#if defined leqstate
      write (stdout,210) 'leqstate','linear equation of state'
#elif defined unesco
      write (stdout,210) 'unesco',
     &                   'UNESCO (1980) nonlinear equation of state'
#else
      write (stdout,210) '(default)',
     &                   'simplified nonlinear equation of state'
#endif
#ifdef pttrcsrc
      write (stdout,210) 'pttrcsrc',
     &                   'specification of point tracer sources'
# ifdef rivsrc
      write (stdout,210) 'rivsrc',
     &                   'Specification of river tracer souces'
# endif
#endif
#ifdef barotropic
      write (stdout,210) 'barotropic',
     &                   'barotropic (one level) model configuration'
#endif
#ifdef frozentrc
      write (stdout,210) 'frozentrc','initially frozen tracer fields'
#endif
#if defined bioMcGillic | defined bioFasham | defined bioAnder | defined bioDuse
# ifdef bioadjloc
      write (stdout,210) 'bioadjloc',
     &                   'Local biological adjustment'
# endif
# ifdef bioadjvert
      write (stdout,210) 'bioadjvert','vertical biological adjustment'
# endif
#endif
#ifdef shapiro
      write (stdout,210) 'shapiro',
     &                   'Shapiro filtering software activated'
# ifdef secondmean
      write (stdout,210) 'secondmean',
     &            'enforce zero mean internal vel. after Shapiro filter'
# endif
# if defined shapmean & defined pressbias
      write (stdout,210) 'shapmean',
     &               'Remove mean tracer field before shapiro filtering'
# endif
# ifdef pindex
      write (stdout,210) 'pindex',
     &                   'Revised streamfunction filter indices'
# endif
# if defined pindex & defined shapnocoastflux
      write (stdout,210) 'shapnocoastflux',
     &                   'Revised filter BCs'
# endif
#else
# ifdef cubspl
      write (stdout,210) 'cubspl',
     &                   'spline interpolation in Laplacian friction'
# else
      write (stdout,210) '(default)',
     &                   'linear interpolation in Laplacian friction'
# endif
#endif
#ifdef AsselinFilt
      write (stdout,210) 'AsselinFilt',
     &                   'Asselin filter'
#endif
#ifdef explicitvmix
      write (stdout,210) 'explicitvmix',
     &                   'explicit treatment of vertical mixing'
#else
      write (stdout,210) '(default)',
     &                   'implicit treatment of vertical mixing'
#endif
#ifdef peprf
      write (stdout,210) 'peprf','Extract hydrographic PE profiles'
#endif
#ifdef ppvmix
      write (stdout,210) 'ppvmix',
     &                 'Pacanowski and Philander vertical mixing scheme'
#endif
#ifdef bottom
      write (stdout,210) 'bottom',
     &                  'Second-order in time bottom stress calculation'
#endif
#ifdef bndy_rlx
      write (stdout,210) 'bndy_rlx','boundary relaxation'
#  ifdef imp_bnd_rlx
      write (stdout,210) 'imp_bnd_rlx',
     &                   'use implicit scheme for boundary relaxation'
#  endif
#endif
#ifdef cstfrc
      write (stdout,210) 'cstfrc','coastal friction'
#endif
#ifdef botfrc
      write (stdout,210) 'botfrc','bottom friction'
#endif
#ifdef sunflush
      write (stdout,210) 'sunflush',
     &                   'regularly flush output buffers in SUN systems'
#endif
#ifdef sunfpe
      write (stdout,210) 'sunfpe','SUN floating point exception trap'
#endif
#if defined sundate
      write (stdout,210) 'sundate','SUN time (FDATE) managing routine'
#elif defined decdate
      write (stdout,210) 'decdate',
     &                   'DEC time (IDATE,TIME) managing routines'
#elif defined craydate
      write (stdout,210) 'craydate',
     &                   'CRAY time (DATE,CLOCK) managing routines'
#elif defined aixdate
      write (stdout,210) 'aixdate',
     &            'AIX (IBM RS6000) time (DATE,CLOCK) managing routines'
#else
      write (stdout,210) '(default)','no time managing routines'
#endif
#ifdef close_tracers
      write (stdout,210) 'close_tracers',
     &                   'Impose closed BCs on tracer N & S boundaries'
#endif
#ifdef nocfl
      write (stdout,210) 'nocfl','inhibit CFL checking'
#else
# ifdef nowcfl
      write (stdout,210) 'nowcfl','Disable CFL checking in vertical'
# endif
#endif
#ifdef usrdiagnostic
      write (stdout,210) 'usrdiagnostic',
     &                   'Report user defined diagnostics'
# ifdef nesttime 
      write (stdout,210) 'nesttime',
     &                   'Report some timing data.  (SUN)'
# endif
#endif
#ifdef nkfix
      write (stdout,210) 'nkfix','Revised Niiler-Kraus protections'
#endif
#ifdef ext_tide
      write (stdout,210) 'ext_tide',
     &                   'Use external tide'
# ifdef advtide 
      write (stdout,210) 'advtide',
     &                  'Add external tidal effects to tracer advection'
#  ifdef gridold
      write (stdout,210) '+++Warning:  advtide should be not used '//
     &                   'with gridold'
#  endif
#  ifdef advtide0
      write (stdout,210) 'advtide0',
     &                   'Decrease strength of tidal advection'
#  endif
# endif
# ifdef mixtide 
      write (stdout,210) 'mixtide',
     &                   'Add external tidal effects to vertical mixing'
# endif
# ifdef tide_zero 
      write (stdout,210) 'tide_zero',
     &                   'Include residual tidal stress in momentum'
#  ifdef tide_zero_clip
      write (stdout,210) 'tide_zero_clip',
     &                   'Limit magnitude of residual tidal stress'
#  endif
#  ifdef show_tide_zero
      write (stdout,210) 'show_tide_zero','Create ASCII',
     &                   ' dump file for residual tidal stress'
#  endif
# endif
# ifdef add_tide 
      write (stdout,210) 'add_tide',
     &                  'Add tidal velocity to total velocity on output'
# endif
#endif
#if defined posmxtid & (!defined mixtide | !defined ext_tide)
      write (stdout,210) 'posmxtid',
     &                   'Enhanced vertical mixing in pre-defined'//
     &                   ' tidal regions'
#endif
c
c  Set flag FLAG(1) that specifies the density equation used.
c      [0] linear, [1] UNESCO, [2] simplified nonlinear
c
#if defined leqstate
        iflag(1)=0
#elif defined unesco
        iflag(1)=1
#else
        iflag(1)=2
#endif
c
c  Set restart flags
c
      if(nfirst.gt.0)then
        write(stdout,220)
 220    format(/' INPARM: model initialized from INFLD file.')
      else
        nfirst=0
        write(stdout,230)
 230    format(/' INPARM: model initialized from re-start file.')
      endif
      if(nlast.lt.0) then
        na=1
        nlast=-nlast
        write(stdout,240) nlast
 240    format(' INPARM: writing re-start file at timestep = ',i6)
      endif
c
c-----------------------------------------------------------------------
c  Write out other PE model options.
c-----------------------------------------------------------------------
c
      write(stdout,250)
 250  format(/' Other PE model options:'/)
      if(iopt(1).eq.0) then
        text='Closed.'
      elseif(iopt(1).eq.1) then
        text='Provided values.'
      elseif(iopt(1).eq.2) then
        text='Spall and Robinson.'
      elseif(iopt(1).eq.3) then
        text='Orlanski radiation (implicit).'
      elseif(iopt(1).eq.4) then
        text='Modified Orlanski radiation (implicit).'
      elseif(iopt(1).eq.5) then
        text='Extrapolated.'
      endif
      write(stdout,260) iopt(1),text
 260  format(4x,i6,'  IOPT(1) boundary condition on tracers:'/22x,a)
      if(iopt(2).eq.0) then
        text='Closed.'
      elseif(iopt(2).eq.1) then
        text='Provided values.'
      elseif(iopt(2).eq.2) then
        text='Spall and Robinson (CFvN like).'
      elseif(iopt(2).eq.3) then
        text='Orlanski radiation (implicit).'
      elseif(iopt(2).eq.4) then
        text='Modified Orlanski radiation (implicit).'
      elseif(iopt(2).eq.5) then
        text='Extrapolated.'
      endif
      write(stdout,270) iopt(2),text
 270  format(4x,i6,'  IOPT(2) boundary condition on velocity:'/22x,a)
      if(iopt(3).eq.0) then
        text='Closed.'
      elseif(iopt(3).eq.1) then
        text='Provided values.'
      elseif(iopt(3).eq.2) then
        text='Spall and Robinson (provided values).'
      elseif(iopt(3).eq.3) then
        text='Orlanski radiation (implicit).'
      elseif(iopt(3).eq.4) then
        text='Modified Orlanski radiation (implicit).'
      endif
      write(stdout,280) iopt(3),text
 280  format(4x,i6,'  IOPT(3) boundary condition on transport:'/22x,a)
      if(iopt(4).eq.1) then
        text='Provided values.'
      elseif(iopt(4).eq.2) then
        text='Spall and Robinson (CFvN like).'
      elseif(iopt(4).eq.3) then
        text='Orlansky Radiation (implicit).'
      elseif(iopt(4).eq.5) then
        text='Extrapolated.'
      elseif(iopt(4).eq.6) then
        text='Reduced physics.'
      endif
      write(stdout,290) iopt(4),text
 290  format(4x,i6,'  IOPT(4) boundary condition on vorticity:'/22x,a)
      if(iopt(5).eq.1) then
        text='Verbose output.'
      else
        text='Terse output.'
      endif
      write(stdout,300) iopt(5),text
 300  format(4x,i6,'  IOPT(5) ',1h",'diagnostic',1h",' printing:'/22x,a)
      if(iopt(7).eq.0) then
        text='Full curvature.'
      elseif(iopt(7).eq.1) then
        text='f-plane.'
      elseif(iopt(7).eq.2) then
        text='beta-plane.'
      endif
      write(stdout,310) iopt(7),text
 310  format(4x,i6,'  IOPT(7) Coriolis Term representation:'/22x,a)
#ifdef nest2larger
      write(stdout,313) iopt(8)
 313  format (4x,i6,'  IOPT(8) Number of tracers exchanged w/ larger ',
     &        'domain')
#endif
#ifdef nest2smaller
      write(stdout,317) iopt(9)
 317  format (4x,i6,'  IOPT(9) Number of tracers exchanged w/ smaller ',
     &        'domain')
#endif
#if (defined forcing | defined peprf | defined ext_tide ) & defined resetjulian
      call caldate (d0start,dchar,tchar,iday,month,iyear,iyday)
      text = 'Reset to:  '//dchar//', '//tchar
      write(stdout,320) d0start,text
 320  format(f10.2,'  D0START Initial Julian date:'/22x,a)
#endif
c
 900  format(/' PE model input parameters:'/)
 910  format(
     *   4x,i6,'  NFIRST  start/restart flag'/
     *   4x,i6,'  NLAST   number of timesteps'/
     *   4x,i6,'  NNERGY  number of timesteps between energy ',
     *                   'diagnostics'/
     *   4x,i6,'  NTSOUT  number of timesteps between output of data'/
     *   4x,i6,'  NTSI    number of timesteps between print of single ',
     *                   'line of'/20x,'information'/
     *   4x,i6,'  NMIX    number of timesteps between mixing timestep'/
#ifdef AsselinFilt
     * 4x,f6.3,'  _NU     Asselin filter coefficient 0<=_nu<1.00 '/
#endif
     *   4x,i6,'  NCON    number of passes through convection loop'/
     *   4x,i6,'  NTDGN   number of timesteps for diagnostic ',
     *                   'initialization, if any.')
 920  format(
     *   f10.2,'  DTTS    length of timestep on tracers (s)'/
     *   f10.2,'  DTUV    length of timestep on internal mode velocity',
     *                   ' (s)'/
     *   f10.2,'  DTSF    length of timestep on streamfunction (s)')
 930  format(
     *   4x,i6,'  MIXVEL  velocity: horizontal mixing scheme'/
     *     10x,'          [1] Shapiro filter'/
     *     10x,'          [2] Laplacian at constant depths'/
     *     10x,'          [3] Laplacian along terrain following levels'/
     *   4x,i6,'  MIXTRC  tracers: horizontal mixing scheme'/
     *     10x,'          [1] Shapiro filter'/
     *     10x,'          [2] Laplacian at constant depths'/
     *     10x,'          [3] Laplacian along terrain following levels'/
     *   4x,i6,'  MIXZTD  vorticity:  horizontal mixing scheme'/
     *     10x,'          [1] Shapiro filter'/
     *     10x,'          [2] Laplacian')
#ifdef shapiro
 940  format(
     *  4x,3i2,'  NORDV   Shapiro filter parameters, velocity'/
     *  4x,3i2,'  NORDT   Shapiro filter parameters, tracers'/
     *  4x,3i2,'  NORDZ   Shapiro filter parameters, vorticity'/
     *  4x,3i2,'  NORDP   Shapiro filter parameters, streamfunction')
#endif
 950  format(
     * 1pe10.3,'  AM      horizontal viscosity coefficient (cm^2/s)'/
     * 1pe10.3,'  AH      horizontal diffusion coefficient (cm^2/s)')
 960  format(
     *   f10.4,'  AIDIF   flag for implicit/explicit treatment of ',
     *                   'vertical diffusion'/
     * 1pe10.3,'  FKPM    background vertical viscosity coefficient',
     *                   ' (cm^2/s)'/
     * 1pe10.3,'  VVCLIM  unstable vertical viscosity coefficient',
     *                   ' (cm^2/s)'/
     * 1pe10.3,'  WVMIX   wind-mixing vertical viscosity coefficient',
     *                   ' (cm^2/s)'/
#ifdef ppvmix
     * 1pe10.3,'  FRICMX  maximum stable vertical viscosity',
     *                   '  coefficient (cm^2/s)'/
#endif
     * 1pe10.3,'  FKPH    background vertical diffusion coefficient',
     *                   ' (cm^2/s)'/
     * 1pe10.3,'  VDCLIM  unstable vertical diffusion coefficient',
     *                   ' (cm^2/s)'/
     * 1pe10.3,'  WDMIX   wind-mixing vertical diffusion coefficient',
     *                   ' (cm^2/s)')
 970  format(
     *   9x,i1,'  MLDOPT  mixed-layer scheme option'/
     * 1pe10.3,'  MLDVAL  prescribed mixed-layer depth (cm)'/
     * 1pe10.3,'  MLDMIN  mixed-layer depth estimate lower limit',
     *                    ' (cm)'/
     * 1pe10.3,'  MLDMAX  mixed-layer depth estimate upper limit',
     *                    ' (cm)'/
     * 1pe10.3,'  EKFAC   factor in the Ekman depth equation'/
     * 1pe10.3,'  MCOEF   wind stress coefficient in Niiler-Kraus'/
#ifndef nkfix
     * 1pe10.3,'  NCOEF   buoyancy coefficient in Niiler-Kraus'/
     * 1pe10.3,'  WSDFAC  wind stress denominator-term factor')
# else
     * 1pe10.3,'  NCOEF   buoyancy coefficient in Niiler-Kraus')
#endif
 980  format(/' INPARM: illegal input parameter value for ',a/)
 990  format(
     *   4x,i6,'  MXSCAN  maximum number of iterations for relaxation ',
     *                   'solution'/
     *   f10.2,'  SOR     coefficient for over-relaxation'/
     * 1pe10.3,'  CRIT    percentage convergence criterion for ',
     *                   'relaxation solution'/0p,
     *   f10.4,'  ACOR    Coriolis term factor')
1000  format(
     * 1pe10.3,'  CDBOT   bottom drag coefficient')
#if defined ext_tide & defined mixtide
1003  format(
     * 1pe10.3,'  CDTID   tidal friction coefficient   (s)'/
     * 1pe10.3,'  MTDDPTH maximum tidal mixing depth   (m)'/
     * 1pe10.3,'  TDMXFRC tidal mixing limit           (cm^2/s)')
# elif defined posmxtid
1008  format(
     * 1pe10.3,'  TDMXFAC constant tidal mixing coefficient   (cm^2/s)')
#endif
#if defined ext_tide & defined advtide & defined advtide0
1009  format(
     * 1pe10.3,'  SADV    scaling factor on tidal advection')
#endif
#ifdef bndy_rlx
1010  format(
     * 1pe10.3,'  DVBRLX  V-boundary relaxation spatial scale'/
     * 1pe10.3,'  TVBRLX  V-boundary relaxation temporal scale'/
     * 1pe10.3,'  DTBRLX  T-boundary relaxation spatial scale'/
     * 1pe10.3,'  TTBRLX  T-boundary relaxation temporal scale')
#endif
#ifdef cstfrc
1020  format(
     * 1pe10.3,'  DCSFRC  Coastal friction spatial scale'/
     * 1pe10.3,'  TCSFRC  Coastal friction temporal scale')
#endif
#ifdef botfrc
1030  format(
     * 1pe10.3,'  DBTFRC  Bottom friction spatial scale'/
     * 1pe10.3,'  TBTFRC  Bottom friction temporal scale')
#endif
1040  format(
     *  f10.4,'  RHO0    constant mean density (kg/m^3)'/
     *  f10.4,'  SMEAN   salinity scale subtracted during computations')
#ifdef leqstate
1050  format(
     *  f10.4,'  RBAR    mean density in linear equation of state'/
     *  f10.4,'  SBAR    mean salinity in linear equation of state'/
     *1pe10.3,'  SCOEF   saline contraction coefficient'/0p,
     *  f10.4,'  TBAR    mean temperature in linear equation of state'/
     *1pe10.3,'  TCOEF   thermal expansion coefficient')
#endif
c
      return
      end
