      subroutine int_gradrho (dpx,hpx,dpy,hpy,dzzvqz,kwt)
c
c========================================================================
c                                                                     ===
c  This subroutine integrates the horizontal density gradient to get  ===
c  the horizontal pressure gradient.                                  ===
c                                                                     ===
c                                                                     ===
c  On Input:                                                          ===
c                                                                     ===
c     DPX       x-derivative of the density (real array)              ===
c     DPY       y-derivative of the density (real array)              ===
c     DZZVQZ    spacing between vertical levels (real array)          ===
c     HPX       horizontal gradient of density half way between the   ===
c               vertical levels of DPX (real array)                   ===
c     HPY       horizontal gradient of density half way between the   ===
c               vertical levels of DPY (real array)                   ===
c     KWT       index for the integration weights (integer array)     ===
c                                                                     ===
c  On Output:                                                         ===
c                                                                     ===
c     DPX       x-derivative of the pressure (real array)             ===
c     DPY       y-derivative of the pressure (real array)             ===
c                                                                     ===
c  Common Blocks:      (only relevant variables documented)           ===
c                                                                     ===
c     /SCALAR/                                                        ===
c                                                                     ===
c     GRAV      gravitational acceleration (real; cm/(s^2))           ===
c                                                                     ===
c     Calls:  none                                                    ===
c                                                                     ===
c========================================================================
c
c------------------------------------------------------------------------
c  Define global data.
c------------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <scalar.h>
c
c------------------------------------------------------------------------
c  Define local data.
c------------------------------------------------------------------------
c
      integer i,imt2,k,khere,kwt(imt,km)
#ifndef barotropic
      integer kup
#endif
      FLOAT
     *      dpx(imt,km),dpy(imt,km),dzzvqz(imt,km),wt(0:1,0:1),
     *      hpx(imt,km),hpy(imt,km),oldx(imt,0:1),oldy(imt,0:1)
c
      parameter (imt2=2*imt)
c
      save wt
c
      data oldx,oldy /imt2*c0,imt2*c0/
#ifndef vbart
      data wt /p5,c0,p5,c0/
#else
      data wt /r6,c2r3,p25,p5/
#endif
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Vertically integrate horizontal density gradients to get
c  horizontal pressure gradients.
c-----------------------------------------------------------------------
c
      khere=0
      do 10 i=1,imtm1
        oldx(i,khere)=dpx(i,1)
        oldy(i,khere)=dpy(i,1)
        dpx(i,1)=dpx(i,1)*dzzvqz(i,1)
        dpy(i,1)=dpy(i,1)*dzzvqz(i,1)
  10  continue
#ifndef barotropic
      do 20 k=2,km
        kup=khere
        khere=1-kup
      do 20 i=1,imtm1
        oldx(i,khere)=dpx(i,k)
        oldy(i,khere)=dpy(i,k)
        dpx(i,k)=((oldx(i,khere)+oldx(i,kup))*wt(0,kwt(i,k))+
     *            hpx(i,k-1)*wt(1,kwt(i,k)))*dzzvqz(i,k)
        dpy(i,k)=((oldy(i,khere)+oldy(i,kup))*wt(0,kwt(i,k))+
     *            hpy(i,k-1)*wt(1,kwt(i,k)))*dzzvqz(i,k)
  20  continue
c
      do 30 k=2,km
      do 30 i=1,imtm1
        dpx(i,k)=dpx(i,k)+dpx(i,k-1)
        dpy(i,k)=dpy(i,k)+dpy(i,k-1)
  30  continue
#endif
c
c-----------------------------------------------------------------------
c  Apply gravity scale.
c-----------------------------------------------------------------------
c
      do 40 k=1,km
      do 40 i=1,imtm1
        dpx(i,k)=dpx(i,k)*grav
        dpy(i,k)=dpy(i,k)*grav
  40  continue
      return
      end
