c
c=======================================================================
c  Include file "ioi.h"
c=======================================================================
c
#ifndef rmdocinc
c  COR        correlation between observation and forecast errors.
c  ERRFLD     uniform expected forecast error for all fields.
c  ERRP       uniform observation error field for streamfunction.
c  ERRTS      uniform observation error field for tracers.
c  ERRUV      uniform observation error field for velocity.
c  IAP        switch for transport streamfunction assimilation.
c  IAREAD     switch to read in a new set of assimilation fields.
c  IATS       switch for tracers assimilation.
c  IAUV       switch for internal velocity assimilation.
c  MXOI       maximum number of assimilation cycles allowed.
c  OBSWGT     observation weigth per variable per cycle.
c  OERRMAX    maximum observation error value (per variable) found.
c  OERRMIN    minimum observation error value (per variable) found.
c  PFCTERR    expected forecast error for streamfunction.
c  POBS       observation streamfunction.
c  POBSERR    3-d observation error field for streamfunction.
c  TFCTERR    expected forecast error for tracers.
c  TOBS       observation tracers.
c  TOBSERR    3-d observation error field for tracers.
c  TOISEC     assimilation times from initial TTSEC.
c  TSAT       "saturation" time.  Decay rate for forecast reliability.  (s)
c             (for use with CPP option "fcsterr")
c  TTOI       current observation time.
c  UFCTERR    expected forecast error for u-component velocity.
c  UOBS       observation u-component velocity.
c  UOBSERR    3-d observation error field for u-component velocity.
c  VFCTERR    expected forecast error for v-component velocity.
c  VOBS       observation v-component velocity.
c  VOBSERR    3-d error field for v-component velocity.
c
c=======================================================================
c
#endif
      integer mxoi
      parameter (mxoi=500)
c
      common /ioiparm/ iats,iauv,iap,iaread
      integer iats(mxoi,nt),iauv(mxoi),iap(mxoi),iaread(mxoi)
c
      common /foiparm/ toisec,cor,tsat
      FLOAT 
     *      toisec(mxoi),cor,tsat
c
      common /obsfld/ ttoi,tobs,uobs,vobs,pobs
      FLOAT
     *      tobs(imt,km,nt),ttoi,uobs(imt,km),vobs(imt,km),pobs(imt)
c
      common /obserr/ obswgt,oerrmin,oerrmax,errts,erruv,errp,tobserr,
     *       uobserr,vobserr,pobserr
      FLOAT 
     *      obswgt(mxoi,nt+3),oerrmin(nt+3,km),oerrmax(nt+3,km),
     *      errts(mxoi,km,nt),erruv(mxoi,km),errp(mxoi),
     *      tobserr(imt,km,nt),uobserr(imt,km),vobserr(imt,km),
     *      pobserr(imt)
c
       common /fcterr/ errfld,tfcterr,ufcterr,vfcterr,pfcterr
       FLOAT 
#ifndef fcsterr
     *       errfld(mxoi,km,nt+3),tfcterr(imt,km,nt),
     *       ufcterr(imt,km),vfcterr(imt,km),pfcterr(imt)
# else
     *       errfld(mxoi,km,nt+3),tfcterr(imt,km,nt,jmt),
     *       ufcterr(imt,km,jmt),vfcterr(imt,km,jmt),pfcterr(imt,jmt)
#endif
