      subroutine landsea(ncinpid)
c
c=======================================================================
c                                                                    ===
c  This routine reads in land and sea indices, coastal segments      ===
c  and island indices from input NetCDF file.                        ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     NCINPID  NetCDF input file ID (integer)                        ===
c                                                                    ===
c  Common Blocks: (only relevant variables listed)                   ===
c                                                                    ===
c     /PARAM/                                                        ===
c                                                                    ===
c     IMT      total number of tracer grid boxes zonally (input;     ===
c              integer)                                              ===
c     JMT      total number of tracer grid boxes meridionally        ===
c              input; integer)                                       ===
c                                                                    ===
c     /FULLWD/                                                       ===
c                                                                    ===
c     LANDT    land/sea mask at the tracer points [0=land,1=sea]     ===
c              (output; integer array)                               ===
c     NCSEG    total number of coastal segments (output; integer)    ===
c     LENCOAST number of nodes in each coastal segment (output;      ===
c              integer array)                                        ===
c     ICOAST   zonal coastal nodes index (output; integer array)     ===
c     JCOAST   meridional coastal nodes index (output; integer array)===
#ifdef islands
c     NISLE    total number od islands in the model basin (output;   ===
c              integer)                                              ===
c     ISIS     starting I-index of island box (output; integer array)===
c     IEIS     ending I-index of island box (output; integer array)  ===
c     JSIS     starting J-index of island box (output; integer array)===
c     JEIS     ending J-index of island box (output; integer array)  ===
#endif
c                                                                    ===
c  Calls:  NCVGT, NCVGT1, NCVID   (NetCDF Library)                   ===
c          EXITUS                                                    ===
c                                                                    ===
c  WARNING:   Character argument to NetCDF routine NCDID is          ===
c             (upper/lower) case sensitive.                          ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <fullwd.h>
#include <iounits.h>
#include <netcdf.inc>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer csegxid,csegyid,n,ncinpid,rcode,varid
      integer count(2),start(2)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Read in Land/Sea mask from input NetCDF file.
c-----------------------------------------------------------------------
c
c  Read in land mask for the tracer points.
c
      varid=ncvid(ncinpid,'landt',rcode)
      if(rcode.eq.0) then
        start(1)=1
        count(1)=imt
        start(2)=1
        count(2)=jmt
        call ncvgt(ncinpid,varid,start,count,landt,rcode)
        if(rcode.ne.0) then
          write(stdout,900) 'landt'
          call exitus('LANDSEA')
        endif
      else
        write(stdout,901) 'landt'
        call exitus('LANDSEA')
      endif
c
c  Read in land mask for the velocity points.
c
      varid=ncvid(ncinpid,'landv',rcode)
      if(rcode.eq.0) then
        call ncvgt(ncinpid,varid,start,count,landv,rcode)
        if(rcode.ne.0) then
          write(stdout,900) 'landv'
          call exitus('LANDSEA')
        endif
      else
        write(stdout,901) 'landv'
        call exitus('LANDSEA')
      endif
c
c  Read in number of coastal segments.
c
      varid=ncvid(ncinpid,'ncseg',rcode)
      if(rcode.eq.0) then
        call ncvgt1(ncinpid,varid,1,ncseg,rcode)
        if(ncseg.gt.mcseg) then
          write(stdout,902) 'NCSEG, MCSEG = ',ncseg,mcseg
          call exitus('LANDSEA')
        endif
      else
        write(stdout,901) 'ncseg'
        call exitus('LANDSEA')
      endif
c
c  Read in length of each coastal segment.
c
      varid=ncvid(ncinpid,'lencoast',rcode)
      if(rcode.eq.0) then
        start(1)=1
        count(1)=ncseg
        call ncvgt(ncinpid,varid,start,count,lencoast,rcode)
        if(rcode.ne.0) then
          write(stdout,900) 'lencoast'
          call exitus('LANDSEA')
        endif
      else
        write(stdout,901) 'lencoast'
        call exitus('LANDSEA')
      endif
c
c  Read in coastal segments ICOAST and JCOAST.
c
      csegxid=ncvid(ncinpid,'icoast',rcode)
      if(rcode.ne.0) then
        write(stdout,901) 'icoast'
        call exitus('LANDSEA')
      endif
      csegyid=ncvid(ncinpid,'jcoast',rcode)
      if(rcode.ne.0) then
        write(stdout,901) 'jcoast'
        call exitus('LANDSEA')
      endif
c
      do 10 n=1,ncseg
        if(lencoast(n).gt.mclen) then
          write(stdout,902) 'LENCOAST, MCLEN = ',lencoast(n),mclen
          call exitus('LANDSEA')
        endif
        start(1)=1
        count(1)=lencoast(n)
        start(2)=n
        count(2)=1
        call ncvgt(ncinpid,csegxid,start,count,icoast(1,n),rcode)
        if(rcode.ne.0) then
          write(stdout,900) 'icoast'
          call exitus('LANDSEA')
        endif
        call ncvgt(ncinpid,csegyid,start,count,jcoast(1,n),rcode)
        if(rcode.ne.0) then
          write(stdout,900) 'jcoast'
          call exitus('LANDSEA')
        endif
  10  continue
#ifdef islands
c
c  Read in number of Islands.
c
      varid=ncvid(ncinpid,'nisle',rcode)
      if(rcode.eq.0) then
        call ncvgt1(ncinpid,varid,1,nisle,rcode)
        if(nisle.gt.misle) then
          write(stdout,902) 'NISLE, MISLE = ',nisle,misle
          call exitus('LANDSEA')
        endif
      else
        write(stdout,901) 'nisle'
        call exitus('LANDSEA')
      endif
c
c  Read in starting and ending index-coordinates of the Island boxes.
c
      if(nisle.gt.0) then
        start(1)=1
        count(1)=nisle
        varid=ncvid(ncinpid,'isis',rcode)
        if(rcode.eq.0) then
          call ncvgt(ncinpid,varid,start,count,isis,rcode)
          if(rcode.ne.0) then
            write(stdout,900) 'isis'
            call exitus('LANDSEA')
          endif
        else
          write(stdout,901) 'isis'
          call exitus('LANDSEA')
        endif
        varid=ncvid(ncinpid,'ieis',rcode)
        if(rcode.eq.0) then
          call ncvgt(ncinpid,varid,start,count,ieis,rcode)
          if(rcode.ne.0) then
            write(stdout,900) 'ieis'
            call exitus('LANDSEA')
          endif
        else
          write(stdout,901) 'ieis'
          call exitus('LANDSEA')
        endif
        varid=ncvid(ncinpid,'jsis',rcode)
        if(rcode.eq.0) then
          call ncvgt(ncinpid,varid,start,count,jsis,rcode)
          if(rcode.ne.0) then
            write(stdout,900) 'jsis'
            call exitus('LANDSEA')
          endif
        else
          write(stdout,901) 'jsis'
          call exitus('LANDSEA')
        endif
        varid=ncvid(ncinpid,'jeis',rcode)
        if(rcode.eq.0) then
          call ncvgt(ncinpid,varid,start,count,jeis,rcode)
          if(rcode.ne.0) then
            write(stdout,900) 'jeis'
            call exitus('LANDSEA')
          endif
        else
          write(stdout,901) 'jeis'
          call exitus('LANDSEA')
        endif
      endif
#endif
c
 900  format(/,' LANDSEA - error while reading variable: ',a)
 901  format(/,' LANDSEA - cannot find variable: ',a,2x,
     *         ' in initialization NetCDF file.')
 902  format(/,' LANDSEA - undersimensioned arrays; ',a,2i4)
      return
      end
