      subroutine length (string,slen,bgn,end)
c
c=======================================================================
c                                                                    ===
c  This subroutine determines the length of a character string minus ===
c  any leading or trailing blanks.                                   ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     STRING   String to be examined.                     (string)   ===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c     SLEN     Number of characters in string,                       ===
c              exclusive of leading & trailing blanks.    (integer)  ===
c     BGN      Position of first nonblank character.      (integer)  ===
c     END      Position of last nonblank character.       (integer)  ===
c                                                                    ===
c  Calls:  none                                                      ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer       bgn,end,ispace,itab,itst,slen,vldmn,vldmx
      character*(*) string
c
      parameter (ispace=32, itab=9, vldmn=32, vldmx=7*16+14)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Initialize beginning and ending pointers for the search.
c-----------------------------------------------------------------------
c
      end = len(string)
      bgn = 1
c
c-----------------------------------------------------------------------
c  Search for first nonblank character.
c-----------------------------------------------------------------------
c
      itst = ichar(string(bgn:bgn))
c
      do 10 while ( ((itst.eq.itab).or.(itst.eq.ispace).or.
     &               (itst.lt.vldmn).or.(itst.gt.vldmx)) .and.
     &              (bgn.lt.end) )
         bgn = bgn + 1
         itst = ichar(string(bgn:bgn))
 10   continue
c
      if ((itst.eq.itab).or.(itst.eq.ispace).or.
     &    (itst.lt.vldmn).or.(itst.gt.vldmx))
     &   bgn = bgn + 1
c
c-----------------------------------------------------------------------
c  Search for last nonblank character.
c-----------------------------------------------------------------------
c
      itst = ichar(string(end:end))
c
      do 20 while ( ((itst.eq.itab).or.(itst.eq.ispace).or.
     &               (itst.lt.vldmn).or.(itst.gt.vldmx)) .and.
     &              (end.gt.1) )
         end = end - 1
         itst = ichar(string(end:end))
 20   continue
c
      if ((itst.eq.itab).or.(itst.eq.ispace).or.
     &    (itst.lt.vldmn).or.(itst.gt.vldmx))
     &   end = end - 1
c
c-----------------------------------------------------------------------
c  Determine length exclusive of leading & trailing blanks.
c-----------------------------------------------------------------------
c
      if (end .ge. bgn) then
         slen = end - bgn + 1
        else
         slen = 0
      end if
c
      return
      end
