      subroutine lintrp (n,x,y,ni,xi,yi)
c
c=======================================================================
c                                                                    ===
c  Given arrays X and Y of length N, which tabulate a function,      ===
c  Y = F(X),  with the  X  in ascending order, and given an array    ===
c  XI of length NI, this routine returns a linear interpolated       ===
c  array YI.  For values of XI outside the range of X, constant      ===
c  extrapolation with the nearest value of Y is used.                ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,ii,j,n,ni
      FLOAT
     *      d1,d2
      FLOAT
     *      x(n),y(n),xi(ni),yi(ni)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      do 30 j=1,ni
        if(xi(j).le.x(1)) then
          yi(j)=y(1)
        elseif(xi(j).ge.x(n))then
          yi(j)=y(n)
        else
          do 10 i=1,n-1
            if((x(i).lt.xi(j)).and.(xi(j).le.x(i+1))) then
              ii=i
              goto 20
            endif
 10       continue
 20       d1=xi(j)-x(ii)
          d2=x(ii+1)-xi(j)
          yi(j)=(d1*y(ii+1)+d2*y(ii))/(d1+d2)
        endif
 30   continue
c
      return
      end
