      subroutine load_sig(j,rhoslab)
c
c=======================================================================
c                                                                    ===
c  This routine loads the density at every grid point.               ===
c                                                                    ===
c     On Input:                                                      ===
c                                                                    ===
c     J       the current slab  (integer)                            ===
#ifndef rmdenbar
c     RHOSLAB the density at every slab point  (real array)          ===
# else
c     RHOSLAB the density anomaly at every slab point  (real array)  ===
#endif
c     Calls:  none                                                   ===
c                                                                    ===
c     Common blocks: (only relevant variables documented)            ===
c                                                                    ===
#ifdef rmdenbar
c     /RHOMEAN/                                                      ===
c                                                                    ===
c     RHOBAR  background density field  (real array; input)          ===
c                                                                    ===
#endif
c     /TRKFLD/                                                       ===
c                                                                    ===
c     SIG_VOL the density at every grid point (real array; output)   ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#ifdef rmdenbar
#  include <rhomean.h>
#endif
#include <trkfld.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer j,i,k
      FLOAT
     *      rhoslab(imt,km)
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
c-----------------------------------------------------------------------
c  Load the density volume storage by slabs.
c-----------------------------------------------------------------------
c
      do 10 k=1,km
      do 10 i=1,imt
#ifndef rmdenbar
        sig_vol(i,j,k)=rhoslab(i,k)
# else
        sig_vol(i,j,k)=rhoslab(i,k)+rhobar(i,j,k)
#endif
  10  continue
      return
      end
