c
c=======================================================================
c  Include file "nest.h"
c=======================================================================
#ifndef rmdocinc
c
c  Variables
c
c  CURRTID   PVM task identifier for this run.                    (integer)
c  I_LL_S    Lower left corner of smaller grid in current grid.   (integer)
c  I_UR_S    Upper right corner of smaller grid in current grid.  (integer)
c  J_LL_S    Lower left corner of smaller grid in current grid.   (integer)
c  J_UR_S    Upper right corner of smaller grid in current grid.  (integer)
c  LRGTID    PVM task identifier for larger grid.                 (integer)
c  NXCS      Number of x-grid points in current domain covered by
c            smaller domain.                                      (integer)
c  NXLC      Number of x-grid points in larger domain covered by
c            current domain.                                      (integer)
c  NXS       Number of x-grid points in smaller grid.             (integer)
c  NYCS      Number of y-grid points in current domain covered by
c            smaller domain.                                      (integer)
c  NYLC      Number of y-grid points in larger domain covered by
c            current domain.                                      (integer)
c  NYS       Number of y-grid points in smaller grid.             (integer)
c  SMLTID    PVM task identifier for smaller grid.                (integer)
c  SPVL      Flag value from larger grid.                         (real)
c  SPVS      Flag value from smaller grid.                        (real)
# ifdef coast
c  T_ACT     Active value of land mask over tracer points.        (integer)
c  V_ACT     Active value of land mask over velocity points.      (integer)
# endif
c  XVOL      Volume storage for passing external data.            (real array)
c
c  Message Tags
c
c  IDOM2L    Integer domain parameters:  small to large
c  IDOM2S    Integer domain parameters:  large to small
c  IFILNM    Input file name
c  LNIFIL    Length of input file name
c  LNOFIL    Length of output file name
c  NTRC2L    Number of tracers to pass:  small to large
c  NTRC2S    Number of tracers to pass:  large to small
c  OFILNM    Output file name
c  PSIBDE    Transport streamfunction:  BC - E
c  PSIBDS    Transport streamfunction:  BC - S
c  PSIBDN    Transport streamfunction:  BC - N
c  PSIBDW    Transport streamfunction:  BC - W
c            or transport streamfunction: large to small
c  RDOM2L    Real domain parameters:  small to large
c  RDOM2S    Real domain parameters:  large to small
c  SPTS2L    Spawn test value: small to large
c  SPTS2S    Spawn test value: large to small
c  SPVL2L    Special value:  small to large
c  SPVL2S    Special value:  large to small
c  TROFST    Tracer off-set
c  TSVL2L    Test value:  small to large
c  TSVL2S    Test value:  large to small
c  UCBDYE    Uclin:  BC - E
c  UCBDYS    Uclin:  BC - S
c  UCBDYN    Uclin:  BC - N
c  UCBDYW    Uclin:  BC - W
c  UCINTR    Uclin:  interior
c  VCBDYE    Vclin:  BC - E
c  VCBDYS    Vclin:  BC - S
c  VCBDYN    Vclin:  BC - N
c  VCBDYW    Vclin:  BC - W
c  VCINTR    Vclin:  interior
c  VORTIN    Barotropic vorticity tendency:  interior
c  VRTBDE    Barotropic vorticity tendency:  BC - E
c  VRTBDS    Barotropic vorticity tendency:  BC - S
c  VRTBDN    Barotropic vorticity tendency:  BC - N
c  VRTBDW    Barotropic vorticity tendency:  BC - W
c
c=======================================================================
#endif
c
      integer horiz_fac,itt_fac,nest_start,nstflt
#if defined coast
     *        ,mn_spprt
#endif
      integer idom2l,idom2s,ifilnm,lnifil,lnofil,ntrc2l,ntrc2s,ofilnm,
     &        psibde,psibdn,psibds,psibdw,rdom2l,rdom2s,spts2l,spts2s,
     &        spvl2l,spvl2s,trofst,tsvl2l,tsvl2s,ucbdye,ucbdyn,ucbdys,
     &        ucbdyw,ucintr,vcbdye,vcbdyn,vcbdys,vcbdyw,vcintr,vortin,
     &        vrtbde,vrtbdn,vrtbds,vrtbdw
      FLOAT
     *      nest_small,spv
c
      parameter (horiz_fac=3, itt_fac=1, nest_small=c1em3,
     *           nest_start=0, spv=c1e35)
#ifndef dblprec
      parameter (nstflt=REAL4)
#else
      parameter (nstflt=REAL8)
#endif
#if defined coast
      parameter (mn_spprt=(horiz_fac+1)*(horiz_fac+1)/4)
#endif
      parameter (spts2s=   0, spts2l=   1, lnifil=   2, ifilnm=   3,
     &           lnofil=   4, ofilnm=   5, idom2l=   6, rdom2l=   7,
     &           idom2s=   8, rdom2s=   9, tsvl2l=  10, tsvl2s=  11,
     &           spvl2l=  12, spvl2s=  13, ntrc2l=  14, ntrc2s=  15,
     &           vortin=  16, ucintr=  17, vcintr=  18, vrtbdw=  19,
     &           vrtbde=  20, vrtbds=  21, vrtbdn=  22, psibdw=  23,
     &           psibde=  24, psibds=  25, psibdn=  26, ucbdyw=  27,
     &           ucbdye=  28, ucbdys=  29, ucbdyn=  30, vcbdyw=  31,
     &           vcbdye=  32, vcbdys=  33, vcbdyn=  34,
     &           trofst=1000)
c
      integer currtid,i_ll_s,i_ur_s,j_ll_s,j_ur_s,lrgtid,nxcs,nxlc,nxs,
     *               nycs,nylc,nys,smltid
#ifdef coast
     *              ,t_act,v_act
#endif
      common /inest/ currtid,i_ll_s,i_ur_s,j_ll_s,j_ur_s,lrgtid,nxcs,
     *               nxlc,nxs,nycs,nylc,nys,smltid
#ifdef coast
     *              ,t_act,v_act
#endif
c
#if !defined nest_ext2lrgr & !defined nest_ext2smlr
      FLOAT
     *      spvl,spvs,xvol(xmdat)
      common /fnest/ spvl,spvs,xvol
#else
      FLOAT
     *      spvl,spvs,xvol(xmdat),xpal(xmndat)
      common /fnest/ spvl,spvs,xvol,xpal
#endif
