      subroutine nest_errchk (module,task,status,n2spn,spnid,nspn)
c
c=======================================================================
c                                                                    ===
c  This routine reports PVM errors before exiting.                   ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     MODULE   Name of calling module.         (string)              ===
c     TASK     Name of PVM task.               (string)              ===
c     STATUS   Exit status indicator.          (integer)             ===
c     N2SPN    Number of tasks to spawn.       (integer)             ===
c     SPNID    Identifiers of spawned tasks.   (integer vector)      ===
c     NSPN     Number of tasks spawned.        (integer)             ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /IOUNITS/                                                         ===
c                                                                    ===
c     STDOUT    standard output logical unit.   (integer)            ===
c                                                                    ===
c  Calls:  ALL_UC,  EXITUS,  LENGTH                                  ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <fpvm3.h>
#include <iounits.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer n,n2spn,nspn,sbgn,send,slen,status
      integer spnid(n2spn)
      logical       ok
      character*256 wkstr
      character*(*) module,task
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Convert task to all upper case.
c-----------------------------------------------------------------------
c
      call all_uc (task,wkstr)
      call length (wkstr,slen,sbgn,send)
c
c-----------------------------------------------------------------------
c  Check for any errors.
c-----------------------------------------------------------------------
c
      ok = .true.
c
      if (wkstr(sbgn:send).eq.'CONFIGURATION') then
         ok = status .ge. 0
         if (.not.ok) then
            if (status.eq.PvmSysErr) then
               write (stdout,900) module,'get configuation',
     &                            'pvmd not responding'
             else
               write (stdout,900) module,'get configuation',
     &                            'unknown error'
            end if
         end if
c
       elseif (wkstr(sbgn:send).eq.'INITSEND') then
         ok = status .ge. 0
         if (.not.ok) then
            if (status.eq.PvmBadParam) then
               write (stdout,900) module,'clear buffer',
     &                            'invalid argument'
             elseif (status.eq.PvmNoMem) then
               write (stdout,900) module,'clear buffer',
     &                            'size exceeds available memory'
             else
               write (stdout,900) module,'clear buffer',
     &                            'unknown error'
            end if
         end if
c
       elseif (wkstr(sbgn:send).eq.'MYTID') then
         ok = status .ge. 0
         if (.not.ok) then
            if (status.eq.PvmSysErr) then
               write (stdout,900) module,'get current task ID',
     &                            'pvmd not responding'
             else
               write (stdout,900) module,'get current task ID',
     &                            'unknown error'
            end if
         end if
c
       elseif (wkstr(sbgn:send).eq.'PACK') then
         ok = status .eq. PvmOk
         if (.not.ok) then
            if (status.eq.PvmNoMem) then
               write (stdout,900) module,'pack buffer',
     &                            'size exceeds available memory'
             elseif (status.eq.PvmNoBuf) then
               write (stdout,900) module,'pack buffer',
     &                            'no active buffer to pack into'
             else
               write (stdout,900) module,'pack buffer',
     &                            'unknown error'
            end if
         end if
c
       elseif (wkstr(sbgn:send).eq.'PARENTTID') then
         ok = status .ge. 0
         if (.not.ok) then
            if (status.eq.PvmNoParent) then
               write (stdout,900) module,'get parent task ID',
     &                            'this is not a spawned process'
             else
               write (stdout,900) module,'get parent task ID',
     &                            'unknown error'
            end if
         end if
c
       elseif (wkstr(sbgn:send).eq.'RECEIVE') then
         ok = status .ge. 0
         if (.not.ok) then
            if (status.eq.PvmBadParam) then
               write (stdout,900) module,'receive message',
     &                            'invalid task ID or message tag'
             elseif (status.eq.PvmSysErr) then
               write (stdout,900) module,'receive message',
     &                            'pvmd not responding'
             else
               write (stdout,900) module,'receive message',
     &                            'unknown error'
            end if
         end if
c
       elseif (wkstr(sbgn:send).eq.'SEND') then
         ok = status .eq. PvmOk
         if (.not.ok) then
            if (status.eq.PvmBadParam) then
               write (stdout,900) module,'send message',
     &                            'invalid task ID or message tag'
             elseif (status.eq.PvmSysErr) then
               write (stdout,900) module,'send message',
     &                            'pvmd not responding'
             elseif (status.eq.PvmNoBuf) then
               write (stdout,900) module,'send message',
     &                            'no active send buffer'
             else
               write (stdout,900) module,'send message',
     &                            'unknown error'
            end if
         end if
c
       elseif (wkstr(sbgn:send).eq.'SPAWN') then
         ok = n2spn .eq. nspn
         if (.not.ok) then
            if (nspn.eq.PvmBadParam) then
               write (stdout,900) module,'spawn sub-process',
     &                            'invalid argument'
             elseif (nspn.eq.PvmNoHost) then
               write (stdout,900) module,'spawn sub-process',
     &                           'specified host not in virtual machine'
             elseif (nspn.eq.PvmNoFile) then
               write (stdout,900) module,'spawn sub-process',
     &                            'specified executable not found'
             elseif (nspn.eq.PvmNoMem) then
               write (stdout,900) module,'spawn sub-process',
     &                            'not enough memory on host'
             elseif (nspn.eq.PvmSysErr) then
               write (stdout,900) module,'spawn sub-process',
     &                            'pvmd not responding'
             elseif (nspn.eq.PvmOutOfRes) then
               write (stdout,900) module,'spawn sub-process',
     &                            'out of resources'
             else
               do 10 n = (nspn+1), n2spn
                  if (spnid(n).eq.PvmBadParam) then
                     write (stdout,900) module,'spawn sub-process',
     &                                  'invalid argument'
                   elseif (spnid(n).eq.PvmNoHost) then
                     write (stdout,900) module,'spawn sub-process',
     &                           'specified host not in virtual machine'
                   elseif (spnid(n).eq.PvmNoFile) then
                     write (stdout,900) module,'spawn sub-process',
     &                                  'specified executable not found'
                   elseif (spnid(n).eq.PvmNoMem) then
                     write (stdout,900) module,'spawn sub-process',
     &                                  'not enough memory on host'
                   elseif (spnid(n).eq.PvmSysErr) then
                     write (stdout,900) module,'spawn sub-process',
     &                                  'pvmd not responding'
                   elseif (spnid(n).eq.PvmOutOfRes) then
                     write (stdout,900) module,'spawn sub-process',
     &                                  'out of resources'
                   else
                     write (stdout,900) module,'spawn sub-process',
     &                                  'unknown error'
                  end if
  10           continue
            end if
         end if
c
       elseif (wkstr(sbgn:send).eq.'STATUSCHECK') then
         ok = status .eq. PvmOk
         if (.not.ok) then
            if (status.eq.PvmBadParam) then
               write (stdout,900) module,'send message',
     &                            'invalid task ID or message tag'
             elseif (status.eq.PvmSysErr) then
               write (stdout,900) module,'send message',
     &                            'pvmd not responding'
             elseif (status.eq.PvmNoTask) then
               write (stdout,900) module,'send message',
     &                            'task is not running'
             else
               write (stdout,900) module,'send message',
     &                            'unknown error'
            end if
         end if
c
       elseif (wkstr(sbgn:send).eq.'UNPACK') then
         ok = status .eq. PvmOk
         if (.not.ok) then
            if (status.eq.PvmNoData) then
               write (stdout,900) module,'unpack buffer',
     &                            'reading beyond end of buffer'
             elseif (status.eq.PvmBadMsg) then
               write (stdout,900) module,'unpack buffer',
     &                            'received message cannot be decoded'
             elseif (status.eq.PvmNoBuf) then
               write (stdout,900) module,'unpack buffer',
     &                            'no active buffer to unpack'
             else
               write (stdout,900) module,'unpack buffer',
     &                            'unknown error'
            end if
         end if
      end if
c
c-----------------------------------------------------------------------
c  Return or fold, depending upon error status.
c-----------------------------------------------------------------------
c
      if (.not.ok) call exitus (module)
c
      return
c
 900  format (/'***Error:  ',a,' - unable to ',a/11x,1h",a,1h")
c
      end
