      subroutine nest_spawn
c
c=======================================================================
c                                                                    ===
c  This routine spawns a nested subdomain process.                   ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /IOUNITS/                                                         ===
c                                                                    ===
c     SMLHNM   Name of host on which to run smaller grid.   (string) ===
c     SMLINM   Name of param. input file for smaller grid.  (string) ===
c     SMLONM   Name of output log file for smaller grid.    (string) ===
c     SMLTNM   Name of executable for smaller grid.         (string) ===
c     STDOUT   standard output logical unit.                (integer)===
c                                                                    ===
c  -------                                                           ===
c  Output:                                                           ===
c  -------                                                           ===
c                                                                    ===
c  Common Blocks:                                                    ===
c                                                                    ===
c  /NEST/                                                            ===
c                                                                    ===
c     SMLTID    PVM task identifier for smaller grid.   (integer)    ===
c                                                                    ===
c  Calls:      EXITUS,        LENGTH,    HOPSRECV,  HOST_CHECK,      ===
c              NEST_ERRCHK                                           ===
c  PVM Calls:  PVMFINITSEND,  PVMFPACK,  PVMFSEND,  PVMFSPAWN,       ===
c              PVMFUNPACK                                            ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <fpvm3.h>
#include <iounits.h>
#include <nest.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer bufid,lenstr,lnstr2,nsml,recval,sbgn,sbn2,send,snd2,
     &        status,testval
      logical hostok
c
      parameter (testval=8)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Spawn nested subdomain process.
c-----------------------------------------------------------------------
c
      call length (smltnm,lenstr,sbgn,send)
      call host_check (smlhnm,lnstr2,sbn2,snd2,hostok)
c
      if (.not.hostok) then
         call pvmfspawn (smltnm(sbgn:send),PVMTASKDEFAULT,'*',1,
     &                   smltid,nsml)
       else
         call pvmfspawn (smltnm(sbgn:send),PVMTASKHOST,
     &                   smlhnm(sbn2:snd2),1,smltid,nsml)
      endif
c
      call nest_errchk ('NEST_SPAWN','Spawn',0,1,smltid,nsml)
c
c-----------------------------------------------------------------------
c  Test the connection.
c-----------------------------------------------------------------------
c
c  Send test integer value to smaller domain.
c
      call pvmfinitsend (PVMDATADEFAULT,bufid)
      call nest_errchk ('NEST_SPAWN','InitSend',bufid,1,1,1)
      call pvmfpack (INTEGER4,testval,1,1,status)
      call nest_errchk ('NEST_SPAWN','Pack',status,1,1,1)
      call pvmfsend (smltid,spts2s,status)
      call nest_errchk ('NEST_SPAWN','Send',status,1,1,1)
c
c  Receive test integer value from smaller domain.
c
      call hopsrecv ('NEST_SPAWN',smltid,spts2l,bufid)
      call pvmfunpack (INTEGER4,recval,1,1,status)
      call nest_errchk ('NEST_SPAWN','UnPack',status,1,1,1)
c
c  Compare values.
c
      if (testval.ne.recval) then
         write (stdout,900) testval,recval
         call exitus ('NEST_SPAWN')
      end if
c
c-----------------------------------------------------------------------
c  Send I/O file names for smaller domain.
c-----------------------------------------------------------------------
c
c  Send input file name & its length to smaller domain.
c
      call pvmfinitsend (PVMDATADEFAULT,bufid)
      call nest_errchk ('NEST_SPAWN','InitSend',bufid,1,1,1)
      call length (smlinm,lenstr,sbgn,send)
      call pvmfpack (INTEGER4,lenstr,1,1,status)
      call nest_errchk ('NEST_SPAWN','Pack',status,1,1,1)
      call pvmfsend (smltid,lnifil,status)
      call nest_errchk ('NEST_SPAWN','Send',status,1,1,1)
c
      call pvmfinitsend (PVMDATADEFAULT,bufid)
      call nest_errchk ('NEST_SPAWN','InitSend',bufid,1,1,1)
      call pvmfpack (STRING,smlinm(sbgn:sbgn),lenstr,1,status)
      call nest_errchk ('NEST_SPAWN','Pack',status,1,1,1)
      call pvmfsend (smltid,ifilnm,status)
      call nest_errchk ('NEST_SPAWN','Send',status,1,1,1)
c
c  Send output file name & its length to smaller domain.
c
      call pvmfinitsend (PVMDATADEFAULT,bufid)
      call nest_errchk ('NEST_SPAWN','InitSend',bufid,1,1,1)
      call length (smlonm,lenstr,sbgn,send)
      call pvmfpack (INTEGER4,lenstr,1,1,status)
      call nest_errchk ('NEST_SPAWN','Pack',status,1,1,1)
      call pvmfsend (smltid,lnofil,status)
      call nest_errchk ('NEST_SPAWN','Send',status,1,1,1)
c
      call pvmfinitsend (PVMDATADEFAULT,bufid)
      call nest_errchk ('NEST_SPAWN','InitSend',bufid,1,1,1)
      call pvmfpack (STRING,smlonm(sbgn:sbgn),lenstr,1,status)
      call nest_errchk ('NEST_SPAWN','Pack',status,1,1,1)
      call pvmfsend (smltid,ofilnm,status)
      call nest_errchk ('NEST_SPAWN','Send',status,1,1,1)
c
      return
c
 900  format (/'***Error:  NEST_SPAWN - unable to properly exchange ',
     &        'test values with smaller domain.'/11x,'test value:  ',i10
     &        /11x,'received value:  ',i10)
c
      end
