#if !defined usrdiagnostic | !defined nesttime
      subroutine nest_t_align (n_tim)
#else
      subroutine nest_t_align (n_tim,tsn1)
#endif
c
c=======================================================================
c                                                                    ===
c This routine checks the timing alignment during nesting.           ===
c                                                                    ===
c ------                                                             ===
c Input:                                                             ===
c ------                                                             ===
c                                                                    ===
c    N_TIM     Current time step.                    (integer)       ===
c                                                                    ===
c Common Blocks:                                                     ===
c                                                                    ===
c /IOUNITS/                                                          ===
c                                                                    ===
c    STDOUT    Unit number for standard output.      (integer)       ===
c                                                                    ===
#if defined usrdiagnostic & defined nesttime
c -------                                                            ===
c Output:                                                            ===
c -------                                                            ===
c                                                                    ===
c    TSN1      Time spent in routine.                (real vector)   ===
c                                                                    ===
#endif
c Calls:  EXITUS, NEST_TEST                                          ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <fpvm3.h>
#include <iounits.h>
#include <nest.h>
c
c-----------------------------------------------------------------------
c  Define local and equivalence data.
c-----------------------------------------------------------------------
c
      integer n_tim
#if defined usrdiagnostic & defined nesttime
      FLOAT
     &      tsn1(2)
#endif
#ifndef nestnultest
      integer lgind
      integer rec_tim(2),x_tim(2)
      logical ok
c
# if defined nest2larger & defined nest2smaller
      parameter (lgind=2)
# else
      parameter (lgind=1)
# endif
#endif
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Check time step for consistency.
c-----------------------------------------------------------------------
#ifndef nestnultest
c
      if (n_tim.gt.nest_start) then
c
# ifdef nest2smaller
         x_tim(1)     = (n_tim-1)*itt_fac + 1
# endif
# ifdef nest2larger
         x_tim(lgind) = (n_tim-1)/itt_fac + 1
# endif
c
         call nest_test (n_tim,x_tim,ok,rec_tim)
c
         if (.not. ok) then
            write (stdout,900) n_tim
# ifdef nest2smaller
     &                         ,'smaller',rec_tim(1),x_tim(1)
# endif
# ifdef nest2larger
     &                         ,'larger',rec_tim(lgind),x_tim(lgind)
# endif
            call exitus ('NEST_T_ALIGN')
         end if
c
      end if
#endif
#if defined usrdiagnostic & defined nesttime
      call dtime (tsn1)
#endif
c
      return
c
 900  format (/'***Error:  NEST_T_ALIGN - time steps do NOT match'/11x,
     *        'time step (current domain): ',i10,2(:/11x,'time step (',
     *        a,' domain): ',i10,',  expected: ',i10))
c
      end
