      subroutine nest_test (testval,xrec,ok,recvals)
c
c=======================================================================
c                                                                    ===
c This routine tests the current status of the nested ensemble.      ===
c                                                                    ===
c ------                                                             ===
c Input:                                                             ===
c ------                                                             ===
c                                                                    ===
c    TESTVAL   The test value to send to neighbors. (integer)        ===
c    XREC      Expected values to receive.          (integer vector) ===
c                                                                    ===
c Common Blocks                                                      ===
c                                                                    ===
c /NEST/                                                             ===
c                                                                    ===
c    CURRTID   PVM task identifier for this run.       (integer)     ===
c    LRGTID    PVM task identifier for larger grid.    (integer)     ===
c    SMLTID    PVM task identifier for smaller grid.   (integer)     ===
c                                                                    ===
c -------                                                            ===
c Output:                                                            ===
c -------                                                            ===
c                                                                    ===
c    OK        Nesting status flag.  [t] ok  [f] error.  (logical)   ===
c    RECVALS   Values received from other domains.       (integer)   ===
c                                                                    ===
c  Calls:      HOPSRECV,      NEST_ERRCHK                            ===
c  PVM Calls:  PVMFINITSEND,  PVMFPACK,    PVMFSEND,  PVMFUNPACK,    ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <fpvm3.h>
#include <nest.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer bufid,lgind,status,testval
      integer recvals(2),xrec(2)
      logical ok
c
#if defined nest2larger & defined nest2smaller
      parameter (lgind=2)
#else
      parameter (lgind=1)
#endif
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
#ifdef nest2smaller
c-----------------------------------------------------------------------
c  Receive test value from smaller domain.  Compare to expected value.
c-----------------------------------------------------------------------
c
      call hopsrecv ('NEST_TEST',smltid,tsvl2l,bufid)
      call pvmfunpack (INTEGER4,recvals(1),1,1,status)
      call nest_errchk ('NEST_TEST','UnPack',status,1,1,1)
c
      ok = xrec(1) .eq. recvals(1)
c
#endif
#ifdef nest2larger
c-----------------------------------------------------------------------
c  Send test value to larger domain.
c-----------------------------------------------------------------------
c
      call pvmfinitsend (PVMDATADEFAULT,bufid)
      call nest_errchk ('NEST_TEST','InitSend',bufid,1,1,1)
# ifdef nest2smaller
      if (ok) then
         call pvmfpack (INTEGER4,testval,1,1,status)
        else
         call pvmfpack (INTEGER4,testval-1,1,1,status)
      end if
# else
      call pvmfpack (INTEGER4,testval,1,1,status)
# endif
      call nest_errchk ('NEST_TEST','Pack',status,1,1,1)
      call pvmfsend (lrgtid,tsvl2l,status)
      call nest_errchk ('NEST_TEST','Send',status,1,1,1)
c
c-----------------------------------------------------------------------
c  Receive test value from larger domain.  Compare to expected value.
c-----------------------------------------------------------------------
c
      call hopsrecv ('NEST_TEST',lrgtid,tsvl2s,bufid)
      call pvmfunpack (INTEGER4,recvals(lgind),1,1,status)
      call nest_errchk ('NEST_TEST','UnPack',status,1,1,1)
c
# ifdef nest2smaller
      ok = ok .and.(xrec(lgind) .eq. recvals(lgind))
# else
      ok = xrec(lgind) .eq. recvals(lgind)
# endif
c
#endif
#ifdef nest2smaller
c-----------------------------------------------------------------------
c  Send test value to smaller domain.
c-----------------------------------------------------------------------
c
      call pvmfinitsend (PVMDATADEFAULT,bufid)
      call nest_errchk ('NEST_TEST','InitSend',bufid,1,1,1)
      if (ok) then
         call pvmfpack (INTEGER4,testval,1,1,status)
        else
         call pvmfpack (INTEGER4,testval-1,1,1,status)
      end if
      call nest_errchk ('NEST_TEST','Pack',status,1,1,1)
      call pvmfsend (smltid,tsvl2s,status)
      call nest_errchk ('NEST_TEST','Send',status,1,1,1)
c
#endif
      return
      end
