      subroutine odam(lu,nwrs,nfrst,a)
c
c=======================================================================
c                                                                    ===
c  ODAM (Ocean  Direct  Access  Manager) is a set of routines which  ===
c       simulates  memory/disc data transfer management,  using the  ===
c       central memory array, SDISK as a virtual disc. This results  ===
c       in a totally core contained system. The arguments, in terms  ===
c       terms of normal disc I/O, are:                               ===
c                                                                    ===
c         LU       I/O unit number                                   ===
c         NTOT     length of unit, in words                          ===
c         NBLK     length of each block on the unit                  ===
c         NBUF     number of buffers supplied to the unit            ===
c         NWRS     number of words to transfer                       ===
c         NFRST    unit address of the first word to be transferred  ===
c         A        origination/destination array in memory           ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
c
c-----------------------------------------------------------------------
c  Define and equivalence local data.
c-----------------------------------------------------------------------
c
      integer lo,lu,nblk,nbuf,nfrst,n,ne,nend,ns,nskp,nsl,nstr,ntb,ntot,
     *        nwrs,n11,n12,me,ms
      parameter (n11=20,n12=imt*jmt*nkflds,
     *           nsl=((nt+2)*imtkm+lbc*imt)*jmt,ntb=n11+n12+3*nsl)
      FLOAT
     *      a(nwrs),sdisk(ntb)
      save sdisk
c
c-----------------------------------------------------------------------
c  Begin executable code.
c-----------------------------------------------------------------------
c
      entry ostart(lu,ntot,nblk,nbuf)
      return
      entry ofind(lu,nwrs,nfrst)
      return
c
c-----------------------------------------------------------------------
c  Virtual disc-to-memory transfer.
c-----------------------------------------------------------------------
c
      entry oget(lu,nwrs,nfrst,a)
      nskp=0
      if(lu.gt.11) nskp=nskp+n11
      if(lu.gt.12) nskp=nskp+n12
      ns=nfrst+nskp
      if(lu.ge.13) ns=nskp+(3*((nfrst-1)/nwrs)+(lu-13))*nwrs+1
      ne=ns+nwrs-1
      do 100 n=ns,ne
        a(n-ns+1)=sdisk(n)
 100  continue
      return
c
c-----------------------------------------------------------------------
c  Selected virtual disc-to-memory transfer.
c-----------------------------------------------------------------------
c
      entry opick(lu,nwrs,nfrst,nstr,nend,a)
      nskp=0
      if(lu.gt.11) nskp=nskp+n11
      if(lu.gt.12) nskp=nskp+n12
      ns=nfrst+nskp
      if(lu.ge.13) ns=nskp+(3*((nfrst-1)/nwrs)+(lu-13))*nwrs+1
      ms=ns+nstr-1
      me=ns+nend-1
      do 110 n=ms,me
        a(n-ms+1)=sdisk(n)
 110  continue
      return
c
c-----------------------------------------------------------------------
c  Memory-to-virtual disc transfer
c-----------------------------------------------------------------------
c
      entry oput(lu,nwrs,nfrst,a)
      nskp=0
      if(lu.gt.11) nskp=nskp+n11
      if(lu.gt.12) nskp=nskp+n12
      ns=nfrst+nskp
      if(lu.ge.13) ns=nskp+(3*((nfrst-1)/nwrs)+(lu-13))*nwrs+1
      ne=ns+nwrs-1
      do 120 n=ns,ne
        sdisk(n)=a(n-ns+1)
 120  continue
      return
      entry oclose(lu)
      return
c
c-----------------------------------------------------------------------
c  Initialize virtual disc from tape
c-----------------------------------------------------------------------
c
      entry ord(lo)
      read(lo) sdisk
      return
c
c-----------------------------------------------------------------------
c  Save virtual disc to tape
c-----------------------------------------------------------------------
c
      entry owrt(lo)
      write(lo) sdisk
      return
      end
