c
c=======================================================================
c  Include file "onedim.h"
c=======================================================================
c
#ifndef rmdocinc
c  CS       cosine metric factors at velocity points.
c  CSR      reciprocal of CS (CSR=1/CS).
c  CST      cosine metric factors at tracer points.
c  CSTR     reciprocal of CST (CSTR=1/CST).
c  DXT      zonal grid spacing across tracer boxes.
c  DXTR     reciprocal of DXT (DXTR=1/DXTR).
c  DXT2R    reciprocal of twice DXT (DXT2R=0.5/DXT).
c  DXT4R    reciprocal of four times DXT (DXT4R=0.25/DXT).
c  DXU      zonal grid spacing across velocity boxes.
c  DXUR     reciprocal of DXU (DXUR=1/DXUR).
c  DXU2R    reciprocal of twice DXU (DXU2R=0.5/DXU).
c  DXU4R    reciprocal of four times DXU (DXU4R=0.25/DXU).
c  DYT      meridional grid spacing across tracer boxes.
c  DYTR     reciprocal of DYT (DYTR=1/DYTR).
c  DYT2R    reciprocal of twice DYT (DYT2R=0.5/DYT).
c  DYT4R    reciprocal of four times DYT (DYT4R=0.25/DYT).
c  DYU      meridional grid spacing across velocity boxes.
c  DYUR     reciprocal of DYU (DYUR=1/DYUR).
c  DYU2R    reciprocal of twice DYU (DYU2R=0.5/DYU).
c  DYU4R    reciprocal of four times DYU (DYU4R=0.25/DYU).
c  DZ       thickness of the flat vertical boxes.
c  LPMTGD   metric factor for gradient metric term in velocity laplacian
c  LPMTVL   metric factor for velocity metric term in velocity laplacian
c  PHI      latitude in radians of the velocity points.
c  PHIT     latitude in radians of the tracer points.
c  SINE     Coriolis sine of the velocity point latitudes.
c  UBAR     present timestep zonal external mode velocity j-th slab.
c  UBARB    previous timestep zonal external mode velocity j-th slab.
c  VBAR     present timestep meridional external mode velocity j-th slab.
c  VBARB    previous timestep meridional external mode velocity j-th slab.
c  UBARM    present timestep zonal external mode velocity (j-1)-th slab.
c  UBARBM   previous timestep zonal external mode velocity (j-1)-th slab.
c  VBARM    present timestep meridional external mode velocity (j-1)-th slab.
c  VBARBM   previous timestep meridional external mode velocity (j-1)-th slab.
c  UBARP    present timestep zonal external mode velocity (j+1)-th slab.
c  UBARBP   previous timestep zonal external mode velocity (j+1)-th slab.
c  VBARP    present timestep meridional external mode velocity (j+1)-th slab.
c  VBARBP   previous timestep meridional external mode velocity (j+1)-th slab.
c
c=======================================================================
c
#endif
      common /onedim/ dxt,dxtr,dxt2r,dxt4r,dxu,dxur,dxu2r,dxu4r,dyt,
     *       dytr,dyt2r,dyt4r,dyu,dyur,dyu2r,dyu4r,dz,cs,csr,cst,cstr,
     *       ubar,ubarb,vbar,vbarb,phi,phit,sine,lpmtgd,lpmtvl,
     *       ubarp,ubarbp,vbarp,vbarbp,
     *       ubarm,ubarbm,vbarm,vbarbm
      FLOAT 
     *      cs    (jmt),dxt   (imt),dxu   (imt),dyt   (jmt),dyu   (jmt),
     *      csr   (jmt),dxtr  (imt),dxur  (imt),dytr  (jmt),dyur  (jmt),
     *      cst   (jmt),dxt2r (imt),dxu2r (imt),dyt2r (jmt),dyu2r (jmt),
     *      cstr  (jmt),dxt4r (imt),dxu4r (imt),dyt4r (jmt),dyu4r (jmt),
     *      dz    ( km),lpmtgd(jmt),lpmtvl(jmt),ubar  (imt),
     *      ubarb (imt),vbar  (imt),vbarb (imt),
     *      phi(imt,jmt),phit(imt,jmt),sine(imt,jmt),
     *       ubarp(imt),ubarbp(imt),vbarp(imt),vbarbp(imt),
     *       ubarm(imt),ubarbm(imt),vbarm(imt),vbarbm(imt)
