      subroutine pb0wrtcdf (jrow,f,m,n,fldid,vindx,fileid)
c
c=======================================================================
c                                                                    ===
c  This routine writes out the field F(m,n) at the specified slab    ===
c  JROW and at the requested levels in LEV(NLEV) in NetCDF format.   ===
c  If LEV is greater than KM then LEV is taken as depth in meters    ===
c  to interpolate.                                                   ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     JROW     current slab index (integer).                         ===
c     F        field to write (real array).                          ===
c     M,N      first and second dimension for field F (integer).     ===
c     FLDID    field ID in output NetCDF file (integer).             ===
c     VINDX    vector component index (integer).                     ===
c     FILEID   NetCDF output file ID (integer).                      ===
c                                                                    ===
c  Calls:  NCVPT  (NetCDF library)                                   ===
c          EXITUS                                                    ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <iounits.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer fileid,fldid,jrow,m,n,l,rcode,vindx
      integer count(4),start(4)
      FLOAT
     *      f(m,n)
c
c=======================================================================
c  Begin Executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Write out field into netCDF file.
c-----------------------------------------------------------------------
c
      start(1)=vindx
      count(1)=1
      count(2)=1
      start(3)=1
      count(3)=m
      start(4)=jrow
      count(4)=1
c
      do 10 l=1,n
c
        start(2)=l
        call ncvpt(fileid,fldid,start,count,f(1,l),rcode)
        if(rcode.ne.0) then
          write(stdout,900) fldid,l
          call exitus('PB0WRTCDF')
        endif
c
  10  continue
c
 900  format(' PB0WRTCDF - error while writing variable with NetCDF ID '
     *       ,'= ',i4,2x,' at output level/depth = ',i6)
      return
      end
