      subroutine press_bias (dpdx,dpdy,j)
c
c=======================================================================
c                                                                    ===
c  PRESS_BIAS removes part of the systematic error  obtained         ===
c         in the pressure gradient.                                  ===
c                                                                    ===
c         J = the row number                                         ===
c                                                                    ===
c         Calls:  EXITUS                                             ===
c  netCDF Calls:  NCOPN, NCVGT, NCVID                                ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <iounits.h>
#include <netcdf.inc>
#include <pe_netcdf.h>
#if defined shapiro & defined shapmean
#  include <voldat.h>
#endif
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer i,j,k
#if defined shapiro & defined shapmean
     &        ,n,rcode0,sbgn,send,slen,varid0
#endif
      integer count(5),start(5)
      logical first
#if defined shapiro & defined shapmean
     &        ,new
#endif
      FLOAT
     &     dp0dx(imt,jmt,km),dp0dy(imt,jmt,km),dpdx(imt,km),dpdy(imt,km)
c
      save count,dp0dx,dp0dy,first,start
c
      data first /.true./
      data start /5*1/
      data count /2*1,imt,jmt,1/
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  On first pass, read bias data.
c-----------------------------------------------------------------------
c
      if (first) then
c
        first=.false.
c
c  --  Open bias netCDF data file.
c
        ncpbid = ncopn (pbisnam,ncnowrit,rcode)
        if(rcode.eq.0) then
          ncpbst = 2
         else
          write(stdout,900) pbisnam
          call exitus('PRESS_BIAS')
        endif
c
c  --  Read pressure gradient bias.
c
        varid = ncvid (ncpbid,'press_bias',rcode)
        if (rcode.ne.0) then
          write (stdout,910) 'press_bias'
          call exitus ('PRESS_BIAS')
        endif
c
        do 10 k = 1, km
c
          start(1) = 1
          start(2) = k
c
          call ncvgt (ncpbid,varid,start,count,dp0dx(1,1,k),rcode)
          if (rcode.ne.0) then
            write (stdout,920) 'press_bias:  dp0/dx'
            call exitus ('PRESS_BIAS')
          endif
c
          start(1) = 2
c
          call ncvgt (ncpbid,varid,start,count,dp0dy(1,1,k),rcode)
          if (rcode.ne.0) then
            write (stdout,920) 'press_bias:  dp0/dy'
            call exitus ('PRESS_BIAS')
          endif
c
  10    continue
#if defined shapiro & defined shapmean
c
c  --  Read mean tracer fields.
c
        varid0 = ncvid (ncpbid,'tracer_mean',rcode0)
c
        do 30 n = 1, nt
c
          call length (tname(1,n),slen,sbgn,send)
          call ncpopt (0)
          varid = ncvid (ncinpid,tname(1,n)(sbgn:send)//'mean',rcode)
          call ncpopt (ncverbos)
          new = rcode .eq. 0
          if ((.not.new).and.(rcode0.eq.0)) then
            varid = varid0
           elseif ((.not.new).and.(rcode0.ne.0)) then
            write (stdout,910) tname(1,n)(sbgn:send)//
     &                         'mean or tracer_mean'
            call exitus ('PRESS_BIAS')
          endif
c
          start(1) = n
c
          do 20 k = 1, km
c
            start(2) = k
c
            if (new) then
              call ncvgt (ncinpid,varid,start(2),count(2),xt0(1,1,k,n),
     &                    rcode)
             else
              call ncvgt (ncpbid,varid,start,count,xt0(1,1,k,n),rcode)
            endif
            if (rcode.ne.0) then
              write (stdout,920) tname(1,n)(sbgn:send)//
     &                           'mean or tracer_mean'
              call exitus ('PRESS_BIAS')
            endif
c
  20      continue
  30    continue
#endif
c
      endif
c
c-----------------------------------------------------------------------
c  Remove bias in pressure gradient.
c-----------------------------------------------------------------------
c
      do 40 k=1,km
      do 40 i=1,imt
        dpdx(i,k)=dpdx(i,k)-dp0dx(i,j,k)
        dpdy(i,k)=dpdy(i,k)-dp0dy(i,j,k)
  40  continue
c
      return
c
 900  format (/'***Error:  PRESS_BIAS - unable to open file ',1h",
     &        a,1h",'.')
 910  format (/'***Error:  PRESS_BIAS - unable to find variable ',1h",
     &        a,1h",'.')
 920  format (/'***Error:  PRESS_BIAS - unable to read variable ',1h",
     &        a,1h",'.')
c
      end
