      subroutine press_bias0 (dpdx,dpdy,j)
c
c=======================================================================
c                                                                    ===
c  PRESS_BIAS0 extracts the systematic error  obtained               ===
c         in the pressure gradient.                                  ===
c  NOTE: from first time step run with horizontally averaged T,S     ===
c                                                                    ===
c         J = the row number                                         ===
c                                                                    ===
c         Calls:  DEFBIAS, EXITUS, OPICK, PB0WRTCDF                  ===
c  netCDF Calls:  NCVID                                              ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <iounits.h>
#include <netcdf.inc>
#include <pe_netcdf.h>
#if defined shapiro & defined shapmean
#  include <fullwd.h>
#  include <workspa.h>
#endif
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
#if defined shapiro & defined shapmean
      integer imtkmnt
      parameter (imtkmnt=nt*imtkm)
#endif
      integer j,pbid
#if defined shapiro & defined shapmean
     *        ,n,shid
#endif
      logical first
      FLOAT
     &     dpdx(imt,km),dpdy(imt,km)
#if defined shapiro & defined shapmean
     *      ,tp2(imt,km,nt)
#endif
c
      save first,pbid
#if defined shapiro & defined shapmean
     *     ,shid
#endif
c
      data first /.true./
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  On first call, define netCDF output file.  Get variable identifiers.
c-----------------------------------------------------------------------
c
      if(first) then
c
        call defbias
c
        pbid = ncvid (ncpbid,'press_bias',rcode)
        if (rcode.ne.0) then
          write (stdout,900) 'press_bias'
          call exitus ('PRESS_BIAS0')
        endif
c
#if defined shapiro & defined shapmean
        shid = ncvid (ncpbid,'tracer_mean',rcode)
        if (rcode.ne.0) then
          write (stdout,900) 'tracer_mean'
          call exitus ('PRESS_BIAS0')
        endif
c
#endif
        first=.false.
c
      endif
c
c-----------------------------------------------------------------------
c  Write bias fields.
c-----------------------------------------------------------------------
c
c  -- Write x-component of pressure gradient bias.
c
      call pb0wrtcdf (j,dpdx,imt,km,pbid,1,ncpbid)
      if (j.eq.2) call pb0wrtcdf (1,dpdx,imt,km,pbid,1,ncpbid)
      if (j.eq.jmtm2) then
         call pb0wrtcdf (jmtm1,dpdx,imt,km,pbid,1,ncpbid)
         call pb0wrtcdf (jmt,dpdx,imt,km,pbid,1,ncpbid)
      end if
c
c  -- Write y-component of pressure gradient bias.
c
      call pb0wrtcdf (j,dpdy,imt,km,pbid,2,ncpbid)
      if (j.eq.2) call pb0wrtcdf (1,dpdy,imt,km,pbid,2,ncpbid)
      if (j.eq.jmtm2) then
         call pb0wrtcdf (jmtm1,dpdy,imt,km,pbid,2,ncpbid)
         call pb0wrtcdf (jmt,dpdy,imt,km,pbid,2,ncpbid)
      end if
#if defined shapiro & defined shapmean
c
c  -- Write mean tracer fields.
c
      if (j.eq.jmtm2)
     &   call opick (labs(ndisk),nslab,(j+1)*nslab+1,1,imtkmnt,tp2)
      do 10 n=1,nt
         call pb0wrtcdf (j,t(1,1,n),imt,km,shid,n,ncpbid)
         if (j.eq.2) call pb0wrtcdf (1,tm(1,1,n),imt,km,shid,n,ncpbid)
         if (j.eq.jmtm2) then
            call pb0wrtcdf (jmtm1,tp(1,1,n),imt,km,shid,n,ncpbid)
            call pb0wrtcdf (jmt,tp2(1,1,n),imt,km,shid,n,ncpbid)
         end if
 10   continue
c
#endif
      return
c
 900  format (/'***Error:  PRESS_BIAS0 - unable to find variable ',1h",
     &        a,1h",'.')
c
      end
