      subroutine putbparm (ncid)
c
c=======================================================================
c                                                                    ===
c  This routine writes the biological parameters to the output       ===
c  netCDF file.  This particular version does so for the             ===
c  Anderson model.                                                   ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     NCID     Identifier for output netCDF file.   (integer)        ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <cbiopnh.h>
#include <netcdf.inc>
#include <pe_netcdf.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer ncid
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Write light parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'attphy',rcode)
      call ncvpt1 (ncid,varid,1,attphy*m2cm,rcode)
c
      varid = ncvid (ncid,'parfrac',rcode)
      call ncvpt1 (ncid,varid,1,parfrac,rcode)
c
c-----------------------------------------------------------------------
c  Write photosynthesis parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'photorm',rcode)
      call ncvpt1 (ncid,varid,1,photorm*day2sec,rcode)
c
      varid = ncvid (ncid,'photor0',rcode)
      call ncvpt1 (ncid,varid,1,photor0,rcode)
c
      varid = ncvid (ncid,'photoinh',rcode)
      call ncvpt1 (ncid,varid,1,photoinh,rcode)
c
c-----------------------------------------------------------------------
c  Write nutrient uptake parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'hsno3',rcode)
      call ncvpt1 (ncid,varid,1,hsno3,rcode)
c
      varid = ncvid (ncid,'hsnh4',rcode)
      call ncvpt1 (ncid,varid,1,hsnh4,rcode)
c
      varid = ncvid (ncid,'no3inh',rcode)
      call ncvpt1 (ncid,varid,1,no3inh,rcode)
c
c-----------------------------------------------------------------------
c  Write phytoplankton loss rate parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'phylr1',rcode)
      call ncvpt1 (ncid,varid,1,phylr1*day2sec,rcode)
c
      varid = ncvid (ncid,'phylr2',rcode)
      call ncvpt1 (ncid,varid,1,phylr2*day2sec,rcode)
c
c-----------------------------------------------------------------------
c  Write zooplankton grazing parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'grazrm',rcode)
      call ncvpt1 (ncid,varid,1,grazrm*day2sec,rcode)
c
      varid = ncvid (ncid,'civlev',rcode)
      call ncvpt1 (ncid,varid,1,civlev,rcode)
c
      varid = ncvid (ncid,'zooexcn',rcode)
      call ncvpt1 (ncid,varid,1,zooexcn,rcode)
c
      varid = ncvid (ncid,'zooexcd',rcode)
      call ncvpt1 (ncid,varid,1,zooexcd,rcode)
c
c-----------------------------------------------------------------------
c  Write zooplankton loss rate parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'zoolr1',rcode)
      call ncvpt1 (ncid,varid,1,zoolr1*day2sec,rcode)
c
      varid = ncvid (ncid,'zoolr2',rcode)
      call ncvpt1 (ncid,varid,1,zoolr2*day2sec,rcode)
c
      varid = ncvid (ncid,'zoolf1',rcode)
      call ncvpt1 (ncid,varid,1,zoolf1,rcode)
c
      varid = ncvid (ncid,'zoolf2',rcode)
      call ncvpt1 (ncid,varid,1,zoolf2,rcode)
c
c-----------------------------------------------------------------------
c  Write sinking rate parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'wsnkphy',rcode)
      call ncvpt1 (ncid,varid,1,wsnkphy*day2sec*cm2m,rcode)
c
      varid = ncvid (ncid,'wsnkdet',rcode)
      call ncvpt1 (ncid,varid,1,wsnkdet*day2sec*cm2m,rcode)
c
c-----------------------------------------------------------------------
c  Write remineralization parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'fracrmn',rcode)
      call ncvpt1 (ncid,varid,1,fracrmn,rcode)
c
      varid = ncvid (ncid,'remnnh4',rcode)
      call ncvpt1 (ncid,varid,1,remnnh4*day2sec,rcode)
c
      varid = ncvid (ncid,'remndet',rcode)
      call ncvpt1 (ncid,varid,1,remndet*day2sec,rcode)
c
c-----------------------------------------------------------------------
c  Write positive insurance parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'biopos',rcode)
      call ncvpt1 (ncid,varid,1,biopos,rcode)
c
#if defined codunlim | defined codlim
c-----------------------------------------------------------------------
c  Write cod behavior parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'cdzmin',rcode)
      call ncvpt1 (ncid,varid,1,cdzmin*cm2m,rcode)
c
      varid = ncvid (ncid,'cdzmax',rcode)
      call ncvpt1 (ncid,varid,1,cdzmax*cm2m,rcode)
c
      varid = ncvid (ncid,'cdkz',rcode)
      call ncvpt1 (ncid,varid,1,cdkz,rcode)
c
      varid = ncvid (ncid,'cdkp',rcode)
      call ncvpt1 (ncid,varid,1,cdkp,rcode)
c
      varid = ncvid (ncid,'cdtmin',rcode)
      call ncvpt1 (ncid,varid,1,cdtmin,rcode)
c
      varid = ncvid (ncid,'cdtmax',rcode)
      call ncvpt1 (ncid,varid,1,cdtmax,rcode)
c
      varid = ncvid (ncid,'cdkt',rcode)
      call ncvpt1 (ncid,varid,1,cdkt,rcode)
#  ifdef codlim
c
      varid = ncvid (ncid,'cdspd',rcode)
      call ncvpt1 (ncid,varid,1,cdspd,rcode)
#  endif
c
      varid = ncvid (ncid,'cdwmax',rcode)
      call ncvpt1 (ncid,varid,1,cdwmax,rcode)
c
#endif
      return
      end
