      subroutine putbparm (ncid)
c
c=======================================================================
c                                                                    ===
c  This routine defines the biological parameters to the output      ===
c  netCDF file.  This particular version does so for the             ===
c  Fasham model.                                                     ===
c                                                                    ===
c  ------                                                            ===
c  Input:                                                            ===
c  ------                                                            ===
c                                                                    ===
c     NCID     Identifier for output netCDF file.   (integer)        ===
c     VARTYP   NetCDF code for real variables.      (integer)        ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global data.
c-----------------------------------------------------------------------
c
#include <cdefs.h>
#include <param.h>
#include <pconst.h>
#include <cbiopnh.h>
#include <rhomean.h>
#include <cvmix.h>
#include <netcdf.inc>
#include <pe_netcdf.h>
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      integer ncid
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define light parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'attphy',rcode)
      call ncvpt1 (ncid,varid,1,attphy*m2cm,rcode)
c
      varid = ncvid (ncid,'parfrac',rcode)
      call ncvpt1 (ncid,varid,1,parfrac,rcode)
c
c-----------------------------------------------------------------------
c  Define phytoplankton growth parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'phygrth',rcode)
      call ncvpt1 (ncid,varid,1,phygrth*day2sec*c1e6/(rho0*cp),rcode)
c
      varid = ncvid (ncid,'phyexud',rcode)
      call ncvpt1 (ncid,varid,1,phyexud,rcode)
c
      varid = ncvid (ncid,'phylr1',rcode)
      call ncvpt1 (ncid,varid,1,phylr1*day2sec,rcode)
c
c-----------------------------------------------------------------------
c  Define temperature dependence parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'grthpa',rcode)
      call ncvpt1 (ncid,varid,1,grthpa*day2sec,rcode)
c
      varid = ncvid (ncid,'grthpb',rcode)
      call ncvpt1 (ncid,varid,1,grthpb,rcode)
c
      varid = ncvid (ncid,'grthpc',rcode)
      call ncvpt1 (ncid,varid,1,grthpc,rcode)
c
c-----------------------------------------------------------------------
c  Define nutrient uptake parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'hsno3',rcode)
      call ncvpt1 (ncid,varid,1,hsno3,rcode)
c
      varid = ncvid (ncid,'hsnh4',rcode)
      call ncvpt1 (ncid,varid,1,hsnh4,rcode)
c
      varid = ncvid (ncid,'no3inh',rcode)
      call ncvpt1 (ncid,varid,1,no3inh,rcode)
c
c-----------------------------------------------------------------------
c  Define zooplankton grazing parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'zgrazr',rcode)
      call ncvpt1 (ncid,varid,1,zgrazr*day2sec,rcode)
c
      varid = ncvid (ncid,'zgrazk',rcode)
      call ncvpt1 (ncid,varid,1,zgrazk,rcode)
c
      varid = ncvid (ncid,'zasseff',rcode)
      call ncvpt1 (ncid,varid,1,zasseff,rcode)
c
      varid = ncvid (ncid,'prefphy',rcode)
      call ncvpt1 (ncid,varid,1,prefphy,rcode)
c
      varid = ncvid (ncid,'prefbac',rcode)
      call ncvpt1 (ncid,varid,1,prefbac,rcode)
c
      varid = ncvid (ncid,'prefpon',rcode)
      call ncvpt1 (ncid,varid,1,prefpon,rcode)
c
c-----------------------------------------------------------------------
c  Define zooplankton loss rate parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'zexcrr',rcode)
      call ncvpt1 (ncid,varid,1,zexcrr*day2sec,rcode)
c
      varid = ncvid (ncid,'zexcnh4',rcode)
      call ncvpt1 (ncid,varid,1,zexcnh4,rcode)
c
      varid = ncvid (ncid,'zmortr',rcode)
      call ncvpt1 (ncid,varid,1,zmortr*day2sec,rcode)
c
      varid = ncvid (ncid,'zmortex',rcode)
      call ncvpt1 (ncid,varid,1,zmortex,rcode)
c
c-----------------------------------------------------------------------
c  Define bacterial growth parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'bacgrr',rcode)
      call ncvpt1 (ncid,varid,1,bacgrr*day2sec,rcode)
c
      varid = ncvid (ncid,'bacgrk',rcode)
      call ncvpt1 (ncid,varid,1,bacgrk,rcode)
c
      varid = ncvid (ncid,'bacfrac',rcode)
      call ncvpt1 (ncid,varid,1,bacfrac,rcode)
c
      varid = ncvid (ncid,'bexcrr',rcode)
      call ncvpt1 (ncid,varid,1,bexcrr*day2sec,rcode)
c
c-----------------------------------------------------------------------
c  Define PON parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'wsnkpon',rcode)
      call ncvpt1 (ncid,varid,1,wsnkpon*cm2m*day2sec,rcode)
c
      varid = ncvid (ncid,'brknpon',rcode)
      call ncvpt1 (ncid,varid,1,brknpon*day2sec,rcode)
c
c-----------------------------------------------------------------------
c  Define remineralization parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'rmnbio',rcode)
      call ncvpt1 (ncid,varid,1,rmnbio*day2sec,rcode)
c
      varid = ncvid (ncid,'rmnpon1',rcode)
      call ncvpt1 (ncid,varid,1,rmnpon1*day2sec,rcode)
c
      varid = ncvid (ncid,'rmnpon2',rcode)
      call ncvpt1 (ncid,varid,1,rmnpon2*day2sec,rcode)
c
      varid = ncvid (ncid,'rmnnh4',rcode)
      call ncvpt1 (ncid,varid,1,rmnnh4*day2sec,rcode)
c
c-----------------------------------------------------------------------
c  Define euphotic zone parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'sbldep',rcode)
      call ncvpt1 (ncid,varid,1,sbldep*cm2m,rcode)
c
c-----------------------------------------------------------------------
c  Define positive insurance parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'biopos',rcode)
      call ncvpt1 (ncid,varid,1,biopos,rcode)
c
#if defined codunlim | defined codlim
c-----------------------------------------------------------------------
c  Write cod behavior parameters.
c-----------------------------------------------------------------------
c
      varid = ncvid (ncid,'cdzmin',rcode)
      call ncvpt1 (ncid,varid,1,cdzmin*cm2m,rcode)
c
      varid = ncvid (ncid,'cdzmax',rcode)
      call ncvpt1 (ncid,varid,1,cdzmax*cm2m,rcode)
c
      varid = ncvid (ncid,'cdkz',rcode)
      call ncvpt1 (ncid,varid,1,cdkz,rcode)
c
      varid = ncvid (ncid,'cdkp',rcode)
      call ncvpt1 (ncid,varid,1,cdkp,rcode)
c
      varid = ncvid (ncid,'cdtmin',rcode)
      call ncvpt1 (ncid,varid,1,cdtmin,rcode)
c
      varid = ncvid (ncid,'cdtmax',rcode)
      call ncvpt1 (ncid,varid,1,cdtmax,rcode)
c
      varid = ncvid (ncid,'cdkt',rcode)
      call ncvpt1 (ncid,varid,1,cdkt,rcode)
#  ifdef codlim
c
      varid = ncvid (ncid,'cdspd',rcode)
      call ncvpt1 (ncid,varid,1,cdspd,rcode)
#  endif
c
      varid = ncvid (ncid,'cdwmax',rcode)
      call ncvpt1 (ncid,varid,1,cdwmax,rcode)
c
#endif
      return
      end
